/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.lang.ecmascript6.resolve.ES6ImportHandler;
import com.intellij.lang.ecmascript6.resolve.ES6PsiUtil;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandler;
import com.intellij.lang.javascript.ecmascript6.TypeScriptImportHandlerContext;
import com.intellij.lang.javascript.ecmascript6.TypeScriptModuleDeclarationsProcessor;
import com.intellij.lang.javascript.ecmascript6.TypeScriptUtil;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSField;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSQualifiedNameImpl;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptEnum;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptExportAssignment;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptGlobalModuleExportDeclaration;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptImplicitModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptModule;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptTypeMember;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.lang.javascript.psi.resolve.ES6QualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSQualifiedNameResolver;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.TypeScriptLocalClassIndex;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptAugmentationUtil;
import com.intellij.lang.typescript.resolve.TypeScriptClassResolver;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptQualifiedNameResolver
extends JSQualifiedNameResolver {
    @NotNull
    private final PsiElement myContext;
    private final boolean myIsTypeContext;
    private final boolean myIncludeAugmentations;
    @NotNull
    private final Set<Pair<JSQualifiedName, PsiElement>> myVisited;

    public TypeScriptQualifiedNameResolver(@NotNull PsiElement context, boolean isTypeContext, boolean includeAugmentations, @NotNull Set<Pair<JSQualifiedName, PsiElement>> visited) {
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(0);
        }
        if (visited == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(1);
        }
        this.myContext = context;
        this.myIsTypeContext = isTypeContext;
        this.myIncludeAugmentations = includeAugmentations;
        this.myVisited = visited;
    }

    @Override
    @NotNull
    public Collection<PsiElement> resolveQualifiedName(@NotNull String qName) {
        if (qName == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(2);
        }
        JSQualifiedNameImpl qualifiedName = JSQualifiedNameImpl.fromQualifiedName(qName);
        final THashSet result = new THashSet();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.currentScope = this.myContext;
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                result.add((Object)qualifierResult);
                return false;
            }

            @Override
            public boolean isDone() {
                return false;
            }
        };
        visitor.processQualifier(qualifiedName);
        THashSet tHashSet = result;
        if (tHashSet == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(3);
        }
        return tHashSet;
    }

    @Override
    @NotNull
    protected TypeScriptQualifiedNameResolver createNestedResolver(@NotNull PsiElement newContext) {
        if (newContext == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(4);
        }
        TypeScriptQualifiedNameResolver typeScriptQualifiedNameResolver = new TypeScriptQualifiedNameResolver(newContext, this.myIsTypeContext, this.myIncludeAugmentations, this.myVisited);
        if (typeScriptQualifiedNameResolver == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(5);
        }
        return typeScriptQualifiedNameResolver;
    }

    public String resolveName(@NotNull String qName) {
        if (qName == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(6);
        }
        final Ref resultValue = new Ref();
        SubTypeVisitor visitor = new SubTypeVisitor();
        visitor.currentScope = this.myContext;
        visitor.parent = new TypeScriptHierarchyVisitor(){

            @Override
            public boolean accept(PsiElement qualifierResult) {
                if (qualifierResult instanceof JSQualifiedNamedElement) {
                    resultValue.set((Object)((JSQualifiedNamedElement)qualifierResult));
                    return true;
                }
                return false;
            }

            @Override
            public boolean isDone() {
                return resultValue.get() != null;
            }
        };
        JSQualifiedNameImpl name = JSQualifiedNameImpl.fromQualifiedName(qName);
        visitor.processQualifier(name);
        return resultValue.get() == null ? "" : ((JSQualifiedNamedElement)resultValue.get()).getQualifiedName();
    }

    @NotNull
    private Collection<? extends PsiElement> getElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(7);
        }
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(8);
        }
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(9);
        }
        Collection<? extends PsiElement> collection = context.isLocalResolve() ? this.getLocalElements(name, source, context.getSource(), context.isQualifier()) : this.getGlobalElements(name, source, context);
        if (collection == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(10);
        }
        return collection;
    }

    @Override
    protected boolean isStrictTypeContext() {
        return this.myIsTypeContext;
    }

    @NotNull
    private Collection<? extends PsiElement> getGlobalElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        PsiElement parent;
        JSElement moduleParent;
        Collection<? extends PsiElement> localClasses;
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(11);
        }
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(12);
        }
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(13);
        }
        if ((localClasses = TypeScriptQualifiedNameResolver.getLocalClassesIfExists(name, source, context, (PsiElement)(moduleParent = ES6PsiUtil.getNonStrictExportScope(source)), parent = source.getParent())) != null) {
            ArrayList elements = ContainerUtil.newArrayList(localClasses);
            this.addMergedAndGlobalElements(TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, (PsiElement)moduleParent), source, context, elements, true);
            ArrayList arrayList = elements;
            if (arrayList == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(14);
            }
            return arrayList;
        }
        boolean isParentExternalFileModule = TypeScriptQualifiedNameResolver.isExternalFileModule((PsiElement)moduleParent);
        boolean isModule = moduleParent instanceof TypeScriptModule || isParentExternalFileModule;
        TypeScriptModuleDeclarationsProcessor processor = ES6QualifiedNameResolver.createProcessor(name, this.myIsTypeContext, false);
        PsiElement realPlace = TypeScriptQualifiedNameResolver.getRealSource(source, context);
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        JSElement module = moduleParent;
        while (module != null) {
            if (!(module instanceof JSElement)) {
                LinkedHashSet linkedHashSet = result;
                if (linkedHashSet == null) {
                    TypeScriptQualifiedNameResolver.$$$reportNull$$$0(15);
                }
                return linkedHashSet;
            }
            TypeScriptQualifiedNameResolver.processES6DeclarationsInScope(module, processor, ResolveState.initial(), (PsiElement)moduleParent, realPlace, !context.isQualifier());
            List<PsiElement> possibleResults = processor.getResults();
            if (possibleResults != null) {
                if (isParentExternalFileModule && !possibleResults.isEmpty()) {
                    TypeScriptQualifiedNameResolver.addMergedElementsFromAugmentations((PsiElement)module, possibleResults, realPlace, processor, !context.isQualifier());
                    ArrayList results = ContainerUtil.newArrayList(processor.getResults());
                    TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(source, results);
                    ArrayList arrayList = results;
                    if (arrayList == null) {
                        TypeScriptQualifiedNameResolver.$$$reportNull$$$0(16);
                    }
                    return arrayList;
                }
                Collection<PsiElement> localElements = TypeScriptQualifiedNameResolver.getLocalElements((PsiElement)module, possibleResults);
                if (!context.isQualifier() && isModule && !ContainerUtil.isEmpty(localElements)) {
                    Collection<PsiElement> collection = localElements;
                    if (collection == null) {
                        TypeScriptQualifiedNameResolver.$$$reportNull$$$0(17);
                    }
                    return collection;
                }
                result.addAll(possibleResults);
            }
            String qName = TypeScriptQualifiedNameResolver.getQualifiedNameForModule(name, (PsiElement)module);
            this.addMergedAndGlobalElements(qName, source, context, result, false);
            if (!context.isQualifier() && !result.isEmpty()) break;
            module = ES6PsiUtil.getExportScope((PsiElement)module);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(18);
        }
        return linkedHashSet;
    }

    @Nullable
    private static Collection<PsiElement> getLocalElements(@NotNull PsiElement module, @NotNull List<? extends PsiElement> possibleResults) {
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(19);
        }
        if (possibleResults == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(20);
        }
        ArrayList notPublic = null;
        for (PsiElement psiElement : possibleResults) {
            JSAttributeList list;
            if (!(psiElement instanceof JSAttributeListOwner) || (list = ((JSAttributeListOwner)psiElement).getAttributeList()) == null || list.getAccessType() == JSAttributeList.AccessType.PUBLIC || TypeScriptQualifiedNameResolver.isRealModuleOfImplicitModule(module, psiElement)) continue;
            if (notPublic == null) {
                notPublic = ContainerUtil.newArrayList();
            }
            notPublic.add(psiElement);
        }
        return notPublic;
    }

    private static boolean isExternalFileModule(PsiElement module) {
        return module instanceof JSFile && ((JSFile)module).isCommonJSModule() || ES6PsiUtil.isEmbeddedModule(module);
    }

    @NotNull
    private static PsiElement getRealSource(@NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context) {
        PsiElement realPlace;
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(21);
        }
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(22);
        }
        if ((realPlace = context.getSource()) == null) {
            realPlace = source;
        }
        PsiElement psiElement = realPlace;
        if (psiElement == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(23);
        }
        return psiElement;
    }

    @Nullable
    private static Collection<? extends PsiElement> getLocalClassesIfExists(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptImportHandlerContext context, @Nullable PsiElement module, @Nullable PsiElement parent) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(24);
        }
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(25);
        }
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(26);
        }
        if (module == parent || module == source || context.isQualifier()) {
            return null;
        }
        if (TypeScriptQualifiedNameResolver.isAmbientModule(module)) {
            return null;
        }
        Collection elements = StubIndex.getElements(TypeScriptLocalClassIndex.KEY, (Object)name, (Project)source.getProject(), (GlobalSearchScope)GlobalSearchScope.fileScope((PsiFile)source.getContainingFile()), JSQualifiedNamedElement.class);
        if (elements.size() == 0) {
            return null;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (PsiElement currentParent = source; currentParent != module && currentParent != null && !TypeScriptPsiUtil.isTopLevelContainerMember(currentParent); currentParent = currentParent.getParent()) {
            if (currentParent instanceof JSClass && StringUtil.equals((CharSequence)((JSClass)currentParent).getName(), (CharSequence)name)) {
                result.add(currentParent);
            } else if (currentParent instanceof JSElement && TypeScriptQualifiedNameResolver.isClassScopeElement(currentParent)) {
                for (JSElement element : JSResolveUtil.findNamedElementsInScope(name, (JSElement)currentParent)) {
                    if (!(element instanceof JSClass)) continue;
                    result.add(element);
                }
            }
            if (result.isEmpty()) continue;
            return result;
        }
        return null;
    }

    private static boolean isAmbientModule(@Nullable PsiElement module) {
        VirtualFile file;
        if (module instanceof TypeScriptModule && TypeScriptPsiUtil.isAmbientDeclaration(module)) {
            return true;
        }
        return module instanceof JSFile && (file = PsiUtilCore.getVirtualFile((PsiElement)module)) != null && TypeScriptUtil.isDefinitionFile(file);
    }

    private static boolean isClassScopeElement(PsiElement currentParent) {
        return currentParent instanceof JSBlockStatement || currentParent instanceof TypeScriptModule || currentParent instanceof JSFile || currentParent instanceof TypeScriptFunction && !(currentParent instanceof TypeScriptTypeMember);
    }

    private void addMergedAndGlobalElements(@NotNull String qName, @NotNull PsiElement currentSource, @NotNull TypeScriptImportHandlerContext context, @NotNull Collection<PsiElement> result, boolean modulesOnly) {
        if (qName == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(27);
        }
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(28);
        }
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(29);
        }
        if (result == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(30);
        }
        PsiElement realSource = TypeScriptQualifiedNameResolver.getRealSource(currentSource, context);
        Collection<JSQualifiedNamedElement> elementsByQName = TypeScriptClassResolver.getInstance().findElementsByQNameFilteredByConfig(qName, realSource);
        Condition condition = element -> {
            if (currentSource == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(51);
            }
            if (context == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(52);
            }
            if (result == null) {
                TypeScriptQualifiedNameResolver.$$$reportNull$$$0(53);
            }
            return TypeScriptQualifiedNameResolver.isAcceptableMergeSymbol(element, currentSource, context, result, modulesOnly);
        };
        List filteredElements = ContainerUtil.filter(elementsByQName, (Condition)condition);
        result.addAll(filteredElements);
        if (this.myIncludeAugmentations) {
            TypeScriptQualifiedNameResolver.addAugmentationsForModuleResults(currentSource, result);
        }
    }

    private static void addMergedElementsFromAugmentations(@NotNull PsiElement externalModule, @NotNull List<? extends PsiElement> possibleResults, @NotNull PsiElement realPlace, @NotNull PsiScopeProcessor processor, boolean isLastReference) {
        if (externalModule == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(31);
        }
        if (possibleResults == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(32);
        }
        if (realPlace == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(33);
        }
        if (processor == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(34);
        }
        boolean needAugmentations = false;
        for (PsiElement psiElement : possibleResults) {
            if (!ES6ImportHandler.isExported(psiElement)) continue;
            needAugmentations = true;
            break;
        }
        if (!needAugmentations) {
            return;
        }
        Collection<PsiElement> augmentations = TypeScriptAugmentationUtil.getAugmentations(realPlace, ContainerUtil.createMaybeSingletonList((Object)externalModule));
        for (PsiElement augmentation : augmentations) {
            TypeScriptQualifiedNameResolver.processES6DeclarationsInScope((JSElement)augmentation, processor, ResolveState.initial(), augmentation, realPlace, isLastReference);
        }
    }

    private static boolean isAcceptableMergeSymbol(@NotNull JSQualifiedNamedElement element, @NotNull PsiElement currentSource, @NotNull TypeScriptImportHandlerContext context, @NotNull Collection<PsiElement> result, boolean modulesOnly) {
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(35);
        }
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(36);
        }
        if (context == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(37);
        }
        if (result == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(38);
        }
        if (result.contains(element)) {
            return false;
        }
        PsiElement source = TypeScriptQualifiedNameResolver.getRealSource(currentSource, context);
        if (element instanceof TypeScriptGlobalModuleExportDeclaration) {
            return true;
        }
        if (modulesOnly && !(element instanceof TypeScriptModule)) {
            return false;
        }
        if (!ES6PsiUtil.isElementCanBeExported((PsiElement)element)) {
            return false;
        }
        if (element instanceof JSClass && !element.isNamespaceExplicitlyDeclared()) {
            return false;
        }
        PsiElement externalModule = ES6PsiUtil.findExternalModule((PsiElement)element);
        if (externalModule == null) {
            return TypeScriptImportHandler.checkModulesAccess(source, (PsiElement)element);
        }
        PsiElement externalSourceModule = ES6PsiUtil.findExternalModule(currentSource);
        if (!(TypeScriptQualifiedNameResolver.externalModulesEqual(externalModule, externalSourceModule) || TypeScriptQualifiedNameResolver.checkAugmentationAccess((PsiElement)element, externalModule, source) || TypeScriptQualifiedNameResolver.checkGlobalAugmentation((PsiElement)element))) {
            return false;
        }
        return TypeScriptImportHandler.checkModulesAccess(source, (PsiElement)element) && ES6ImportHandler.isExported((PsiElement)element);
    }

    private static boolean checkGlobalAugmentation(@NotNull PsiElement element) {
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(39);
        }
        JSElement scope = ES6PsiUtil.getExportScope(element);
        while (scope instanceof TypeScriptModule && !((TypeScriptModule)scope).isGlobalScopeAugmentation()) {
            scope = ES6PsiUtil.getExportScope((PsiElement)scope);
        }
        return scope instanceof TypeScriptModule && ((TypeScriptModule)scope).isGlobalScopeAugmentation();
    }

    private static boolean externalModulesEqual(@Nullable PsiElement module, @Nullable PsiElement sourceModule) {
        if (module == sourceModule) {
            return true;
        }
        if (module == null) {
            return false;
        }
        if (module.isEquivalentTo(sourceModule)) {
            return true;
        }
        if (module instanceof TypeScriptModule && sourceModule instanceof TypeScriptModule) {
            String qName = ((TypeScriptModule)module).getQualifiedName();
            return qName != null && qName.equals(((TypeScriptModule)sourceModule).getQualifiedName());
        }
        return false;
    }

    private static void addAugmentationsForModuleResults(@NotNull PsiElement currentSource, @NotNull Collection<PsiElement> result) {
        Collection<PsiElement> externalModules;
        if (currentSource == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(40);
        }
        if (result == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(41);
        }
        if (result.size() > 0 && !(externalModules = TypeScriptQualifiedNameResolver.getModulesForAugmentations(result)).isEmpty()) {
            result.addAll(TypeScriptAugmentationUtil.getAugmentations(currentSource, externalModules));
        }
    }

    private static Collection<PsiElement> getModulesForAugmentations(@NotNull Collection<PsiElement> result) {
        if (result == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(42);
        }
        ArrayList modules = ContainerUtil.newArrayList();
        for (PsiElement element : result) {
            TypeScriptModule typeScriptModule;
            String refName;
            TypeScriptExportAssignment assignment;
            PsiElement module;
            if (ES6PsiUtil.isExternalModule(element)) {
                modules.add(element);
                continue;
            }
            if (!(element instanceof TypeScriptModule) || !((TypeScriptModule)element).isInternal() || (module = ES6PsiUtil.findExternalModule(element)) == null || (assignment = TypeScriptPsiUtil.findExportAssignment(module)) == null || !StringUtil.equals((CharSequence)(refName = assignment.getInitializerReference()), (CharSequence)TypeScriptQualifiedNameResolver.getQualifiedNameWithoutParentModule(typeScriptModule = (TypeScriptModule)element, module))) continue;
            modules.add(module);
        }
        return modules;
    }

    @Nullable
    private static String getQualifiedNameWithoutParentModule(@NotNull TypeScriptModule module, @NotNull PsiElement externalModule) {
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(43);
        }
        if (externalModule == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(44);
        }
        String moduleQualifiedName = module.getQualifiedName();
        if (externalModule instanceof TypeScriptModule) {
            String name = ((TypeScriptModule)externalModule).getQualifiedName();
            if (moduleQualifiedName == null || name == null) {
                return moduleQualifiedName;
            }
            int indexOfExternalModule = moduleQualifiedName.indexOf(name);
            if (indexOfExternalModule != -1) {
                int position = indexOfExternalModule + name.length() + 1;
                return position < moduleQualifiedName.length() ? moduleQualifiedName.substring(position) : moduleQualifiedName;
            }
        }
        return moduleQualifiedName;
    }

    private static String getQualifiedNameForModule(@NotNull String name, PsiElement module) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(45);
        }
        return module instanceof TypeScriptModule ? ((TypeScriptModule)module).getQualifiedName() + "." + name : name;
    }

    private static boolean isRealModuleOfImplicitModule(PsiElement module, PsiElement element) {
        return module instanceof TypeScriptImplicitModule && ((TypeScriptImplicitModule)module).getRealModule() == element;
    }

    public static boolean checkAugmentationAccess(@NotNull PsiElement element, @NotNull PsiElement module, @Nullable PsiElement source) {
        PsiElement sourceContainer;
        if (element == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(46);
        }
        if (module == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(47);
        }
        if (TypeScriptPsiUtil.isAugmentationModule(element)) {
            return true;
        }
        if (source instanceof TypeScriptModule) {
            sourceContainer = source;
        } else {
            JSElement jSElement = sourceContainer = source == null ? null : ES6PsiUtil.getExportScope(source);
        }
        return module.isEquivalentTo(sourceContainer) || module instanceof JSQualifiedNamedElement && sourceContainer instanceof JSQualifiedNamedElement && StringUtil.equals((CharSequence)((JSQualifiedNamedElement)module).getQualifiedName(), (CharSequence)((JSQualifiedNamedElement)sourceContainer).getQualifiedName()) || TypeScriptPsiUtil.isAugmentationModule(element) || TypeScriptPsiUtil.isAugmentationModule(element);
    }

    /*
     * WARNING - void declaration
     */
    private void findReferencedElements(@NotNull String name, @NotNull PsiElement source, @NotNull TypeScriptElementVisitor visitor) {
        if (name == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(48);
        }
        if (source == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(49);
        }
        if (visitor == null) {
            TypeScriptQualifiedNameResolver.$$$reportNull$$$0(50);
        }
        if (source instanceof TypeScriptEnum) {
            void var6_9;
            JSField[] jSFieldArray = ((TypeScriptEnum)source).getFields();
            int n = jSFieldArray.length;
            boolean bl = false;
            while (var6_9 < n) {
                JSField member = jSFieldArray[var6_9];
                if (name.equals(member.getName())) {
                    visitor.accept((PsiElement)member);
                    return;
                }
                ++var6_9;
            }
            return;
        }
        Collection<? extends PsiElement> localResults = this.getElements(name, source, visitor);
        for (PsiElement psiElement : localResults) {
            if (this.myIsTypeContext && !TypeScriptPsiUtil.isNamedTypeContainerDefinition(psiElement)) continue;
            Collection<PsiElement> elements = this.expandElement(psiElement);
            for (PsiElement psiElement2 : elements) {
                if (!visitor.accept(psiElement2)) continue;
                return;
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visited";
                break;
            }
            case 2: 
            case 6: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qName";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newContext";
                break;
            }
            case 7: 
            case 11: 
            case 24: 
            case 45: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 8: 
            case 12: 
            case 21: 
            case 25: 
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 19: 
            case 43: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 20: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleResults";
                break;
            }
            case 28: 
            case 36: 
            case 40: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentSource";
                break;
            }
            case 30: 
            case 38: 
            case 41: 
            case 42: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 31: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalModule";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "realPlace";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 35: 
            case 39: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "resolveQualifiedName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createNestedResolver";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getElements";
                break;
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getGlobalElements";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getRealSource";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resolveQualifiedName";
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "createNestedResolver";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "resolveName";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getElements";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getGlobalElements";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getLocalElements";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getRealSource";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getLocalClassesIfExists";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addMergedAndGlobalElements";
                break;
            }
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addMergedElementsFromAugmentations";
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "isAcceptableMergeSymbol";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "checkGlobalAugmentation";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "addAugmentationsForModuleResults";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getModulesForAugmentations";
                break;
            }
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameWithoutParentModule";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "getQualifiedNameForModule";
                break;
            }
            case 46: 
            case 47: {
                objectArray = objectArray;
                objectArray[2] = "checkAugmentationAccess";
                break;
            }
            case 48: 
            case 49: 
            case 50: {
                objectArray = objectArray;
                objectArray[2] = "findReferencedElements";
                break;
            }
            case 51: 
            case 52: 
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addMergedAndGlobalElements$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 10: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 23: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public final class SubTypeVisitor
    implements TypeScriptHierarchyVisitor {
        private TypeScriptHierarchyVisitor parent;
        private PsiElement currentScope;
        private String name;
        private boolean isQualifier = false;

        private TypeScriptElementVisitor createSimpleExpressionVisitor(final boolean localResolve) {
            return new TypeScriptElementVisitor(){
                private THashSet<PsiElement> accepted;
                private final boolean isLocalResolve;
                {
                    this.isLocalResolve = localResolve;
                }

                @Override
                public boolean isLocalResolve() {
                    return this.isLocalResolve;
                }

                @Override
                public boolean accept(PsiElement element) {
                    if (this.accepted == null) {
                        this.accepted = new THashSet();
                    }
                    if (!this.accepted.add((Object)element)) {
                        return false;
                    }
                    return SubTypeVisitor.this.parent.accept(element);
                }

                @Override
                public PsiElement getSource() {
                    return SubTypeVisitor.this.currentScope;
                }

                @Override
                public boolean isQualifier() {
                    return SubTypeVisitor.this.isQualifier;
                }
            };
        }

        @Override
        public boolean accept(PsiElement qualifierResult) {
            if (qualifierResult instanceof TypeScriptModule || qualifierResult instanceof JSFile || qualifierResult instanceof TypeScriptEnum) {
                TypeScriptQualifiedNameResolver.this.findReferencedElements(this.name, qualifierResult, this.createSimpleExpressionVisitor(true));
            }
            return this.parent.isDone();
        }

        public SubTypeVisitor createSubVisitor() {
            SubTypeVisitor visitor = new SubTypeVisitor();
            visitor.parent = this;
            visitor.currentScope = this.currentScope;
            visitor.isQualifier = true;
            return visitor;
        }

        public void processQualifier(@NotNull JSQualifiedName qualifiedName) {
            if (qualifiedName == null) {
                SubTypeVisitor.$$$reportNull$$$0(0);
            }
            if (!TypeScriptQualifiedNameResolver.this.myVisited.add(Pair.create((Object)qualifiedName, (Object)this.currentScope))) {
                return;
            }
            this.name = qualifiedName.getName();
            JSQualifiedName qualifier = qualifiedName.getParent();
            if (qualifier != null) {
                this.createSubVisitor().processQualifier(qualifier);
            } else {
                TypeScriptQualifiedNameResolver.this.findReferencedElements(this.name, this.currentScope, this.createSimpleExpressionVisitor(false));
            }
        }

        @Override
        public boolean isDone() {
            return this.parent.isDone();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifiedName", "com/intellij/lang/javascript/ecmascript6/TypeScriptQualifiedNameResolver$SubTypeVisitor", "processQualifier"));
        }
    }

    static interface TypeScriptElementVisitor
    extends TypeScriptImportHandlerContext {
        public boolean accept(PsiElement var1);
    }

    static interface TypeScriptHierarchyVisitor {
        public boolean accept(PsiElement var1);

        public boolean isDone();
    }
}

