/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.ecmascript6;

import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSFile;
import com.intellij.lang.javascript.validation.JSAnnotatorProblemReporter;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.typescript.validation.TypeScriptFunctionSignatureChecker;
import com.intellij.lang.typescript.validation.TypeScriptTypeChecker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeScriptAnnotatorCheckerProvider {
    private static final TypeScriptAnnotatorCheckerProvider DEFAULT = new TypeScriptAnnotatorCheckerProvider();
    public static final ExtensionPointName<TypeScriptAnnotatorCheckerProvider> EP = ExtensionPointName.create((String)"JavaScript.TypeScriptAnnotatorCheckerProvider");
    public static final HighlightSeverity TS_INFORMATION = new HighlightSeverity("TS Annotation info", HighlightSeverity.ERROR.myVal);

    @NotNull
    public static TypeScriptAnnotatorCheckerProvider getCheckerProvider(PsiElement context) {
        Project project = context.getProject();
        if (!Extensions.getArea((AreaInstance)project).hasExtensionPoint(EP.getName())) {
            TypeScriptAnnotatorCheckerProvider typeScriptAnnotatorCheckerProvider = DEFAULT;
            if (typeScriptAnnotatorCheckerProvider == null) {
                TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(0);
            }
            return typeScriptAnnotatorCheckerProvider;
        }
        for (TypeScriptAnnotatorCheckerProvider provider : (TypeScriptAnnotatorCheckerProvider[])EP.getExtensions((AreaInstance)project)) {
            if (!provider.isAvailable(context)) continue;
            TypeScriptAnnotatorCheckerProvider typeScriptAnnotatorCheckerProvider = provider;
            if (typeScriptAnnotatorCheckerProvider == null) {
                TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(1);
            }
            return typeScriptAnnotatorCheckerProvider;
        }
        TypeScriptAnnotatorCheckerProvider typeScriptAnnotatorCheckerProvider = DEFAULT;
        if (typeScriptAnnotatorCheckerProvider == null) {
            TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(2);
        }
        return typeScriptAnnotatorCheckerProvider;
    }

    @NotNull
    public JSAnnotatorProblemReporter getProblemReporter(final @NotNull AnnotationHolder holder) {
        if (holder == null) {
            TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(3);
        }
        JSAnnotatorProblemReporter jSAnnotatorProblemReporter = new JSAnnotatorProblemReporter(holder){

            @Override
            protected Annotation registerProblem(@Nullable PsiElement nameIdentifier, @Nullable TextRange range, String message, @Nullable ProblemHighlightType type, @Nullable String inspectionId, @Nullable LocalQuickFix[] fixes, @NotNull IntentionAction[] intentionActions) {
                if (intentionActions == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (TypeScriptAnnotatorCheckerProvider.this.skipErrors() && nameIdentifier != null) {
                    if (range == null) {
                        range = nameIdentifier.getTextRange();
                    }
                    HighlightDisplayKey displayKey = inspectionId != null ? HighlightDisplayKey.find((String)inspectionId) : null;
                    Annotation annotation = holder.createAnnotation(TypeScriptAnnotatorCheckerProvider.getSeverity(), range, null);
                    JSAnnotatorProblemReporter.registerIntentionAndFixes(nameIdentifier, fixes, intentionActions, annotation, nameIdentifier.getContainingFile(), displayKey);
                    return annotation;
                }
                if (TypeScriptAnnotatorCheckerProvider.this.isWarningOnly(nameIdentifier) && type != ProblemHighlightType.WEAK_WARNING) {
                    type = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                }
                return super.registerProblem(nameIdentifier, range, message, type, inspectionId, fixes, intentionActions);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "intentionActions", "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider$1", "registerProblem"));
            }
        };
        if (jSAnnotatorProblemReporter == null) {
            TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(4);
        }
        return jSAnnotatorProblemReporter;
    }

    @NotNull
    private static HighlightSeverity getSeverity() {
        HighlightSeverity highlightSeverity = ApplicationManager.getApplication().isUnitTestMode() ? HighlightSeverity.INFORMATION : TS_INFORMATION;
        if (highlightSeverity == null) {
            TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(5);
        }
        return highlightSeverity;
    }

    protected boolean isWarningOnly(@Nullable PsiElement currentElement) {
        if (currentElement == null) {
            return false;
        }
        PsiFile file = currentElement.getContainingFile();
        if (file instanceof JSFile) {
            return JSFixFactory.getInstance().typeScriptReferencePathValidator().hasOutOfProjectReferences((JSFile)file);
        }
        return false;
    }

    protected boolean skipErrors() {
        return false;
    }

    @NotNull
    public JSTypeChecker<Annotation> getTypeChecker(@NotNull JSProblemReporter<Annotation> reporter) {
        if (reporter == null) {
            TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(6);
        }
        TypeScriptTypeChecker typeScriptTypeChecker = new TypeScriptTypeChecker(reporter);
        if (typeScriptTypeChecker == null) {
            TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(7);
        }
        return typeScriptTypeChecker;
    }

    @NotNull
    public JSFunctionSignatureChecker getSignatureChecker(@NotNull JSProblemReporter<Annotation> reporter) {
        if (reporter == null) {
            TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(8);
        }
        TypeScriptFunctionSignatureChecker typeScriptFunctionSignatureChecker = new TypeScriptFunctionSignatureChecker(new TypeScriptTypeChecker(reporter));
        if (typeScriptFunctionSignatureChecker == null) {
            TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(9);
        }
        return typeScriptFunctionSignatureChecker;
    }

    protected boolean isAvailable(@NotNull PsiElement context) {
        if (context == null) {
            TypeScriptAnnotatorCheckerProvider.$$$reportNull$$$0(10);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reporter";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCheckerProvider";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/ecmascript6/TypeScriptAnnotatorCheckerProvider";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProblemReporter";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSeverity";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeChecker";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getSignatureChecker";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getProblemReporter";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getTypeChecker";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getSignatureChecker";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

