/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.dialects;

import com.intellij.lang.javascript.dialects.JSDialectsMappings;
import com.intellij.lang.javascript.dialects.JSLanguageLevel;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.library.JSCorePredefinedLibrariesProvider;
import com.intellij.lang.javascript.library.JSLibraryMappings;
import com.intellij.lang.javascript.settings.JSRootConfiguration;
import com.intellij.lang.javascript.settings.JSRootConfigurationBase;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.FilePropertyPusher;
import com.intellij.openapi.roots.impl.PushedFilePropertiesUpdater;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.messages.MessageBus;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSLanguageLevelPusher
implements FilePropertyPusher<JSLanguageLevel> {
    public static final Key<JSLanguageLevel> KEY = Key.create((String)"JS_LANGUAGE_LEVEL");
    private static final FileAttribute PERSISTENCE = new FileAttribute("js_language_level_persistence", 2, true);

    public void initExtra(@NotNull Project project, @NotNull MessageBus bus, @NotNull FilePropertyPusher.Engine languageLevelUpdater) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(0);
        }
        if (bus == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(1);
        }
        if (languageLevelUpdater == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(2);
        }
        this.updateJSLibraries(project);
    }

    @NotNull
    public Key<JSLanguageLevel> getFileDataKey() {
        Key<JSLanguageLevel> key = KEY;
        if (key == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(3);
        }
        return key;
    }

    public boolean pushDirectoriesOnly() {
        return true;
    }

    @NotNull
    public JSLanguageLevel getDefaultValue() {
        JSLanguageLevel jSLanguageLevel = JSLanguageLevel.DEFAULT;
        if (jSLanguageLevel == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(4);
        }
        return jSLanguageLevel;
    }

    @Nullable
    public JSLanguageLevel getImmediateValue(@NotNull Project project, @Nullable VirtualFile file) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(5);
        }
        return file == null ? JSRootConfiguration.getInstance(project).getLanguageLevel() : (JSLanguageLevel)((Object)JSDialectsMappings.getInstance(project).getImmediateMapping(file));
    }

    @Nullable
    public JSLanguageLevel getImmediateValue(@NotNull Module module) {
        if (module == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(6);
        }
        return null;
    }

    public boolean acceptsFile(@NotNull VirtualFile file) {
        if (file == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(7);
        }
        return false;
    }

    public boolean acceptsDirectory(@NotNull VirtualFile file, @NotNull Project project) {
        if (file == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(8);
        }
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(9);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void persistAttribute(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull JSLanguageLevel level) throws IOException {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(10);
        }
        if (fileOrDir == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(11);
        }
        if (level == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(12);
        }
        if (JSCorePredefinedLibrariesProvider.getAllJSPredefinedLibraryFiles().contains(fileOrDir)) {
            return;
        }
        DataInputStream iStream = PERSISTENCE.readAttribute(fileOrDir);
        JSLanguageLevel oldLanguageLevel = JSLanguageLevel.DEFAULT;
        if (iStream != null) {
            try {
                int oldLevelOrdinal = DataInputOutputUtilRt.readINT((DataInput)iStream);
                if (oldLevelOrdinal >= 0 && oldLevelOrdinal < JSLanguageLevel.values().length) {
                    oldLanguageLevel = JSLanguageLevel.values()[oldLevelOrdinal];
                }
                if (oldLevelOrdinal == level.ordinal()) {
                    return;
                }
            }
            finally {
                iStream.close();
            }
        }
        DataOutputStream oStream = PERSISTENCE.writeAttribute(fileOrDir);
        DataInputOutputUtilRt.writeINT((DataOutput)oStream, (int)level.ordinal());
        oStream.close();
        if (JSRootConfigurationBase.requiresReparse(oldLanguageLevel, level)) {
            PushedFilePropertiesUpdater.getInstance((Project)project).filePropertiesChanged(fileOrDir, JSLanguageLevelPusher::isIndexedFile);
        }
    }

    private static boolean isIndexedFile(VirtualFile child) {
        return !child.isDirectory() && JavaScriptIndex.ourIndexedFilesFilter.acceptInput(child);
    }

    public void afterRootsChanged(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(13);
        }
        this.updateJSLibraries(project);
    }

    public void updateJSLibraries(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(14);
        }
        if (project.isDefault()) {
            return;
        }
        JSLanguageLevel languageLevel = JSRootConfiguration.getInstance(project).getLanguageLevel();
        Collection<VirtualFile> files = this.getApplicableLibraryFiles(project);
        Logger.getInstance(JSLanguageLevelPusher.class).debug("Pushing " + (Object)((Object)languageLevel) + "\n" + StringUtil.join(files, (String)"\n"));
        Application application = ApplicationManager.getApplication();
        Runnable action = () -> {
            if (project == null) {
                JSLanguageLevelPusher.$$$reportNull$$$0(18);
            }
            application.runReadAction(() -> {
                if (project == null) {
                    JSLanguageLevelPusher.$$$reportNull$$$0(19);
                }
                if (project.isDisposed()) {
                    return;
                }
                for (VirtualFile file : files) {
                    if (!file.isValid()) continue;
                    this.markRecursively(project, file, languageLevel);
                }
            });
        };
        if (application.isUnitTestMode()) {
            action.run();
        } else {
            application.executeOnPooledThread(action);
        }
    }

    @NotNull
    public Collection<VirtualFile> getApplicableLibraryFiles(@NotNull Project project) {
        if (project == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(15);
        }
        JSLibraryMappings mappings = JSLibraryMappings.getInstance(project);
        ArrayList<VirtualFile> files = new ArrayList<VirtualFile>();
        for (ScriptingLibraryModel model : mappings.getMappings().values()) {
            if (model instanceof ScriptingLibraryMappings.CompoundLibrary) {
                for (ScriptingLibraryModel libraryModel : ((ScriptingLibraryMappings.CompoundLibrary)model).getLibraries()) {
                    files.addAll(libraryModel.getAllFiles());
                }
                continue;
            }
            files.addAll(model.getAllFiles());
        }
        files.addAll(JSCorePredefinedLibrariesProvider.getJavaScriptCorePredefinedLibraryFiles());
        ArrayList<VirtualFile> arrayList = files;
        if (arrayList == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    private void markRecursively(Project project, @NotNull VirtualFile file, JSLanguageLevel languageLevel) {
        if (file == null) {
            JSLanguageLevelPusher.$$$reportNull$$$0(17);
        }
        PushedFilePropertiesUpdater updater = PushedFilePropertiesUpdater.getInstance((Project)project);
        FileBasedIndex.iterateRecursively((VirtualFile)file, fileOrDir -> {
            updater.findAndUpdateValue(fileOrDir, (FilePropertyPusher)this, (Object)languageLevel);
            return true;
        }, (ProgressIndicator)ProgressManager.getInstance().getProgressIndicator(), (Set)new HashSet(), (ProjectFileIndex)ProjectRootManager.getInstance((Project)project).getFileIndex());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevelUpdater";
                break;
            }
            case 3: 
            case 4: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 7: 
            case 8: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/dialects/JSLanguageLevelPusher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileDataKey";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValue";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicableLibraryFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "initExtra";
                break;
            }
            case 3: 
            case 4: 
            case 16: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getImmediateValue";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "acceptsFile";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "acceptsDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "persistAttribute";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "afterRootsChanged";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateJSLibraries";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getApplicableLibraryFiles";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "markRecursively";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$updateJSLibraries$1";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

