/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm.rc;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskFetchException;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsService;
import com.intellij.lang.javascript.buildTools.npm.NpmScriptsStructure;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmCommand;
import com.intellij.lang.javascript.buildTools.npm.rc.NpmRunSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NpmRunConfigurationUtil {
    private NpmRunConfigurationUtil() {
    }

    public static void check(@NotNull Project project, @NotNull NpmRunSettings settings) throws RuntimeConfigurationError {
        String packageJsonPath;
        if (project == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(1);
        }
        if ((packageJsonPath = settings.getPackageJsonSystemIndependentPath()).isEmpty()) {
            throw new RuntimeConfigurationError("Please specify package.json");
        }
        File packageJson = new File(packageJsonPath);
        if (!packageJson.isAbsolute() || !packageJson.isFile()) {
            throw new RuntimeConfigurationError("Please specify package.json correctly");
        }
        if (settings.getCommand() == NpmCommand.RUN_SCRIPT) {
            NpmRunConfigurationUtil.validateScript(project, packageJsonPath, settings.getScriptNames());
        }
        NodeJsInterpreter interpreter = settings.getInterpreterRef().resolve(project);
        NodeJsLocalInterpreter.checkForRunConfiguration(interpreter);
    }

    private static void validateScript(@NotNull Project project, @NotNull String packageJsonPath, @NotNull List<String> scriptNames) throws RuntimeConfigurationError {
        if (project == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(2);
        }
        if (packageJsonPath == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(3);
        }
        if (scriptNames == null) {
            NpmRunConfigurationUtil.$$$reportNull$$$0(4);
        }
        if (scriptNames.isEmpty()) {
            throw new RuntimeConfigurationError("Please specify npm scripts to run");
        }
        VirtualFile packageJson = LocalFileSystem.getInstance().findFileByPath(packageJsonPath);
        if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory()) {
            try {
                NpmScriptsStructure structure = NpmScriptsService.getInstance().fetchBuildfileStructure(project, packageJson);
                for (String scriptName : scriptNames) {
                    if (structure.getTaskNames().contains(scriptName)) continue;
                    throw new RuntimeConfigurationError("No '" + scriptName + "' npm script");
                }
            }
            catch (JsbtTaskFetchException jsbtTaskFetchException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJsonPath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scriptNames";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/rc/NpmRunConfigurationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "check";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "validateScript";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

