/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.npm;

import com.intellij.ide.actions.CreateFileFromTemplateAction;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PackageJsonUtil {
    public static final String FILE_NAME = "package.json";
    private static final Key<CachedPackageJsonData> CACHED_PACKAGE_JSON_DATA_KEY = Key.create((String)"js.cached.package-json.data");
    private static final String TEMPLATE_NAME = "package_json";
    private static final List<String> DEPENDENCIES_KEY = ContainerUtil.newArrayList((Object[])new String[]{"dependencies", "devDependencies", "optionalDependencies", "peerDependencies", "bundledDependencies", "bundleDependencies"});

    private PackageJsonUtil() {
    }

    public static boolean isInsidePackageJsonFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            PackageJsonUtil.$$$reportNull$$$0(0);
        }
        return (file = element.getContainingFile()) != null && PackageJsonUtil.isPackageJsonFile(file);
    }

    @Nullable
    public static JsonFile getContainingPackageJsonFile(@NotNull PsiElement element) {
        PsiFile file;
        if (element == null) {
            PackageJsonUtil.$$$reportNull$$$0(1);
        }
        return PackageJsonUtil.isPackageJsonFile(file = element.getContainingFile()) ? (JsonFile)file : null;
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable PsiFile file) {
        return file instanceof JsonFile && FILE_NAME.equals(file.getName());
    }

    @Contract(value="null -> false")
    public static boolean isPackageJsonFile(@Nullable VirtualFile file) {
        return file != null && !file.isDirectory() && StringUtil.equals((CharSequence)FILE_NAME, (CharSequence)file.getNameSequence());
    }

    public static boolean isTopLevelProperty(@NotNull JsonProperty property) {
        PsiElement parent;
        if (property == null) {
            PackageJsonUtil.$$$reportNull$$$0(2);
        }
        return (parent = property.getParent()) != null && parent.getParent() instanceof JsonFile;
    }

    @Nullable
    public static JsonProperty findContainingProperty(@NotNull PsiElement element) {
        if (element == null) {
            PackageJsonUtil.$$$reportNull$$$0(3);
        }
        if (PackageJsonUtil.isInsidePackageJsonFile(element)) {
            return (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        }
        return null;
    }

    @Nullable
    public static JsonProperty findContainingTopLevelProperty(@Nullable PsiElement element) {
        if (element == null || !PackageJsonUtil.isInsidePackageJsonFile(element)) {
            return null;
        }
        JsonProperty property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)element, JsonProperty.class, (boolean)false);
        while (property != null && !PackageJsonUtil.isTopLevelProperty(property)) {
            property = (JsonProperty)PsiTreeUtil.getParentOfType((PsiElement)property, JsonProperty.class, (boolean)true);
        }
        return property;
    }

    public static boolean isPackageDependencyProperty(@NotNull JsonProperty property) {
        JsonObject obj;
        if (property == null) {
            PackageJsonUtil.$$$reportNull$$$0(4);
        }
        if ((obj = (JsonObject)ObjectUtils.tryCast((Object)property.getParent(), JsonObject.class)) != null) {
            JsonProperty dependenciesProperty = (JsonProperty)ObjectUtils.tryCast((Object)obj.getParent(), JsonProperty.class);
            return dependenciesProperty != null && DEPENDENCIES_KEY.contains(dependenciesProperty.getName()) && PackageJsonUtil.isTopLevelProperty(dependenciesProperty);
        }
        return false;
    }

    public static boolean hasScope(@NotNull String dependencyName, @NotNull String scopeName) {
        if (dependencyName == null) {
            PackageJsonUtil.$$$reportNull$$$0(5);
        }
        if (scopeName == null) {
            PackageJsonUtil.$$$reportNull$$$0(6);
        }
        return dependencyName.startsWith(scopeName) && dependencyName.length() > scopeName.length() && dependencyName.charAt(scopeName.length()) == '/';
    }

    @NotNull
    public static List<VirtualFile> collectPackageJsonFiles(@NotNull Project project, @NotNull VirtualFile fileOrDir) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(7);
        }
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(8);
        }
        ArrayList results = ContainerUtil.newArrayList();
        PackageJsonUtil.processUpPackageJsonFiles(project, fileOrDir, (Processor<VirtualFile>)((Processor)file -> {
            results.add(file);
            return true;
        }));
        ArrayList arrayList = results;
        if (arrayList == null) {
            PackageJsonUtil.$$$reportNull$$$0(9);
        }
        return arrayList;
    }

    public static void processUpPackageJsonFiles(@NotNull Project project, @NotNull VirtualFile fileOrDir, @NotNull Processor<VirtualFile> processor) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(10);
        }
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(11);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(12);
        }
        ReadAction.run(() -> {
            VirtualFile dir;
            if (project == null) {
                PackageJsonUtil.$$$reportNull$$$0(30);
            }
            if (fileOrDir == null) {
                PackageJsonUtil.$$$reportNull$$$0(31);
            }
            if (processor == null) {
                PackageJsonUtil.$$$reportNull$$$0(32);
            }
            if (project.isDisposed()) {
                return;
            }
            ProjectFileIndex fileIndex = ProjectFileIndex.getInstance((Project)project);
            VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
            if (dir == null) {
                return;
            }
            VirtualFile contentRoot = fileIndex.getContentRootForFile(dir, false);
            while (dir != null && contentRoot != null) {
                VirtualFile packageJson = dir.findChild(FILE_NAME);
                if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory() && !processor.process((Object)packageJson)) {
                    return;
                }
                if (dir.equals(contentRoot)) {
                    if ((dir = dir.getParent()) == null) {
                        return;
                    }
                    contentRoot = fileIndex.getContentRootForFile(dir, false);
                    continue;
                }
                dir = dir.getParent();
            }
        });
    }

    @Nullable
    public static VirtualFile findUpPackageJson(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(13);
        }
        Ref ref = Ref.create();
        PackageJsonUtil.processUpPackageJsonFiles(fileOrDir, (Processor<VirtualFile>)((Processor)file -> {
            ref.set(file);
            return false;
        }));
        return (VirtualFile)ref.get();
    }

    private static void processUpPackageJsonFiles(@NotNull VirtualFile fileOrDir, @NotNull Processor<VirtualFile> processor) {
        if (fileOrDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(14);
        }
        if (processor == null) {
            PackageJsonUtil.$$$reportNull$$$0(15);
        }
        ReadAction.run(() -> {
            VirtualFile dir;
            if (fileOrDir == null) {
                PackageJsonUtil.$$$reportNull$$$0(28);
            }
            if (processor == null) {
                PackageJsonUtil.$$$reportNull$$$0(29);
            }
            VirtualFile virtualFile = dir = fileOrDir.isDirectory() ? fileOrDir : fileOrDir.getParent();
            if (dir == null) {
                return;
            }
            while (dir != null) {
                VirtualFile packageJson = dir.findChild(FILE_NAME);
                if (packageJson != null && packageJson.isValid() && !packageJson.isDirectory() && !processor.process((Object)packageJson)) {
                    return;
                }
                dir = dir.getParent();
            }
        });
    }

    @NotNull
    public static List<JsonProperty> listAllPackageProperties(@NotNull JsonFile file) {
        if (file == null) {
            PackageJsonUtil.$$$reportNull$$$0(16);
        }
        JsonObject obj = (JsonObject)ObjectUtils.tryCast((Object)file.getTopLevelValue(), JsonObject.class);
        ArrayList<JsonProperty> result = new ArrayList<JsonProperty>();
        if (obj != null) {
            for (JsonProperty property : obj.getPropertyList()) {
                JsonObject depObj;
                if (!DEPENDENCIES_KEY.contains(property.getName()) || (depObj = (JsonObject)ObjectUtils.tryCast((Object)property.getValue(), JsonObject.class)) == null) continue;
                result.addAll(depObj.getPropertyList());
            }
        }
        ArrayList<JsonProperty> arrayList = result;
        if (arrayList == null) {
            PackageJsonUtil.$$$reportNull$$$0(17);
        }
        return arrayList;
    }

    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson) {
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(18);
        }
        PackageJsonData packageJsonData = PackageJsonUtil.getOrCreateData(packageJson, false);
        if (packageJsonData == null) {
            PackageJsonUtil.$$$reportNull$$$0(19);
        }
        return packageJsonData;
    }

    @NotNull
    public static PackageJsonData getOrCreateData(@NotNull VirtualFile packageJson, boolean refresh) {
        long documentModificationStamp;
        if (packageJson == null) {
            PackageJsonUtil.$$$reportNull$$$0(20);
        }
        if (refresh) {
            VfsUtil.markDirtyAndRefresh((ApplicationManager.getApplication().isUnitTestMode() || ApplicationManager.getApplication().isReadAccessAllowed() ? 1 : 0) != 0, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{packageJson});
        }
        Document document = FileDocumentManager.getInstance().getCachedDocument(packageJson);
        CachedPackageJsonData cached = (CachedPackageJsonData)CACHED_PACKAGE_JSON_DATA_KEY.get((UserDataHolder)packageJson);
        long l = documentModificationStamp = document != null ? document.getModificationStamp() : -1L;
        if (cached == null || cached.getFileModificationStamp() != packageJson.getModificationStamp() || cached.getDocumentModificationStamp() != documentModificationStamp) {
            PackageJsonData data = PackageJsonData.parse(packageJson, document);
            cached = new CachedPackageJsonData(data, packageJson.getModificationStamp(), documentModificationStamp);
            CACHED_PACKAGE_JSON_DATA_KEY.set((UserDataHolder)packageJson, (Object)cached);
        }
        PackageJsonData packageJsonData = cached.getData();
        if (packageJsonData == null) {
            PackageJsonUtil.$$$reportNull$$$0(21);
        }
        return packageJsonData;
    }

    @Nullable
    public static PsiFile createPackageJson(@NotNull PsiDirectory psiDir, boolean openFile) {
        VirtualFile virtualFile;
        if (psiDir == null) {
            PackageJsonUtil.$$$reportNull$$$0(22);
        }
        FileTemplate template = FileTemplateManager.getInstance((Project)psiDir.getProject()).getInternalTemplate(TEMPLATE_NAME);
        Map<String, String> defaultValues = Collections.singletonMap("package_name", psiDir.getName());
        if (!openFile) {
            String text = template.getText();
            for (Map.Entry<String, String> entry : defaultValues.entrySet()) {
                text = text.replace("#[[$" + entry.getKey() + "$]]#", entry.getValue());
            }
            template = template.clone();
            template.setText(text.replace("#[[$END$]]#", ""));
        }
        template.setLiveTemplateEnabled(openFile);
        PsiFile file = CreateFileFromTemplateAction.createFileFromTemplate((String)FILE_NAME, (FileTemplate)template, (PsiDirectory)psiDir, null, (boolean)openFile, defaultValues);
        if (openFile && file != null && (virtualFile = file.getVirtualFile()) != null) {
            FileEditorManager.getInstance((Project)file.getProject()).openFile(virtualFile, true);
        }
        return file;
    }

    @Nullable
    public static PackageJsonData getTopLevelPackageJsonData(@NotNull Project project) {
        if (project == null) {
            PackageJsonUtil.$$$reportNull$$$0(23);
        }
        if (project.isDefault() || project.getBaseDir() == null || project.isDisposed()) {
            return null;
        }
        VirtualFile packageJson = project.getBaseDir().findChild(FILE_NAME);
        return packageJson == null ? null : PackageJsonUtil.getOrCreateData(packageJson, false);
    }

    public static ThreeState isVersionGreaterOrEqualMajor(@NotNull String versionText, int major) {
        if (versionText == null) {
            PackageJsonUtil.$$$reportNull$$$0(24);
        }
        if ("latest".equals(versionText)) {
            return ThreeState.YES;
        }
        String[] parts = versionText.split("\\s-\\s");
        if (parts.length == 2) {
            String part = parts[1];
            if (PackageJsonUtil.isAny((part = StringUtil.trimStart((String)part, (String)"v")).charAt(0))) {
                return ThreeState.YES;
            }
            int parsedMajor = PackageJsonUtil.getMajorVersion(part);
            if (parsedMajor >= 0) {
                return parsedMajor >= major ? ThreeState.YES : ThreeState.NO;
            }
            return ThreeState.UNSURE;
        }
        ArrayList<Pair> versionWords = new ArrayList<Pair>();
        StringBuilder sb = new StringBuilder();
        StringBuilder prefixBuilder = new StringBuilder();
        for (int i = 0; i < versionText.length(); ++i) {
            char ch = versionText.charAt(i);
            if (Character.isDigit(ch) || '.' == ch || '*' == ch || 'v' == ch || 'x' == ch || 'X' == ch) {
                sb.append(ch);
                continue;
            }
            if (sb.length() > 0) {
                versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
                sb.setLength(0);
                prefixBuilder.setLength(0);
            }
            prefixBuilder.append(ch);
        }
        if (sb.length() > 0) {
            versionWords.add(Pair.create((Object)prefixBuilder.toString(), (Object)sb.toString()));
        }
        if (versionWords.isEmpty()) {
            return ThreeState.UNSURE;
        }
        boolean greaterThanLess = false;
        boolean lessThanGreater = false;
        for (Pair pair : versionWords) {
            int parsedMajor;
            String word = (String)pair.getSecond();
            word = StringUtil.trimStart((String)word, (String)"v");
            String prefix = (String)pair.getFirst();
            if (!PackageJsonUtil.isPrefixValid(prefix)) {
                return ThreeState.UNSURE;
            }
            if (word.isEmpty()) continue;
            if (PackageJsonUtil.isAny(word.charAt(0))) {
                lessThanGreater = true;
            }
            if ((parsedMajor = PackageJsonUtil.getMajorVersion(word)) < 0) continue;
            if (parsedMajor >= major) {
                char before;
                if (parsedMajor == major && (before = PackageJsonUtil.getVersionComparator(prefix)) == '<') {
                    return ThreeState.NO;
                }
                lessThanGreater = true;
                continue;
            }
            if (PackageJsonUtil.getVersionComparator(prefix) != '>') continue;
            greaterThanLess = true;
        }
        if (greaterThanLess || lessThanGreater) {
            return ThreeState.YES;
        }
        return ThreeState.NO;
    }

    private static int getMajorVersion(@NotNull String version) {
        int idx;
        if (version == null) {
            PackageJsonUtil.$$$reportNull$$$0(25);
        }
        if ((idx = version.indexOf(".")) < 0) {
            return StringUtil.parseInt((String)version, (int)-1);
        }
        return StringUtil.parseInt((String)version.substring(0, idx), (int)-1);
    }

    private static boolean isPrefixValid(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(26);
        }
        if (prefix.isEmpty()) {
            return true;
        }
        for (int i = 0; i < prefix.length(); ++i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch) || ch == '<' || ch == '>' || ch == '=' || ch == '~' || ch == '^' || ch == '|') continue;
            return false;
        }
        return true;
    }

    private static boolean isAny(char first) {
        return first == '*' || first == 'x' || first == 'X';
    }

    private static char getVersionComparator(@NotNull String prefix) {
        if (prefix == null) {
            PackageJsonUtil.$$$reportNull$$$0(27);
        }
        for (int i = prefix.length() - 1; i >= 0; --i) {
            char ch = prefix.charAt(i);
            if (Character.isWhitespace(ch)) continue;
            if (ch == '=' && i > 0) {
                return prefix.charAt(i - 1);
            }
            return ch;
        }
        return ' ';
    }

    @Contract(value="null -> null")
    @Nullable
    public static VirtualFile findChildPackageJsonFile(@Nullable VirtualFile dir) {
        VirtualFile packageJson;
        if (dir != null && (packageJson = dir.findChild(FILE_NAME)) != null && packageJson.isValid() && !packageJson.isDirectory()) {
            return packageJson;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyName";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scopeName";
                break;
            }
            case 7: 
            case 10: 
            case 23: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 28: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileOrDir";
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 12: 
            case 15: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiDir";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "versionText";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "prefix";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "collectPackageJsonFiles";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "listAllPackageProperties";
                break;
            }
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isInsidePackageJsonFile";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getContainingPackageJsonFile";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isTopLevelProperty";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findContainingProperty";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isPackageDependencyProperty";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "hasScope";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "collectPackageJsonFiles";
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processUpPackageJsonFiles";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "findUpPackageJson";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "listAllPackageProperties";
                break;
            }
            case 18: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateData";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "createPackageJson";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getTopLevelPackageJsonData";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isVersionGreaterOrEqualMajor";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getMajorVersion";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "isPrefixValid";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getVersionComparator";
                break;
            }
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUpPackageJsonFiles$3";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUpPackageJsonFiles$1";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class CachedPackageJsonData {
        private final PackageJsonData myData;
        private final long myFileModificationStamp;
        private final long myDocumentModificationStamp;

        /*
         * WARNING - void declaration
         */
        public CachedPackageJsonData(@NotNull PackageJsonData data, long fileModificationStamp, long l) {
            void documentModificationStamp;
            if (data == null) {
                CachedPackageJsonData.$$$reportNull$$$0(0);
            }
            this.myData = data;
            this.myFileModificationStamp = fileModificationStamp;
            this.myDocumentModificationStamp = documentModificationStamp;
        }

        @NotNull
        public PackageJsonData getData() {
            PackageJsonData packageJsonData = this.myData;
            if (packageJsonData == null) {
                CachedPackageJsonData.$$$reportNull$$$0(1);
            }
            return packageJsonData;
        }

        public long getFileModificationStamp() {
            return this.myFileModificationStamp;
        }

        public long getDocumentModificationStamp() {
            return this.myDocumentModificationStamp;
        }

        public String toString() {
            return "data=" + this.myData + ", fileModificationStamp=" + this.myFileModificationStamp + ", documentModificationStamp=" + this.myDocumentModificationStamp;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "data";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/lang/javascript/buildTools/npm/PackageJsonUtil$CachedPackageJsonData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getData";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

