/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.grunt.execution;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.javascript.buildTools.grunt.GruntUtil;
import com.intellij.lang.javascript.buildTools.grunt.execution.GruntNotifier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GruntWatchTaskListener
extends ProcessAdapter {
    private final GruntNotifier myNotifier;
    private final StringBuilder myBuffer;
    private final GruntWatchTaskState[] myWatchTaskStates;

    public GruntWatchTaskListener(@NotNull Project project, @NotNull String watchTaskName) {
        if (project == null) {
            GruntWatchTaskListener.$$$reportNull$$$0(0);
        }
        if (watchTaskName == null) {
            GruntWatchTaskListener.$$$reportNull$$$0(1);
        }
        this.myBuffer = new StringBuilder();
        this.myNotifier = new GruntNotifier(project);
        for (GruntWatchTaskState state : this.myWatchTaskStates = new GruntWatchTaskState[]{new GruntWatchTaskVersion044State(), new GruntWatchTaskVersion061State(watchTaskName), new GruntWatchTaskVersion100State()}) {
            state.init();
        }
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
        if (event == null) {
            GruntWatchTaskListener.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            GruntWatchTaskListener.$$$reportNull$$$0(3);
        }
        if (outputType != ProcessOutputTypes.SYSTEM && outputType != ProcessOutputTypes.STDERR) {
            String line = this.getWholeLine(event.getText());
            Boolean success = null;
            for (GruntWatchTaskState state : this.myWatchTaskStates) {
                success = line != null ? state.onLine(line) : state.onLinePrefix(this.myBuffer);
                if (success != null) break;
            }
            if (success != null) {
                this.myNotifier.scheduleNotification(success);
                for (GruntWatchTaskState state : this.myWatchTaskStates) {
                    state.init();
                }
            }
        }
    }

    @Nullable
    private String getWholeLine(@NotNull String textToAppend) {
        if (textToAppend == null) {
            GruntWatchTaskListener.$$$reportNull$$$0(4);
        }
        if (textToAppend.length() > 0 && textToAppend.charAt(textToAppend.length() - 1) == '\n') {
            if (this.myBuffer.length() == 0) {
                return textToAppend;
            }
            this.myBuffer.append(textToAppend);
            String result = this.myBuffer.toString();
            this.myBuffer.setLength(0);
            return result;
        }
        this.myBuffer.append(textToAppend);
        return null;
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        if (event == null) {
            GruntWatchTaskListener.$$$reportNull$$$0(5);
        }
        this.myNotifier.stop();
    }

    private static boolean isCompletedLine(@NotNull String line) {
        if (line == null) {
            GruntWatchTaskListener.$$$reportNull$$$0(6);
        }
        return line.startsWith("Completed in ") && line.endsWith(" - Waiting...\n");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "watchTaskName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textToAppend";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/execution/GruntWatchTaskListener";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "onTextAvailable";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getWholeLine";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "processTerminated";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "isCompletedLine";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class GruntWatchTaskVersion100State
    extends GruntWatchTaskState {
        private Boolean myState;

        private GruntWatchTaskVersion100State() {
        }

        @Override
        public void init() {
            this.myState = null;
        }

        @Override
        @Nullable
        public Boolean onLine(@NotNull String line) {
            if (line == null) {
                GruntWatchTaskVersion100State.$$$reportNull$$$0(0);
            }
            if (line.equals("Done.\n")) {
                this.myState = true;
            } else if (line.equals("Aborted due to warnings.\n")) {
                this.myState = false;
            }
            if (line.startsWith("Completed in ") && line.endsWith(" - Waiting...\n")) {
                Boolean state = this.myState;
                this.myState = null;
                return state;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/grunt/execution/GruntWatchTaskListener$GruntWatchTaskVersion100State", "onLine"));
        }
    }

    private static class GruntWatchTaskVersion061State
    extends GruntWatchTaskState {
        private final String myWatchTaskTitleLine;
        private boolean myFailedTaskEncountered;
        private boolean myWatchTaskTitleMatched;
        private boolean myWatchTaskTitleFirstMatchSkipped;

        public GruntWatchTaskVersion061State(@NotNull String watchTaskName) {
            if (watchTaskName == null) {
                GruntWatchTaskVersion061State.$$$reportNull$$$0(0);
            }
            this.myFailedTaskEncountered = false;
            this.myWatchTaskTitleMatched = false;
            this.myWatchTaskTitleFirstMatchSkipped = false;
            String baseTaskName = GruntUtil.getBaseTaskName(watchTaskName);
            this.myWatchTaskTitleLine = baseTaskName.equals(watchTaskName) ? "Running \"" + watchTaskName + "\" task\n" : "Running \"" + watchTaskName + "\" (" + baseTaskName + ") task\n";
        }

        @Override
        public void init() {
            this.myFailedTaskEncountered = false;
            this.myWatchTaskTitleMatched = false;
        }

        @Override
        @Nullable
        public Boolean onLine(@NotNull String line) {
            if (line == null) {
                GruntWatchTaskVersion061State.$$$reportNull$$$0(1);
            }
            if (line.startsWith("Warning: Task \"") && line.endsWith("\" failed.\n")) {
                this.myFailedTaskEncountered = true;
                this.myWatchTaskTitleMatched = false;
                return null;
            }
            if (line.equals(this.myWatchTaskTitleLine)) {
                if (!this.myWatchTaskTitleFirstMatchSkipped) {
                    this.myWatchTaskTitleFirstMatchSkipped = true;
                    this.myWatchTaskTitleMatched = false;
                    return null;
                }
                this.myWatchTaskTitleMatched = true;
                return null;
            }
            if (GruntWatchTaskListener.isCompletedLine(line)) {
                if (this.myWatchTaskTitleMatched) {
                    return !this.myFailedTaskEncountered;
                }
                this.init();
                return null;
            }
            if ("Waiting...\n".equals(line)) {
                if (this.myWatchTaskTitleMatched) {
                    return !this.myFailedTaskEncountered;
                }
                this.init();
                return null;
            }
            if ("Waiting...OK\n".equals(line)) {
                this.init();
                return null;
            }
            if (line.startsWith("Warning: Exited with error code")) {
                return false;
            }
            return null;
        }

        @Override
        @Nullable
        public Boolean onLinePrefix(@NotNull StringBuilder linePrefix) {
            if (linePrefix == null) {
                GruntWatchTaskVersion061State.$$$reportNull$$$0(2);
            }
            if (this.myFailedTaskEncountered && this.myWatchTaskTitleMatched && StringUtil.equals((CharSequence)"Waiting...", (CharSequence)linePrefix)) {
                return false;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "watchTaskName";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "linePrefix";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/grunt/execution/GruntWatchTaskListener$GruntWatchTaskVersion061State";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onLine";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onLinePrefix";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class GruntWatchTaskVersion044State
    extends GruntWatchTaskState {
        private int myFailedState = 0;
        private int myPassedState = 0;

        private GruntWatchTaskVersion044State() {
        }

        @Override
        public void init() {
            this.myFailedState = 0;
            this.myPassedState = 0;
        }

        @Override
        @Nullable
        public Boolean onLine(@NotNull String line) {
            if (line == null) {
                GruntWatchTaskVersion044State.$$$reportNull$$$0(0);
            }
            if (this.myFailedState == 0 && ("Aborted due to warnings.\n".equals(line) || "Done, but with warnings.\n".equals(line))) {
                this.myFailedState = 1;
                this.myPassedState = 0;
                return null;
            }
            if (this.myPassedState == 0 && "Done, without errors.\n".equals(line)) {
                this.myFailedState = 0;
                this.myPassedState = 1;
                return null;
            }
            if ((this.myFailedState == 1 || this.myPassedState == 1) && GruntWatchTaskListener.isCompletedLine(line)) {
                return this.myPassedState == 1;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "line", "com/intellij/lang/javascript/buildTools/grunt/execution/GruntWatchTaskListener$GruntWatchTaskVersion044State", "onLine"));
        }
    }

    private static abstract class GruntWatchTaskState {
        protected GruntWatchTaskState() {
        }

        public abstract void init();

        @Nullable
        public abstract Boolean onLine(@NotNull String var1);

        @Nullable
        public Boolean onLinePrefix(@NotNull StringBuilder linePrefix) {
            if (linePrefix == null) {
                GruntWatchTaskState.$$$reportNull$$$0(0);
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "linePrefix", "com/intellij/lang/javascript/buildTools/grunt/execution/GruntWatchTaskListener$GruntWatchTaskState", "onLinePrefix"));
        }
    }
}

