/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript.buildTools.base;

import com.intellij.ide.SearchTopHitProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtExecutor;
import com.intellij.lang.javascript.buildTools.base.JsbtFileManager;
import com.intellij.lang.javascript.buildTools.base.JsbtFileStructure;
import com.intellij.lang.javascript.buildTools.base.JsbtService;
import com.intellij.lang.javascript.buildTools.base.JsbtTaskSet;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import java.lang.ref.WeakReference;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class JsbtTopHitProvider
implements SearchTopHitProvider {
    private static final String PATTERN_PREFIX = "run ";

    public void consumeTopHits(String pattern, Consumer<Object> collector, Project activeProject) {
        if (pattern == null || collector == null || activeProject == null) {
            return;
        }
        for (JsbtService service : (JsbtService[])JsbtService.EP_NAME.getExtensions()) {
            JsbtFileManager fileManager = service.getFileManager(activeProject);
            for (VirtualFile buildfile : fileManager.getBuildfiles()) {
                JsbtFileStructure structure = fileManager.getCachedStructure(buildfile);
                if (structure == null) continue;
                for (String taskName : structure.getTaskNames()) {
                    JsbtTopHitProvider.consumeTaskName(activeProject, service, structure, taskName, pattern, collector);
                }
            }
        }
    }

    private static void consumeTaskName(@NotNull Project project, @NotNull JsbtService service, @NotNull JsbtFileStructure structure, @NotNull String taskName, @NotNull String pattern, @NotNull Consumer<Object> collector) {
        if (project == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(0);
        }
        if (service == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(1);
        }
        if (structure == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(2);
        }
        if (taskName == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(3);
        }
        if (pattern == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(4);
        }
        if (collector == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(5);
        }
        if (JsbtTopHitProvider.match(pattern, taskName)) {
            collector.consume((Object)new JsbtTaskRunAction(project, service, new JsbtTaskSet(structure, Collections.singletonList(taskName))));
        }
    }

    private static boolean match(@NotNull String pattern, @NotNull String taskName) {
        String subPattern;
        if (pattern == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(6);
        }
        if (taskName == null) {
            JsbtTopHitProvider.$$$reportNull$$$0(7);
        }
        if (StringUtil.startsWithIgnoreCase((String)pattern, (String)PATTERN_PREFIX) && StringUtil.startsWithIgnoreCase((String)taskName, (String)(subPattern = pattern.substring(PATTERN_PREFIX.length())))) {
            return true;
        }
        return StringUtil.startsWith((CharSequence)taskName, (CharSequence)pattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structure";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "taskName";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
        }
        objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "consumeTaskName";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "match";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class JsbtTaskRunAction
    extends DumbAwareAction {
        private final WeakReference<Project> myProject;
        private final JsbtService myService;
        private final JsbtTaskSet myTaskSet;

        protected JsbtTaskRunAction(@NotNull Project project, @NotNull JsbtService service, @NotNull JsbtTaskSet taskSet) {
            if (project == null) {
                JsbtTaskRunAction.$$$reportNull$$$0(0);
            }
            if (service == null) {
                JsbtTaskRunAction.$$$reportNull$$$0(1);
            }
            if (taskSet == null) {
                JsbtTaskRunAction.$$$reportNull$$$0(2);
            }
            super(null, null, service.getIcon());
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText("Run '" + taskSet.getName() + "' " + service.getSearchEverywhereDescription(), false);
            this.myProject = new WeakReference<Project>(project);
            this.myService = service;
            this.myTaskSet = taskSet;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                JsbtTaskRunAction.$$$reportNull$$$0(3);
            }
            Project project = e.getProject();
            e.getPresentation().setEnabledAndVisible(project == this.myProject.get());
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                JsbtTaskRunAction.$$$reportNull$$$0(4);
            }
            if ((project = (Project)this.myProject.get()) != null && e.getProject() == project) {
                new JsbtExecutor(project, this.myService, this.myTaskSet).run();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "service";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskSet";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/lang/javascript/buildTools/base/JsbtTopHitProvider$JsbtTaskRunAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "update";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

