/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.javascript;

import com.intellij.lang.Language;
import com.intellij.lang.LanguageExtension;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.validation.JSAnnotatingVisitor;
import com.intellij.lang.javascript.validation.JSKeywordHighlighterVisitor;
import com.intellij.lang.javascript.validation.JavaScriptAnnotatingVisitor;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSAnalysisHandlersFactory {
    public static final LanguageExtension<JSAnalysisHandlersFactory> EP_NAME = new LanguageExtension("JavaScript.analysisHandlersFactory");
    private static final JSAnalysisHandlersFactory DEFAULT_INSTANCE = new JSAnalysisHandlersFactory();

    @NotNull
    public static JSAnalysisHandlersFactory forElement(@Nullable PsiElement element) {
        Language dialect = element != null ? DialectDetector.languageOfElement(element) : null;
        JSAnalysisHandlersFactory jSAnalysisHandlersFactory = JSAnalysisHandlersFactory.forLanguage(dialect);
        if (jSAnalysisHandlersFactory == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(0);
        }
        return jSAnalysisHandlersFactory;
    }

    @NotNull
    public static JSAnalysisHandlersFactory forLanguage(@Nullable Language dialect) {
        JSAnalysisHandlersFactory dialectSpecificFactory = dialect != null ? (JSAnalysisHandlersFactory)EP_NAME.forLanguage(dialect) : null;
        JSAnalysisHandlersFactory jSAnalysisHandlersFactory = dialectSpecificFactory != null ? dialectSpecificFactory : DEFAULT_INSTANCE;
        if (jSAnalysisHandlersFactory == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(1);
        }
        return jSAnalysisHandlersFactory;
    }

    @NotNull
    public JSAnnotatingVisitor createAnnotatingVisitor(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        if (psiElement == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(3);
        }
        JavaScriptAnnotatingVisitor javaScriptAnnotatingVisitor = new JavaScriptAnnotatingVisitor(psiElement, holder);
        if (javaScriptAnnotatingVisitor == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(4);
        }
        return javaScriptAnnotatingVisitor;
    }

    public JSKeywordHighlighterVisitor createKeywordHighlighterVisitor(@NotNull AnnotationHolder holder) {
        if (holder == null) {
            JSAnalysisHandlersFactory.$$$reportNull$$$0(5);
        }
        return new JSKeywordHighlighterVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/javascript/JSAnalysisHandlersFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "forElement";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "forLanguage";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/javascript/JSAnalysisHandlersFactory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createAnnotatingVisitor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createAnnotatingVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createKeywordHighlighterVisitor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

