/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.refactoring;

import com.intellij.ide.util.EditorHelper;
import com.intellij.lang.Language;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfo;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberInfoModel;
import com.intellij.lang.ecmascript6.refactoring.ES6ModuleMemberSelectionTable;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveModuleMembersProcessor;
import com.intellij.lang.ecmascript6.refactoring.ES6MoveSymbolDialog;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.psi.JSPsiElementBase;
import com.intellij.lang.javascript.psi.ecmal4.JSQualifiedNamedElement;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringProcessor;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.MemberInfoChange;
import com.intellij.refactoring.classMembers.MemberInfoChangeListener;
import com.intellij.refactoring.classMembers.MemberInfoModel;
import com.intellij.refactoring.move.MoveCallback;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Consumer;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6MoveModuleMembersDialog
extends ES6MoveSymbolDialog {
    private final ES6ModuleMemberSelectionTable mySelectionTable;
    @NotNull
    private final PsiFile mySourceModule;
    @Nullable
    private final MoveCallback myMoveCallback;

    public ES6MoveModuleMembersDialog(@NotNull Project project, @NotNull String fromPath, @NotNull String toPath, @NotNull Collection<JSPsiElementBase> selectedElements, @NotNull PsiFile sourceModule, @Nullable MoveCallback moveCallback) {
        if (project == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(0);
        }
        if (fromPath == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(1);
        }
        if (toPath == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(2);
        }
        if (selectedElements == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(3);
        }
        if (sourceModule == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(4);
        }
        super(project, fromPath, toPath, (PsiElement)sourceModule);
        this.mySourceModule = sourceModule;
        this.myMoveCallback = moveCallback;
        this.setTitle(JSBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]));
        ES6ModuleMemberInfoModel memberInfoModel = new ES6ModuleMemberInfoModel(sourceModule);
        List<ES6ModuleMemberInfo> moduleMemberInfos = ES6ModuleMemberInfo.getModuleMembers((PsiElement)sourceModule, selectedElements);
        this.mySelectionTable = new ES6ModuleMemberSelectionTable(moduleMemberInfos, (MemberInfoModel<JSQualifiedNamedElement, ES6ModuleMemberInfo>)memberInfoModel);
        this.mySelectionTable.addMemberInfoChangeListener((MemberInfoChangeListener)memberInfoModel);
        memberInfoModel.memberInfoChanged(new MemberInfoChange(moduleMemberInfos));
        JBScrollPane content = new JBScrollPane((Component)((Object)this.mySelectionTable)){

            public Dimension getMinimumSize() {
                return new Dimension((int)super.getMinimumSize().getWidth(), 0);
            }
        };
        this.mySelectionTable.setShowColumns(false);
        this.myExtraPanel.add((Component)content, "North");
        this.init();
    }

    public Collection<JSQualifiedNamedElement> getSelectedElements() {
        return this.mySelectionTable.getSelectedMemberInfos().stream().map(el -> (JSQualifiedNamedElement)el.getMember()).collect(Collectors.toList());
    }

    @Override
    protected void doAction() {
        String message = this.validateData();
        if (!StringUtil.isEmpty((String)message)) {
            CommonRefactoringUtil.showErrorMessage((String)JSBundle.message((String)"es6.move.module.members.refactoring.name", (Object[])new Object[0]), (String)message, null, (Project)this.myProject);
            return;
        }
        PsiFile toModule = this.getToModule();
        if (toModule == null) {
            return;
        }
        try {
            this.invokeRefactoring(this.createProcessor(toModule));
        }
        catch (IncorrectOperationException e) {
            CommonRefactoringUtil.showErrorMessage((String)RefactoringBundle.message((String)"error.title"), (String)e.getMessage(), null, (Project)this.myProject);
        }
    }

    @NotNull
    private BaseRefactoringProcessor createProcessor(@NotNull PsiFile toModule) {
        if (toModule == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(5);
        }
        ES6MoveModuleMembersProcessor eS6MoveModuleMembersProcessor = new ES6MoveModuleMembersProcessor(this.getSelectedElements(), (PsiElement)toModule, (PsiElement)this.mySourceModule, (Consumer<Collection<JSQualifiedNamedElement>>)((Consumer)newElements -> {
            JSQualifiedNamedElement first;
            if (this.isOpenInEditor() && (first = (JSQualifiedNamedElement)ContainerUtil.getFirstItem((Collection)newElements)) != null) {
                EditorHelper.openInEditor((PsiElement)first);
            }
            if (this.myMoveCallback != null) {
                this.myMoveCallback.refactoringCompleted();
            }
        }));
        if (eS6MoveModuleMembersProcessor == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(6);
        }
        return eS6MoveModuleMembersProcessor;
    }

    @Nullable
    private String validateData() {
        Language fromLanguage;
        if (this.getSelectedElements().isEmpty()) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.no.selected.items", (Object[])new Object[0]);
        }
        String modulePath = this.getModuleString();
        if (StringUtil.isEmpty((String)modulePath)) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.incorrect.module", (Object[])new Object[0]);
        }
        if (StringUtil.equals((CharSequence)this.myFromField.getText(), (CharSequence)modulePath)) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.modules.same", (Object[])new Object[0]);
        }
        Ref fileCreationError = Ref.create();
        CommandProcessor.getInstance().executeCommand(this.myProject, () -> {
            try {
                fileCreationError.set((Object)ES6MoveModuleMembersDialog.checkOrCreateFile(this.myProject, modulePath, this.getTitle()));
            }
            catch (IncorrectOperationException e) {
                CommonRefactoringUtil.showErrorMessage((String)this.getTitle(), (String)e.getMessage(), null, (Project)this.myProject);
            }
        }, JSBundle.message((String)"es6.move.module.members.refactoring.create.file", (Object[])new Object[0]), null);
        if (fileCreationError.get() != null) {
            return (String)fileCreationError.get();
        }
        PsiFile toModule = this.getToModule();
        if (toModule == null) {
            return null;
        }
        Language toModuleLanguage = toModule.getLanguage();
        if (!toModuleLanguage.isKindOf(fromLanguage = this.mySourceModule.getLanguage())) {
            return "Target module has incompatible language";
        }
        return null;
    }

    @Nullable
    public static String checkOrCreateFile(@NotNull Project project, @NotNull String path, @NotNull String messageTitle) {
        if (project == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(7);
        }
        if (path == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(8);
        }
        if (messageTitle == null) {
            ES6MoveModuleMembersDialog.$$$reportNull$$$0(9);
        }
        path = FileUtil.toSystemIndependentName((String)path);
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(path);
        if (file != null) {
            return null;
        }
        String fileName = VfsUtil.extractFileName((String)path);
        String parentDir = VfsUtil.getParentDir((String)path);
        if (parentDir == null || fileName == null || StringUtil.isEmpty((String)FileUtilRt.getExtension((String)fileName))) {
            return JSBundle.message((String)"es6.move.module.members.refactoring.dialog.error.incorrect.module", (Object[])new Object[0]);
        }
        int answer = Messages.showYesNoDialog((Project)project, (String)JSBundle.message((String)"es6.move.module.members.refactoring.create.file.message", (Object[])new Object[]{fileName}), (String)messageTitle, (Icon)Messages.getQuestionIcon());
        if (answer == 0) {
            try {
                WriteAction.run(() -> {
                    if (project == null) {
                        ES6MoveModuleMembersDialog.$$$reportNull$$$0(10);
                    }
                    VirtualFile directories = VfsUtil.createDirectories((String)parentDir);
                    directories.createChildData((Object)project, fileName);
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            return null;
        }
        return "";
    }

    @Nullable
    private PsiFile getToModule() {
        String string = this.getModuleString();
        VirtualFile path = LocalFileSystem.getInstance().findFileByPath(string);
        if (path == null) {
            return null;
        }
        return this.mySourceModule.getManager().findFile(path);
    }

    public String getModuleString() {
        return this.myModuleField.getText();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fromPath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toPath";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedElements";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceModule";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toModule";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/refactoring/ES6MoveModuleMembersDialog";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createProcessor";
                break;
            }
            case 6: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "checkOrCreateFile";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "lambda$checkOrCreateFile$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

