/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.psi.impl;

import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.ecmascript6.psi.impl.ES6CreateImportUtil;
import com.intellij.lang.ecmascript6.psi.impl.JSModuleImportPathBuilder;
import com.intellij.lang.ecmascript6.psi.impl.TypeScriptImportPathBuilder;
import com.intellij.lang.ecmascript6.resolve.JSFileReferencesUtil;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.formatter.JSCodeStyleSettings;
import com.intellij.lang.javascript.frameworks.modules.JSExactFileReference;
import com.intellij.lang.javascript.modules.JSModuleNameInfo;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfigUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.io.File;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class JSImportPathBuilder {
    @NotNull
    protected final PsiElement myPlace;
    @NotNull
    protected final VirtualFile myPlaceFile;
    @Nullable
    protected final PsiElement myElementToImport;
    @NotNull
    protected final VirtualFile myFileToImport;
    @NotNull
    protected final Project myProject;
    @NotNull
    protected final PsiFile myPlacePsiFile;

    public JSImportPathBuilder(@NotNull PsiElement place, @Nullable PsiElement elementToImport, @NotNull VirtualFile fileToImport) {
        PsiFile originalFile;
        if (place == null) {
            JSImportPathBuilder.$$$reportNull$$$0(0);
        }
        if (fileToImport == null) {
            JSImportPathBuilder.$$$reportNull$$$0(1);
        }
        this.myProject = place.getProject();
        this.myPlacePsiFile = originalFile = place.getContainingFile().getOriginalFile();
        this.myPlace = place;
        this.myPlaceFile = originalFile.getVirtualFile();
        this.myElementToImport = elementToImport;
        this.myFileToImport = fileToImport;
    }

    @NotNull
    static JSImportPathBuilder createBuilder(@NotNull PsiElement place, @Nullable PsiElement toImport, @NotNull VirtualFile dstFile, @Nullable TypeScriptConfig configFile) {
        if (place == null) {
            JSImportPathBuilder.$$$reportNull$$$0(2);
        }
        if (dstFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(3);
        }
        JSImportPathBuilder jSImportPathBuilder = DialectDetector.isTypeScript(place) ? new TypeScriptImportPathBuilder(place, toImport, dstFile, configFile) : new JSModuleImportPathBuilder(place, toImport, dstFile);
        if (jSImportPathBuilder == null) {
            JSImportPathBuilder.$$$reportNull$$$0(4);
        }
        return jSImportPathBuilder;
    }

    @NotNull
    public static JSImportPathBuilder createBuilder(@NotNull PsiElement place, @Nullable PsiElement toImport, @NotNull VirtualFile dstFile) {
        PsiFile myPlacePsiFile;
        if (place == null) {
            JSImportPathBuilder.$$$reportNull$$$0(5);
        }
        if (dstFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(6);
        }
        TypeScriptConfig configFile = DialectDetector.isTypeScript((PsiElement)(myPlacePsiFile = place.getContainingFile().getOriginalFile())) ? TypeScriptConfigUtil.getConfigForPsiFile(myPlacePsiFile) : null;
        JSImportPathBuilder jSImportPathBuilder = JSImportPathBuilder.createBuilder(place, toImport, dstFile, configFile);
        if (jSImportPathBuilder == null) {
            JSImportPathBuilder.$$$reportNull$$$0(7);
        }
        return jSImportPathBuilder;
    }

    @Nullable
    protected JSModuleNameInfo processRootPaths(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        String rootPath;
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(8);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(9);
        }
        if ((rootPath = this.getPathRelativeToRoots(moduleFileOrDirectory)) != null) {
            return new JSModuleNameInfo(rootPath, moduleFileOrDirectory, resolvedModuleFile, this.myPlace);
        }
        return null;
    }

    protected final void processDirectModuleNames(boolean checkNodeResolution, @NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(10);
        }
        if (checkNodeResolution && this.useNodeResolution() && !this.processWithNodeResolution(processor)) {
            return;
        }
        this.processForModuleFile(processor, this.myFileToImport, this.myFileToImport);
    }

    private boolean processWithNodeResolution(@NotNull Processor<JSModuleNameInfo> processor) {
        VirtualFile moduleFileOrDirectory;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(11);
        }
        VirtualFile sourceRoot = ProjectFileIndex.getInstance((Project)this.myProject).getContentRootForFile(moduleFileOrDirectory);
        if (VfsUtilCore.isAncestor((VirtualFile)moduleFileOrDirectory, (VirtualFile)this.myPlaceFile, (boolean)true)) {
            return true;
        }
        VirtualFile placeDirectory = this.myPlaceFile.getParent();
        for (moduleFileOrDirectory = this.myFileToImport.getParent(); !(moduleFileOrDirectory == null || sourceRoot != null && sourceRoot.equals(moduleFileOrDirectory) || moduleFileOrDirectory.equals(placeDirectory)); moduleFileOrDirectory = moduleFileOrDirectory.getParent()) {
            VirtualFile resolvedModuleFile = this.checkSymbolAndGetFile(moduleFileOrDirectory);
            if (resolvedModuleFile == null || this.processForModuleFile(processor, moduleFileOrDirectory, resolvedModuleFile)) continue;
            return false;
        }
        return true;
    }

    private boolean processForModuleFile(@NotNull Processor<JSModuleNameInfo> processor, VirtualFile moduleFileOrDirectory, VirtualFile resolvedModuleFile) {
        JSModuleNameInfo rootModuleInfo;
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(12);
        }
        if (!this.processExtensionsForModuleFile(processor, moduleFileOrDirectory, resolvedModuleFile)) {
            return false;
        }
        if (JSCodeStyleSettings.isUseAbsolutePath(this.myPlace) && (rootModuleInfo = this.processRootPaths(moduleFileOrDirectory, resolvedModuleFile)) != null && !processor.process((Object)rootModuleInfo)) {
            return false;
        }
        String externalModuleName = VfsUtil.getPath((VirtualFile)this.myPlaceFile, (VirtualFile)moduleFileOrDirectory, (char)'/');
        if (externalModuleName == null) {
            externalModuleName = VfsUtil.getPath((VirtualFile)this.myPlaceFile, (VirtualFile)this.myFileToImport, (char)'/');
            if (externalModuleName == null) {
                externalModuleName = this.myFileToImport.getName();
            }
            moduleFileOrDirectory = this.myFileToImport;
            resolvedModuleFile = this.myFileToImport;
        }
        if (!externalModuleName.startsWith(".") && !externalModuleName.startsWith(File.separator)) {
            externalModuleName = "./" + externalModuleName;
        }
        return processor.process((Object)new JSModuleNameInfo(externalModuleName, moduleFileOrDirectory, resolvedModuleFile, this.myPlace));
    }

    private boolean processExtensionsForModuleFile(@NotNull Processor<JSModuleNameInfo> processor, @NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(13);
        }
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(14);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(15);
        }
        for (JSModuleReferenceContributor contributor : JSModuleReferenceContributor.getSortedExtensions()) {
            String contributorModulePath;
            if (!contributor.isApplicable(this.myPlace) || StringUtil.isEmpty((String)(contributorModulePath = contributor.getModulePath(this.myPlace, moduleFileOrDirectory, resolvedModuleFile))) || processor.process((Object)new JSModuleNameInfo(contributorModulePath, this.myFileToImport, this.myPlace))) continue;
            return false;
        }
        return true;
    }

    @NotNull
    protected JSModuleNameInfo getPathForRoot(@NotNull VirtualFile moduleFileOrDirectory, @NotNull VirtualFile resolvedModuleFile, @NotNull VirtualFile rootFile) {
        String path;
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(16);
        }
        if (resolvedModuleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(17);
        }
        if (rootFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(18);
        }
        if ((path = VfsUtil.getPath((VirtualFile)rootFile, (VirtualFile)moduleFileOrDirectory, (char)'/')) == null) {
            JSModuleNameInfo jSModuleNameInfo = new JSModuleNameInfo(VfsUtil.getPath((VirtualFile)rootFile, (VirtualFile)this.myFileToImport, (char)'/'), moduleFileOrDirectory, resolvedModuleFile, this.myPlace);
            if (jSModuleNameInfo == null) {
                JSImportPathBuilder.$$$reportNull$$$0(19);
            }
            return jSModuleNameInfo;
        }
        JSModuleNameInfo jSModuleNameInfo = new JSModuleNameInfo(path, moduleFileOrDirectory, resolvedModuleFile, this.myPlace);
        if (jSModuleNameInfo == null) {
            JSImportPathBuilder.$$$reportNull$$$0(20);
        }
        return jSModuleNameInfo;
    }

    protected boolean useNodeResolution() {
        return JSCodeStyleSettings.isUseNodeResolution(this.myPlace);
    }

    public void processModuleNames(@NotNull Processor<JSModuleNameInfo> processor) {
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(21);
        }
        this.processDirectModuleNames(true, processor);
    }

    @NotNull
    public static Processor<JSModuleNameInfo> createSearchProcessor(Ref<JSModuleNameInfo> ref, String[] excludedNames) {
        Processor processor = info -> {
            if (info.isValid() && (excludedNames.length == 0 || !ArrayUtil.contains((String)info.getModuleName(), (String[])excludedNames))) {
                ref.set(info);
                return false;
            }
            return true;
        };
        if (processor == null) {
            JSImportPathBuilder.$$$reportNull$$$0(22);
        }
        return processor;
    }

    @Nullable
    protected final VirtualFile checkSymbolAndGetFile(@NotNull VirtualFile moduleFileOrDirectory) {
        if (moduleFileOrDirectory == null) {
            JSImportPathBuilder.$$$reportNull$$$0(23);
        }
        VirtualFile resolvedFile = moduleFileOrDirectory;
        if (moduleFileOrDirectory.isDirectory()) {
            resolvedFile = this.resolveAsNpmPackage(moduleFileOrDirectory, this.myElementToImport == null ? this.myPlace : this.myElementToImport);
        }
        if (resolvedFile == null) {
            return null;
        }
        if (resolvedFile.equals(this.myFileToImport)) {
            return resolvedFile;
        }
        if (this.myElementToImport == null) {
            return null;
        }
        if (ES6CreateImportUtil.checkSymbolInFile(this.myProject, resolvedFile, this.myElementToImport, this.myPlace)) {
            return resolvedFile;
        }
        return null;
    }

    @Nullable
    private VirtualFile resolveAsNpmPackage(@NotNull VirtualFile pathFile, @NotNull PsiElement context) {
        if (pathFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(24);
        }
        if (context == null) {
            JSImportPathBuilder.$$$reportNull$$$0(25);
        }
        NodeModuleDirectorySearchProcessor processor = DialectDetector.isTypeScript(context) ? new TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor(this.myProject) : NodeModuleDirectorySearchProcessor.PROCESSOR;
        return JSExactFileReference.resolveForNpmPackages(pathFile, processor);
    }

    @Nullable
    private String getPathRelativeToRoots(@NotNull VirtualFile moduleFile) {
        String path;
        ModuleRootManager rootManager;
        Object[] sourceRoots;
        String path2;
        WebResourcesPathsConfiguration pathsConfiguration;
        if (moduleFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(26);
        }
        if ((pathsConfiguration = WebResourcesPathsConfiguration.getInstance((Project)this.myProject)) != null && (path2 = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, pathsConfiguration.getResourceDirectories(), false)) != null) {
            return path2;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)this.myPlace);
        if (module != null && (sourceRoots = (rootManager = ModuleRootManager.getInstance((Module)module)).getSourceRoots()).length > 0 && (path = JSFileReferencesUtil.getShortestPathInContexts(moduleFile, ContainerUtil.newArrayList((Object[])sourceRoots), false)) != null) {
            return path;
        }
        VirtualFile contentRoot = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex().getContentRootForFile(this.myPlaceFile);
        return contentRoot != null ? VfsUtil.getPath((VirtualFile)contentRoot, (VirtualFile)moduleFile, (char)'/') : null;
    }

    @Nullable
    public static VirtualFile getDirectoryToCalcModuleNameInNodeModules(@NotNull PsiFile placePsiFile, VirtualFile moduleDirectory) {
        VirtualFile parentOfNodeModules;
        VirtualFile directoryToCalcModuleName;
        if (placePsiFile == null) {
            JSImportPathBuilder.$$$reportNull$$$0(27);
        }
        VirtualFile placeFile = placePsiFile.getVirtualFile();
        VirtualFile current = moduleDirectory;
        VirtualFile nodeModulesDirectory = null;
        Object object = directoryToCalcModuleName = "@types".equals(current.getName()) ? current : null;
        while (current != null) {
            if ((current = current.getParent()) == null) continue;
            String name = current.getName();
            if ("@types".equals(name)) {
                directoryToCalcModuleName = current;
                continue;
            }
            if (!"node_modules".equals(current.getName())) continue;
            nodeModulesDirectory = current;
            break;
        }
        if (nodeModulesDirectory == null) {
            return null;
        }
        if (directoryToCalcModuleName == null) {
            directoryToCalcModuleName = nodeModulesDirectory;
        }
        if (!VfsUtilCore.isAncestor((VirtualFile)(parentOfNodeModules = nodeModulesDirectory.getParent()), (VirtualFile)placeFile, (boolean)true)) {
            return null;
        }
        return directoryToCalcModuleName;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 20: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 20: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileToImport";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dstFile";
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 8: 
            case 14: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFileOrDirectory";
                break;
            }
            case 9: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolvedModuleFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathFile";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleFile";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "placePsiFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ecmascript6/psi/impl/JSImportPathBuilder";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createBuilder";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getPathForRoot";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "createSearchProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createBuilder";
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 20: 
            case 22: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processRootPaths";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "processDirectModuleNames";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processWithNodeResolution";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processForModuleFile";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "processExtensionsForModuleFile";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getPathForRoot";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "processModuleNames";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "checkSymbolAndGetFile";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "resolveAsNpmPackage";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "getPathRelativeToRoots";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getDirectoryToCalcModuleNameInNodeModules";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 7: 
            case 19: 
            case 20: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

