/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.WhitespacesBinders;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.parsing.ES6ExpressionParser;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSKeywordSets;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.FunctionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.lang.javascript.parsing.StatementParser;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSModifiersStructureLeaf;
import com.intellij.lang.javascript.parsing.modifiers.JSOneOfModifiersStructure;
import com.intellij.lang.javascript.parsing.modifiers.JSOrderedModifiersStructure;
import com.intellij.lang.javascript.psi.JSStubElementType;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.stubs.JSVarStatementStub;
import com.intellij.psi.tree.IElementType;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;

public class ES6StatementParser<P extends ES6Parser<?, ?, ?, ?>>
extends StatementParser<P> {
    private static final JSModifiersStructure CLASS_MEMBER_MODIFIERS_STRUCTURE = new JSOrderedModifiersStructure(new JSOneOfModifiersStructure(JSTokenTypes.PRIVATE_KEYWORD, JSTokenTypes.PUBLIC_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.STATIC_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.ASYNC_KEYWORD), new JSModifiersStructureLeaf(JSTokenTypes.MULT));
    private static final Predicate<PsiBuilder> IS_MEMBER_NAME_START = builder -> {
        IElementType token = builder.getTokenType();
        return JSKeywordSets.PROPERTY_NAMES.contains(token) || token == JSTokenTypes.MULT || token == JSTokenTypes.LBRACKET;
    };

    public ES6StatementParser(P parser) {
        super(parser);
    }

    @Override
    protected void parseClassMember() {
        PsiBuilder.Marker classMember = this.builder.mark();
        int classMemberOffset = this.builder.getCurrentOffset();
        if (this.builder.getTokenType() == JSTokenTypes.SEMICOLON) {
            classMember.drop();
            this.parseEmptyStatement();
            return;
        }
        boolean wasGenerator = ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).isGeneratorContext();
        boolean lexerAdvanced = this.parseClassMemberModifiers();
        IElementType nextToken = this.builder.getTokenType();
        if (nextToken == JSTokenTypes.MIXIN_KEYWORD && this.isIdentifierToken(this.builder.lookAhead(1))) {
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
                ((ES6Parser)this.myJavaScriptParser).buildTokenElement(JSElementTypes.REFERENCE_EXPRESSION);
            }
            this.forceCheckForSemicolon();
            classMember.done(JSElementTypes.MIXIN_STATEMENT);
        } else if (this.isNamedClassMemberStart()) {
            this.parseNamedClassMember(classMember);
        } else {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.statement", (Object[])new Object[0]));
            if (!lexerAdvanced) {
                this.builder.advanceLexer();
            }
            classMember.drop();
        }
        ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).setIsGenerator(wasGenerator);
        assert (this.builder.getCurrentOffset() > classMemberOffset);
    }

    protected boolean parseClassMemberModifiers() {
        return ((ES6Parser)this.myJavaScriptParser).parseModifiers(CLASS_MEMBER_MODIFIERS_STRUCTURE, false, IS_MEMBER_NAME_START);
    }

    protected boolean isNamedClassMemberStart() {
        IElementType nextToken = this.builder.getTokenType();
        return nextToken == JSTokenTypes.GET_KEYWORD || nextToken == JSTokenTypes.SET_KEYWORD || nextToken == JSTokenTypes.MULT && ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).isPropertyNameStart(this.builder.lookAhead(1)) || ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).isPropertyNameStart(nextToken);
    }

    protected void parseNamedClassMember(@NotNull PsiBuilder.Marker classMember) {
        if (classMember == null) {
            ES6StatementParser.$$$reportNull$$$0(0);
        }
        IElementType lookahead = this.builder.lookAhead(1);
        PsiBuilder.Marker mark = this.builder.mark();
        boolean skipName = false;
        IElementType nextToken = this.builder.getTokenType();
        if (nextToken == JSTokenTypes.LBRACKET) {
            this.parseMemberPropertyWithBrackets();
            skipName = true;
            lookahead = this.builder.getTokenType();
        } else if ((nextToken == JSTokenTypes.GET_KEYWORD || nextToken == JSTokenTypes.SET_KEYWORD || nextToken == JSTokenTypes.MULT) && ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).isPropertyNameStart(this.builder.lookAhead(1))) {
            boolean isGenerator = false;
            if (nextToken == JSTokenTypes.MULT) {
                this.builder.advanceLexer();
                isGenerator = true;
                if (lookahead == JSTokenTypes.LBRACKET) {
                    this.parseMemberPropertyWithBrackets();
                    skipName = true;
                }
            }
            mark.drop();
            boolean wasGenerator = ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).isGeneratorContext();
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).setIsGenerator(isGenerator);
            this.parseMemberFunction(classMember, skipName);
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).setIsGenerator(wasGenerator);
            return;
        }
        if (this.isPossibleMemberFunctionStart(lookahead)) {
            mark.drop();
            boolean wasGenerator = ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).isGeneratorContext();
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).setIsGenerator(false);
            this.parseMemberFunction(classMember, skipName);
            ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).setIsGenerator(wasGenerator);
        } else {
            this.parseMemberVariable(mark, skipName);
            this.forceCheckForSemicolon();
            classMember.done(this.getFieldStatementElementType());
            classMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
        }
    }

    protected JSStubElementType<JSVarStatementStub, JSVarStatement> getFieldStatementElementType() {
        return ES6ElementTypes.FIELD_STATEMENT;
    }

    protected void parseMemberPropertyWithBrackets() {
        ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
    }

    protected boolean isPossibleMemberFunctionStart(IElementType lookahead) {
        return JSTokenTypes.LPAR == lookahead || JSTokenTypes.LT == lookahead;
    }

    protected void parseMemberFunction(PsiBuilder.Marker classMember, boolean skipName) {
        if (!skipName) {
            this.parserMemberFunctionName();
        }
        ES6FunctionParser functionParser = (ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser();
        functionParser.parseParameterList(false);
        ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.LBRACE) {
            ((ES6StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).parseFunctionBody();
        } else {
            this.checkMemberFunctionSuffix();
        }
        this.checkForSemicolon();
        classMember.done(functionParser.getFunctionDeclarationElementType());
        classMember.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected boolean parserMemberFunctionName() {
        boolean nameParsed = ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseFunctionName(true, FunctionParser.Context.PROPERTY);
        if (!nameParsed) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.function.name", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected void checkMemberFunctionSuffix() {
        ES6StatementParser.checkMatches(this.builder, JSTokenTypes.SEMICOLON, "javascript.parser.message.expected.lbrace.or.semicolon");
    }

    protected void parseMemberVariable(PsiBuilder.Marker var, boolean skipName) {
        if (!skipName) {
            this.parseMemberVariableName();
        }
        ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseType();
        if (this.builder.getTokenType() == JSTokenTypes.EQ) {
            this.parseVariableInitializer(false);
        }
        var.done(this.getFieldElementType());
        var.setCustomEdgeTokenBinders(INCLUDE_DOC_COMMENT_AT_LEFT, WhitespacesBinders.DEFAULT_RIGHT_BINDER);
    }

    protected void parseMemberVariableName() {
        ((ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser()).parsePropertyName();
    }

    @Override
    protected boolean parseReferenceListMember() {
        PsiBuilder.Marker refMember = this.builder.mark();
        ES6ExpressionParser expressionParser = (ES6ExpressionParser)((ES6Parser)this.myJavaScriptParser).getExpressionParser();
        boolean result = expressionParser.parseLeftHandSideExpression(false);
        if (result) {
            ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseTypeArgumentList(true, true);
            refMember.done((IElementType)JSStubElementTypes.EXTENDS_LIST_MEMBER);
        } else {
            refMember.drop();
        }
        return result;
    }

    public static boolean isAttributeListPartOrMethodNameStart(IElementType token) {
        return JSKeywordSets.PROPERTY_NAMES.contains(token) || token == JSTokenTypes.MULT || token == JSTokenTypes.LBRACKET;
    }

    @Override
    public boolean parseForLoopHeader() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.AWAIT_KEYWORD) {
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            return this.parseForLoopHeaderCondition();
        }
        return super.parseForLoopHeader();
    }

    @Override
    protected boolean isModifier(IElementType token) {
        if (token == JSTokenTypes.ASYNC_KEYWORD) {
            return this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD;
        }
        return super.isModifier(token);
    }

    @Override
    public IElementType getFieldElementType() {
        return ES6ElementTypes.FIELD;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classMember", "com/intellij/lang/ecmascript6/parsing/ES6StatementParser", "parseNamedClassMember"));
    }
}

