/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ecmascript6.parsing;

import com.intellij.lang.PsiBuilder;
import com.intellij.lang.ecmascript6.ES6ElementTypes;
import com.intellij.lang.ecmascript6.parsing.ES6FunctionParser;
import com.intellij.lang.ecmascript6.parsing.ES6Parser;
import com.intellij.lang.ecmascript6.parsing.ES6StatementParser;
import com.intellij.lang.javascript.JSBundle;
import com.intellij.lang.javascript.JSElementTypes;
import com.intellij.lang.javascript.JSStubElementTypes;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.parsing.ExpressionParser;
import com.intellij.lang.javascript.parsing.JSPsiTypeParser;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ES6ExpressionParser<T extends ES6Parser<?, ?, ?, ?>>
extends ExpressionParser<T> {
    public ES6ExpressionParser(T parser) {
        super(parser);
    }

    protected static int getUncollapsedComparisonOperatorsPriority(boolean advance, @NotNull PsiBuilder builder) {
        IElementType tokenType;
        if (builder == null) {
            ES6ExpressionParser.$$$reportNull$$$0(0);
        }
        if ((tokenType = builder.getTokenType()) == JSTokenTypes.GT && builder.rawLookup(1) == JSTokenTypes.EQ) {
            if (advance) {
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                builder.advanceLexer();
                marker.collapse(JSTokenTypes.GE);
            }
            return 6;
        }
        if (tokenType == JSTokenTypes.GT && builder.rawLookup(1) == JSTokenTypes.GT) {
            if (advance) {
                PsiBuilder.Marker marker = builder.mark();
                builder.advanceLexer();
                builder.advanceLexer();
                if (builder.getTokenType() == JSTokenTypes.GT) {
                    builder.advanceLexer();
                    marker.collapse(JSTokenTypes.GTGTGT);
                } else {
                    marker.collapse(JSTokenTypes.GTGT);
                }
            }
            return 7;
        }
        return -1;
    }

    @Override
    protected boolean parsePropertyNoMarker(PsiBuilder.Marker property) {
        if (((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).tryParseES7Decorators() && (this.builder.getTokenType() == JSTokenTypes.RBRACE || this.builder.getTokenType() == JSTokenTypes.LBRACKET)) {
            this.builder.error("Expected property name");
            property.done((IElementType)ES6ElementTypes.PROPERTY);
            return true;
        }
        return super.parsePropertyNoMarker(property);
    }

    @Override
    protected boolean isPropertyStart(IElementType elementType) {
        return super.isPropertyStart(elementType) || elementType == JSTokenTypes.MULT || elementType == JSTokenTypes.AT;
    }

    @Override
    protected void parseDestructuringProperty() {
        if (this.tryParseDestructuringRestElement((IElementType)JSStubElementTypes.DESTRUCTURING_PROPERTY)) {
            return;
        }
        super.parseDestructuringProperty();
    }

    private boolean tryParseDestructuringRestElement(IElementType type) {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            PsiBuilder.Marker property = this.builder.mark();
            this.builder.advanceLexer();
            if (this.isIdentifierToken(this.builder.getTokenType())) {
                PsiBuilder.Marker var = this.builder.mark();
                this.builder.advanceLexer();
                IElementType varType = (IElementType)this.builder.getUserData(DESTRUCTURING_VAR_TYPE);
                assert (varType != null);
                var.done(varType);
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            }
            property.done(type);
            return true;
        }
        return false;
    }

    @Override
    protected void parseDestructuringArrayElement() {
        if (this.tryParseDestructuringRestElement((IElementType)JSStubElementTypes.DESTRUCTURING_ARRAY_REST)) {
            return;
        }
        super.parseDestructuringArrayElement();
    }

    @Override
    protected boolean parseQualifiedTypeNameTail(PsiBuilder.Marker expr) {
        expr.drop();
        return ((JSPsiTypeParser)((ES6Parser)this.myJavaScriptParser).getTypeParser()).tryParseTypeArgumentList(false);
    }

    @Override
    protected boolean parseArrayElement(boolean first, Ref<IElementType> elementTypeRef) {
        boolean parseMoreElements = true;
        if (first && this.builder.getTokenType() == JSTokenTypes.FOR_KEYWORD) {
            elementTypeRef.set((Object)JSElementTypes.ARRAY_COMPREHENSION);
            ((ES6StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).parseForLoopHeader();
            while (true) {
                if (this.builder.getTokenType() == JSTokenTypes.IF_KEYWORD) {
                    ((ES6StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).parseIfStatementHeader();
                    continue;
                }
                if (this.builder.getTokenType() != JSTokenTypes.FOR_KEYWORD) break;
                ((ES6StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).parseForLoopHeader();
            }
            parseMoreElements = false;
        }
        if (!this.parseSpreadExpression()) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            parseMoreElements = false;
        }
        return parseMoreElements;
    }

    @Override
    @Nullable
    protected IElementType getSafeAccessOperator() {
        return JSTokenTypes.ELVIS;
    }

    @Override
    protected boolean isReferenceQualifierSeparator(IElementType tokenType) {
        return super.isReferenceQualifierSeparator(tokenType) || tokenType == this.getSafeAccessOperator();
    }

    @Override
    protected boolean parseArgument() {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            return this.parseSpreadExpression();
        }
        return super.parseArgument();
    }

    private boolean parseSpreadExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.DOT_DOT_DOT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            if (!this.parseAssignmentExpression(true, false)) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
                marker.drop();
                return false;
            }
            marker.done(JSElementTypes.SPREAD_EXPRESSION);
        } else if (!this.parseAssignmentExpression(true, false)) {
            this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    @Override
    protected boolean parseUnaryExpression() {
        IElementType type = this.builder.getTokenType();
        if (type == JSTokenTypes.AWAIT_KEYWORD) {
            if (!((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).isAsyncContext()) {
                return this.parsePostfixExpression();
            }
            PsiBuilder.Marker expr = this.builder.mark();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.MULT) {
                this.builder.advanceLexer();
            }
            if (!this.parseUnaryExpression()) {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.expression", (Object[])new Object[0]));
            }
            expr.done(JSElementTypes.PREFIX_EXPRESSION);
            return true;
        }
        PsiBuilder.Marker expr = this.builder.mark();
        boolean result = super.parseUnaryExpression();
        if (this.builder.getTokenType() != JSTokenTypes.MULTMULT) {
            expr.drop();
            return result;
        }
        this.builder.advanceLexer();
        this.parseUnaryExpression();
        expr.done(JSElementTypes.BINARY_EXPRESSION);
        return true;
    }

    @Override
    public boolean parsePrimaryExpression() {
        if (this.builder.getTokenType() == JSTokenTypes.ASYNC_KEYWORD && this.builder.lookAhead(1) == JSTokenTypes.FUNCTION_KEYWORD) {
            PsiBuilder.Marker asyncStart = this.builder.mark();
            if (((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseFunctionExpression()) {
                asyncStart.drop();
                return true;
            }
            asyncStart.rollbackTo();
        }
        if (this.builder.getTokenType() == JSTokenTypes.DO_KEYWORD) {
            PsiBuilder.Marker doMarker = this.builder.mark();
            this.builder.advanceLexer();
            ((ES6StatementParser)((ES6Parser)this.myJavaScriptParser).getStatementParser()).parseBlock();
            doMarker.done(ES6ElementTypes.DO_EXPRESSION);
            return true;
        }
        return super.parsePrimaryExpression();
    }

    @Override
    protected boolean parseNewExpression() {
        LOG.assertTrue(this.builder.getTokenType() == JSTokenTypes.NEW_KEYWORD);
        if (this.builder.lookAhead(1) == JSTokenTypes.DOT) {
            PsiBuilder.Marker marker = this.builder.mark();
            this.builder.advanceLexer();
            this.builder.advanceLexer();
            if (this.builder.getTokenType() == JSTokenTypes.IDENTIFIER) {
                if (!"target".equals(this.builder.getTokenText())) {
                    this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.target", (Object[])new Object[0]));
                }
                this.builder.advanceLexer();
            } else {
                this.builder.error(JSBundle.message((String)"javascript.parser.message.expected.identifier", (Object[])new Object[0]));
            }
            marker.done(ES6ElementTypes.META_PROPERTY);
            return false;
        }
        return super.parseNewExpression();
    }

    @Override
    public boolean parseAssignmentExpression(boolean allowIn, boolean withinPropertyInitializer) {
        if ((this.builder.getTokenType() == JSTokenTypes.LPAR || this.isIdentifierToken(this.builder.getTokenType())) && ((ES6FunctionParser)((ES6Parser)this.myJavaScriptParser).getFunctionParser()).parseArrowFunction()) {
            return true;
        }
        return super.parseAssignmentExpression(allowIn, withinPropertyInitializer);
    }

    @Override
    protected boolean hasGeneratorsSupport() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/lang/ecmascript6/parsing/ES6ExpressionParser", "getUncollapsedComparisonOperatorsPriority"));
    }
}

