/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.DefaultExecutionResult;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.filters.Filter;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.autotest.ToggleAutoTestAction;
import com.intellij.execution.testframework.sm.SMCustomMessagesParsing;
import com.intellij.execution.testframework.sm.SMTestRunnerConnectionUtil;
import com.intellij.execution.testframework.sm.runner.SMTRunnerConsoleProperties;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.execution.testframework.ui.BaseTestsOutputConsoleView;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.javascript.HelperFilesLocator;
import com.intellij.javascript.nodejs.NodeCommandLineUtil;
import com.intellij.javascript.nodejs.debug.NodeLocalDebugRunProfileState;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorConsoleFilter;
import com.intellij.javascript.protractor.ProtractorOutputToGeneralTestEventsConverter;
import com.intellij.javascript.protractor.ProtractorRunConfiguration;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.javascript.testFramework.navigation.JSTestLocationProvider;
import com.intellij.lang.javascript.buildTools.base.JsbtUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.PathUtil;
import com.intellij.util.config.AbstractProperty;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.execution.ParametersListUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorRunState
implements RunProfileState,
NodeLocalDebugRunProfileState {
    public static final String FRAMEWORK_NAME = "ProtractorJavaScriptTestRunner";
    private static final String INTELLIJ_CONFIG_FILE_PATH = "protractor-intellij/lib/protractor-intellij-config.js";
    private final Project myProject;
    private final ProtractorRunConfiguration myRunConfiguration;
    private final ExecutionEnvironment myEnvironment;
    private final NodePackage myProtractorPackage;
    private final ProtractorRunSettings myRunSettings;

    public ProtractorRunState(@NotNull ProtractorRunConfiguration runConfiguration, @NotNull ExecutionEnvironment environment, @NotNull NodePackage protractorPackage) {
        if (runConfiguration == null) {
            ProtractorRunState.$$$reportNull$$$0(0);
        }
        if (environment == null) {
            ProtractorRunState.$$$reportNull$$$0(1);
        }
        if (protractorPackage == null) {
            ProtractorRunState.$$$reportNull$$$0(2);
        }
        this.myProject = runConfiguration.getProject();
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myProtractorPackage = protractorPackage;
        this.myRunSettings = runConfiguration.getRunSettings();
    }

    @Override
    @NotNull
    public ExecutionResult execute(int debugPort) throws ExecutionException {
        NodeJsLocalInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolveAsLocal(this.myProject);
        GeneralCommandLine commandLine = this.createCommandLine(interpreter, debugPort);
        OSProcessHandler processHandler = NodeCommandLineUtil.createProcessHandler(commandLine, false);
        ConsoleView consoleView = this.createSmtRunnerConsoleView(commandLine.getWorkDirectory());
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        consoleView.attachToProcess((ProcessHandler)processHandler);
        this.foldCommandLine(consoleView, (ProcessHandler)processHandler);
        DefaultExecutionResult executionResult = new DefaultExecutionResult((ExecutionConsole)consoleView, (ProcessHandler)processHandler);
        executionResult.setRestartActions(new AnAction[]{new ToggleAutoTestAction()});
        DefaultExecutionResult defaultExecutionResult = executionResult;
        if (defaultExecutionResult == null) {
            ProtractorRunState.$$$reportNull$$$0(3);
        }
        return defaultExecutionResult;
    }

    @NotNull
    private ConsoleView createSmtRunnerConsoleView(@Nullable File workingDirectory) {
        ProtractorConsoleProperties testConsoleProperties = new ProtractorConsoleProperties(this.myRunConfiguration, this.myEnvironment.getExecutor(), (SMTestLocator)new JSTestLocationProvider());
        BaseTestsOutputConsoleView consoleView = SMTestRunnerConnectionUtil.createConsole((String)FRAMEWORK_NAME, (TestConsoleProperties)testConsoleProperties);
        consoleView.addMessageFilter((Filter)new ProtractorConsoleFilter(this.myProject, workingDirectory));
        Disposer.register((Disposable)this.myProject, (Disposable)consoleView);
        BaseTestsOutputConsoleView baseTestsOutputConsoleView = consoleView;
        if (baseTestsOutputConsoleView == null) {
            ProtractorRunState.$$$reportNull$$$0(4);
        }
        return baseTestsOutputConsoleView;
    }

    @Override
    public void foldCommandLine(@NotNull ConsoleView consoleView, @NotNull ProcessHandler processHandler) {
        if (consoleView == null) {
            ProtractorRunState.$$$reportNull$$$0(5);
        }
        if (processHandler == null) {
            ProtractorRunState.$$$reportNull$$$0(6);
        }
        String configFileName = PathUtil.getFileName((String)this.myRunSettings.getConfigFileSystemDependentPath());
        String foldedCommandLine = ParametersListUtil.join((List)ContainerUtil.newArrayList((Object[])new String[]{"protractor", configFileName}));
        JsbtUtil.foldCommandLine(consoleView, processHandler, foldedCommandLine);
    }

    @NotNull
    private GeneralCommandLine createCommandLine(@NotNull NodeJsLocalInterpreter interpreter, int debugPort) throws ExecutionException {
        File intellijConfigFile;
        if (interpreter == null) {
            ProtractorRunState.$$$reportNull$$$0(7);
        }
        GeneralCommandLine commandLine = new GeneralCommandLine();
        commandLine.setCharset(StandardCharsets.UTF_8);
        this.myRunSettings.getEnvData().configureCommandLine(commandLine, true);
        String originalConfigFilePath = this.myRunSettings.getConfigFileSystemDependentPath();
        commandLine.setWorkDirectory(PathUtil.getParentPath((String)originalConfigFilePath));
        commandLine.setExePath(interpreter.getInterpreterSystemDependentPath());
        NodeCommandLineUtil.addNodeOptionsForDebugging(commandLine, Collections.emptyList(), debugPort, true, interpreter, true);
        NodeCommandLineUtil.configureUsefulEnvironment(commandLine);
        commandLine.addParameter(ProtractorUtil.getProtractorMainJsFile(this.myProtractorPackage).getAbsolutePath());
        try {
            intellijConfigFile = HelperFilesLocator.getFileRelativeToHelpersDir(INTELLIJ_CONFIG_FILE_PATH);
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot locate wrapper config file", (Throwable)e);
        }
        commandLine.addParameter(intellijConfigFile.getAbsolutePath());
        commandLine.addParameter("--intellijOriginalConfigFile=" + originalConfigFilePath);
        commandLine.addParameter("--disableChecks");
        GeneralCommandLine generalCommandLine = commandLine;
        if (generalCommandLine == null) {
            ProtractorRunState.$$$reportNull$$$0(8);
        }
        return generalCommandLine;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "protractorPackage";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/protractor/ProtractorRunState";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consoleView";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunState";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "execute";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createSmtRunnerConsoleView";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createCommandLine";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "foldCommandLine";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createCommandLine";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ProtractorConsoleProperties
    extends SMTRunnerConsoleProperties
    implements SMCustomMessagesParsing {
        private final SMTestLocator myLocator;

        public ProtractorConsoleProperties(@NotNull ProtractorRunConfiguration configuration, @NotNull Executor executor, @NotNull SMTestLocator locator) {
            if (configuration == null) {
                ProtractorConsoleProperties.$$$reportNull$$$0(0);
            }
            if (executor == null) {
                ProtractorConsoleProperties.$$$reportNull$$$0(1);
            }
            if (locator == null) {
                ProtractorConsoleProperties.$$$reportNull$$$0(2);
            }
            super((RunConfiguration)configuration, ProtractorRunState.FRAMEWORK_NAME, executor);
            this.myLocator = locator;
            this.setUsePredefinedMessageFilter(false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_PASSED_TESTS, false);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.HIDE_IGNORED_TEST, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SCROLL_TO_SOURCE, true);
            this.setIfUndefined((AbstractProperty)TestConsoleProperties.SELECT_FIRST_DEFECT, true);
            this.setIdBasedTestTree(true);
            this.setPrintTestingStartedTime(false);
        }

        public SMTestLocator getTestLocator() {
            return this.myLocator;
        }

        public ProtractorOutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
            if (testFrameworkName == null) {
                ProtractorConsoleProperties.$$$reportNull$$$0(3);
            }
            if (consoleProperties == null) {
                ProtractorConsoleProperties.$$$reportNull$$$0(4);
            }
            return new ProtractorOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties.isEditable());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configuration";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "locator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testFrameworkName";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "consoleProperties";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunState$ProtractorConsoleProperties";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createTestEventsConverter";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

