/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.protractor;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.javascript.JSRunProfileWithCompileBeforeLaunchOption;
import com.intellij.javascript.nodejs.debug.NodeDebugRunConfiguration;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreter;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.protractor.ProtractorRunConfigurationEditor;
import com.intellij.javascript.protractor.ProtractorRunSettings;
import com.intellij.javascript.protractor.ProtractorRunState;
import com.intellij.javascript.protractor.ProtractorUtil;
import com.intellij.javascript.testFramework.PreferableRunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.PathUtil;
import java.io.File;
import java.net.InetSocketAddress;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtractorRunConfiguration
extends LocatableConfigurationBase
implements NodeDebugRunConfiguration,
PreferableRunConfiguration,
JSRunProfileWithCompileBeforeLaunchOption {
    private ProtractorRunSettings myRunSettings;

    public ProtractorRunConfiguration(@NotNull Project project, @NotNull ConfigurationFactory factory, String name) {
        if (project == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(0);
        }
        if (factory == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(1);
        }
        super(project, factory, name);
        this.myRunSettings = ProtractorRunSettings.builder().build();
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) throws ExecutionException {
        if (executor == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(2);
        }
        if (environment == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(3);
        }
        NodePackage pkg = this.getProtractorPackage();
        return new ProtractorRunState(this, environment, pkg);
    }

    @NotNull
    public ProtractorRunConfigurationEditor getConfigurationEditor() {
        ProtractorRunConfigurationEditor protractorRunConfigurationEditor = new ProtractorRunConfigurationEditor(this.getProject());
        if (protractorRunConfigurationEditor == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(4);
        }
        return protractorRunConfigurationEditor;
    }

    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
        this.myRunSettings = ProtractorUtil.readXml(element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
        ProtractorUtil.writeXml(element, this.myRunSettings);
    }

    @NotNull
    public ProtractorRunSettings getRunSettings() {
        ProtractorRunSettings protractorRunSettings = this.myRunSettings;
        if (protractorRunSettings == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(5);
        }
        return protractorRunSettings;
    }

    public void setRunSettings(@NotNull ProtractorRunSettings runSettings) {
        if (runSettings == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(6);
        }
        this.myRunSettings = runSettings;
    }

    @NotNull
    private NodePackage getProtractorPackage() {
        Project project = this.getProject();
        NodeJsInterpreter interpreter = this.getRunSettings().getInterpreterRef().resolve(project);
        NodePackage nodePackage = ProtractorUtil.getProtractorPackage(project, null, interpreter, true);
        if (nodePackage == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(7);
        }
        return nodePackage;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        NodeJsInterpreter interpreter = this.myRunSettings.getInterpreterRef().resolve(this.getProject());
        ProtractorRunConfiguration.validatePath(false, "configuration file", this.myRunSettings.getConfigFileSystemDependentPath());
        NodeJsLocalInterpreter.checkForRunConfiguration(interpreter);
        NodePackage pkg = this.getProtractorPackage();
        ProtractorRunConfiguration.validatePath(true, "protractor package", pkg.getSystemDependentPath());
        File protractorMainJsFile = ProtractorUtil.getProtractorMainJsFile(pkg);
        ProtractorRunConfiguration.validatePath(false, "bin/protractor file in protractor package", protractorMainJsFile.getAbsolutePath());
    }

    public void initializeFields() {
        List<VirtualFile> configs;
        ProtractorRunSettings runSettings = this.myRunSettings;
        if (runSettings.getConfigFileSystemDependentPath().isEmpty() && (configs = ProtractorUtil.listExactConfigFilesInProject(this.getProject())).size() == 1) {
            this.setConfigFile(configs.get(0));
            this.setGeneratedName();
        }
        this.setNameChangedByUser(false);
    }

    public void setConfigFile(VirtualFile config2) {
        this.myRunSettings = this.myRunSettings.toBuilder().setConfigFilePath(config2.getPath()).build();
    }

    public boolean isPreferredOver(@NotNull RunConfiguration otherRc, @NotNull PsiElement sourceElement) {
        if (otherRc == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(8);
        }
        if (sourceElement == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(9);
        }
        return ProtractorUtil.isProtractorConfigFile(sourceElement.getContainingFile().getName());
    }

    @Override
    @Nullable
    public InetSocketAddress getDebugAddress() throws ExecutionException {
        return null;
    }

    private static void validatePath(boolean shouldBeDirectory, @NotNull String name, @Nullable String path) throws RuntimeConfigurationException {
        boolean exists;
        if (name == null) {
            ProtractorRunConfiguration.$$$reportNull$$$0(10);
        }
        if (StringUtil.isEmptyOrSpaces((String)path)) {
            throw new RuntimeConfigurationError("Unspecified " + name);
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            throw new RuntimeConfigurationError("No such " + name);
        }
        boolean bl = exists = shouldBeDirectory ? file.isDirectory() : file.isFile();
        if (!exists) {
            throw new RuntimeConfigurationError("No such " + name);
        }
    }

    public String suggestedName() {
        String name = PathUtil.getFileName((String)this.myRunSettings.getConfigFileSystemDependentPath());
        return StringUtil.isEmptyOrSpaces((String)name) ? null : name;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "factory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "executor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/protractor/ProtractorRunConfiguration";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runSettings";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "otherRc";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceElement";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/protractor/ProtractorRunConfiguration";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigurationEditor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunSettings";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getProtractorPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setRunSettings";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isPreferredOver";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "validatePath";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

