/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.javascript.nodejs.interpreter.LeftRightJustifyingLayoutManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRenderer;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.text.SemVer;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackageRenderer
implements ListCellRenderer<NodePackage> {
    private final SimpleColoredComponent myNameComp = new SimpleColoredComponent();
    private final SimpleColoredComponent myVersionComp = new SimpleColoredComponent();
    private final JPanel myPanel = new JPanel(new GridBagLayout());

    public NodePackageRenderer() {
        this.myNameComp.setOpaque(false);
        this.myVersionComp.setOpaque(false);
        this.myPanel.setBorder(new EmptyBorder(0, 1, 0, 1));
        this.myNameComp.setIpad((Insets)JBUI.emptyInsets());
        this.myVersionComp.setIpad((Insets)JBUI.insets((int)0, (int)10, (int)0, (int)0));
        NodeJsInterpreterRenderer.adjustBorderHeight(this.myNameComp);
        this.myVersionComp.setMyBorder(null);
        JPanel nameContainer = NodePackageRenderer.wrapInLeftRightJustifyingContainer(this.myNameComp);
        this.myPanel.add((Component)nameContainer, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 256, 2, (Insets)JBUI.emptyInsets(), 0, 0));
        this.myPanel.add((Component)this.myVersionComp, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 256, 0, (Insets)JBUI.emptyInsets(), 0, 0));
    }

    @NotNull
    private static JPanel wrapInLeftRightJustifyingContainer(final @NotNull SimpleColoredComponent component) {
        if (component == null) {
            NodePackageRenderer.$$$reportNull$$$0(0);
        }
        JPanel container = new JPanel((LayoutManager)new LeftRightJustifyingLayoutManager()){

            @Override
            public int getBaseline(int width, int height) {
                return component.getBaseline(width, height);
            }
        };
        container.setBorder((Border)JBUI.Borders.empty());
        container.setOpaque(false);
        container.add((Component)component);
        JPanel jPanel = container;
        if (jPanel == null) {
            NodePackageRenderer.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    @Override
    public Component getListCellRendererComponent(@NotNull JList<? extends NodePackage> list, @Nullable NodePackage value, int index, boolean isSelected, boolean cellHasFocus) {
        if (list == null) {
            NodePackageRenderer.$$$reportNull$$$0(2);
        }
        this.myNameComp.clear();
        this.myVersionComp.clear();
        Font baseFont = list.getFont();
        this.myNameComp.setFont(baseFont);
        this.myVersionComp.setFont(UIUtil.getFont((UIUtil.FontSize)UIUtil.FontSize.SMALL, (Font)baseFont));
        if (this.myPanel.isEnabled() != list.isEnabled()) {
            UIUtil.setEnabled((Component)this.myPanel, (boolean)list.isEnabled(), (boolean)true);
        }
        this.myPanel.setBackground(isSelected ? list.getSelectionBackground() : list.getBackground());
        Color foreground = isSelected ? list.getSelectionForeground() : list.getForeground();
        this.myNameComp.setForeground(foreground);
        this.myVersionComp.setForeground(foreground);
        if (value != null) {
            this.customize(value, isSelected);
        }
        return this.myPanel;
    }

    private void customize(@NotNull NodePackage nodePackage, boolean isSelected) {
        if (nodePackage == null) {
            NodePackageRenderer.$$$reportNull$$$0(3);
        }
        this.myNameComp.append(nodePackage.getPresentablePath(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
        SemVer version = nodePackage.getVersion();
        if (version != null) {
            SimpleTextAttributes attrs = isSelected ? SimpleTextAttributes.REGULAR_ATTRIBUTES : SimpleTextAttributes.GRAY_ATTRIBUTES;
            this.myVersionComp.append(version.getRawVersion(), attrs);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackageRenderer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodePackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackageRenderer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "wrapInLeftRightJustifyingContainer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "wrapInLeftRightJustifyingContainer";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getListCellRendererComponent";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "customize";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

