/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.util;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.javascript.nodejs.PackageJsonData;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.util.NodePackageDescriptor;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.SemVer;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodePackage {
    @NotNull
    private final String mySystemDependentPath;
    @NotNull
    private final File myDir;

    public NodePackage(@NotNull String path) {
        if (path == null) {
            NodePackage.$$$reportNull$$$0(0);
        }
        path = StringUtil.trimEnd((String)FileUtil.toSystemIndependentName((String)path), (char)'/');
        this.mySystemDependentPath = FileUtil.toSystemDependentName((String)path);
        this.myDir = new File(this.mySystemDependentPath);
    }

    @NotNull
    public String getSystemIndependentPath() {
        String string = FileUtil.toSystemIndependentName((String)this.mySystemDependentPath);
        if (string == null) {
            NodePackage.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NotNull
    public String getSystemDependentPath() {
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isEmptyPath() {
        return this.mySystemDependentPath.isEmpty();
    }

    @NotNull
    public String getName() {
        String string = PathUtil.getFileName((String)this.mySystemDependentPath);
        if (string == null) {
            NodePackage.$$$reportNull$$$0(3);
        }
        return string;
    }

    @Nullable
    public SemVer getVersion() {
        VirtualFile file = LocalFileSystem.getInstance().findFileByIoFile(new File(this.myDir, "package.json"));
        return file != null ? PackageJsonData.getOrCreate(file).getVersion() : null;
    }

    @NotNull
    public String getPresentablePath() {
        String userHome = StringUtil.trimEnd((String)FileUtil.toSystemDependentName((String)SystemProperties.getUserHome()), (char)File.separatorChar);
        if (StringUtil.isEmptyOrSpaces((String)userHome)) {
            String string = this.mySystemDependentPath;
            if (string == null) {
                NodePackage.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (this.mySystemDependentPath.startsWith(userHome + File.separatorChar)) {
            String string = "~" + this.mySystemDependentPath.substring(userHome.length());
            if (string == null) {
                NodePackage.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = this.mySystemDependentPath;
        if (string == null) {
            NodePackage.$$$reportNull$$$0(6);
        }
        return string;
    }

    public boolean isValid() {
        return !StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath) && this.myDir.isAbsolute() && this.myDir.isDirectory();
    }

    @Nullable
    public String getErrorMessage(@NotNull String packageName) {
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(7);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.mySystemDependentPath)) {
            return "Unspecified " + packageName + " package";
        }
        if (!this.myDir.isAbsolute() || !this.myDir.isDirectory()) {
            return "Invalid " + packageName + " package: no such directory";
        }
        return null;
    }

    public void validateForRunConfiguration(@NotNull String packageName) throws RuntimeConfigurationError {
        String message;
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(8);
        }
        if ((message = this.getErrorMessage(packageName)) != null) {
            throw new RuntimeConfigurationError(message);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NodePackage aPackage = (NodePackage)o;
        return this.mySystemDependentPath.equals(aPackage.mySystemDependentPath);
    }

    public int hashCode() {
        return this.mySystemDependentPath.hashCode();
    }

    @Nullable
    public static NodePackage findDefaultPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(9);
        }
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(10);
        }
        List<NodePackage> packages = new NodePackageDescriptor(packageName).listAvailable(project, interpreter, null);
        return (NodePackage)ContainerUtil.getFirstItem(packages);
    }

    @NotNull
    public static NodePackage findPreferredPackage(@NotNull Project project, @NotNull String packageName, @Nullable NodeJsInterpreter interpreter) {
        if (project == null) {
            NodePackage.$$$reportNull$$$0(11);
        }
        if (packageName == null) {
            NodePackage.$$$reportNull$$$0(12);
        }
        NodePackage nodePackage = new NodePackageDescriptor(packageName).findFirstDirectDependencyPackage(project, interpreter, null);
        if (nodePackage == null) {
            NodePackage.$$$reportNull$$$0(13);
        }
        return nodePackage;
    }

    public String toString() {
        return this.mySystemDependentPath;
    }

    @Nullable
    public File findBinFile() {
        PackageJsonData data;
        VirtualFile packageJson;
        VirtualFile packageDir = LocalFileSystem.getInstance().findFileByIoFile(this.myDir);
        if (packageDir != null && packageDir.isValid() && (packageJson = PackageJsonUtil.findChildPackageJsonFile(packageDir)) != null && (data = PackageJsonData.getOrCreate(packageJson)).getBinPath() != null) {
            return new File(packageDir.getPath(), data.getBinPath());
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/util/NodePackage";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageName";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/util/NodePackage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemIndependentPath";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getSystemDependentPath";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentablePath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "findPreferredPackage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getErrorMessage";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "validateForRunConfiguration";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "findDefaultPackage";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "findPreferredPackage";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

