/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.library;

import com.intellij.javascript.nodejs.library.NodeModulesLibraryDirectory;
import com.intellij.lang.javascript.modules.NodeModuleUtil;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeModulesLibrariesSnapshot {
    private static final Logger LOG = Logger.getInstance(NodeModulesLibrariesSnapshot.class);
    private final List<NodeModulesLibraryDirectory> myLibraryDirs;
    private final Map<VirtualFile, NodeModulesLibraryDirectory> myMap;

    public NodeModulesLibrariesSnapshot(@NotNull Project project, @NotNull Collection<VirtualFile> nodeModulesDirs) {
        if (project == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(0);
        }
        if (nodeModulesDirs == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(1);
        }
        ArrayList copy = ContainerUtil.newArrayList(nodeModulesDirs);
        this.myLibraryDirs = ContainerUtil.newArrayListWithCapacity((int)copy.size());
        this.myMap = ContainerUtilRt.newHashMap((int)copy.size());
        ReadAction.run(() -> {
            if (project == null) {
                NodeModulesLibrariesSnapshot.$$$reportNull$$$0(19);
            }
            NotNullLazyValue contentRoots = NotNullLazyValue.createValue(() -> {
                if (project == null) {
                    NodeModulesLibrariesSnapshot.$$$reportNull$$$0(20);
                }
                return ContainerUtil.newHashSet((Object[])ProjectRootManager.getInstance((Project)project).getContentRoots());
            });
            for (VirtualFile dir : copy) {
                if (dir.isValid()) {
                    String name = NodeModulesLibrariesSnapshot.buildLibraryName(project, dir, (NotNullLazyValue<Set<VirtualFile>>)contentRoots);
                    NodeModulesLibraryDirectory libraryDir = new NodeModulesLibraryDirectory(project, dir, name);
                    this.myLibraryDirs.add(libraryDir);
                    this.myMap.put(dir, libraryDir);
                    continue;
                }
                LOG.warn("Filtering out invalid library node_modules: " + dir.getPath());
            }
        });
    }

    @NotNull
    public List<NodeModulesLibraryDirectory> getLibraryDirs() {
        List<NodeModulesLibraryDirectory> list = this.myLibraryDirs;
        if (list == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(2);
        }
        return list;
    }

    @Nullable
    public String findLibraryName(@NotNull VirtualFile nodeModulesDir) {
        NodeModulesLibraryDirectory directory;
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(3);
        }
        return (directory = this.myMap.get(nodeModulesDir)) != null ? directory.getLibraryName() : null;
    }

    @Nullable
    public NodeModulesLibraryDirectory findLibraryDir(@NotNull VirtualFile nodeModulesDir) {
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(4);
        }
        return this.myMap.get(nodeModulesDir);
    }

    public void onFileCreatedOrDeleted(@NotNull VirtualFile file) {
        NodeModulesLibraryDirectory d;
        if (file == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(5);
        }
        if ((d = this.findNodeModulesDirectoryByTopLevelDependentFile(file)) != null) {
            d.invalidateRoots();
        }
    }

    public void onPackageJsonFileChanged(@NotNull VirtualFile packageJson) {
        NodeModulesLibraryDirectory d;
        NodeModulesLibraryDirectory directory;
        VirtualFile nodeModulesDir;
        if (packageJson == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(6);
        }
        if ((nodeModulesDir = NodeModuleUtil.findNodeModulesByPackageJson(packageJson)) != null && (directory = this.myMap.get(nodeModulesDir)) != null) {
            directory.invalidateRoots();
        }
        if ((d = this.findNodeModulesDirectoryByTopLevelDependentFile(packageJson)) != null) {
            d.invalidateRoots();
        }
    }

    @Nullable
    private NodeModulesLibraryDirectory findNodeModulesDirectoryByTopLevelDependentFile(@NotNull VirtualFile file) {
        VirtualFile dir;
        if (file == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(7);
        }
        VirtualFile virtualFile = dir = file.isDirectory() ? file : file.getParent();
        for (int steps = 3; steps > 0 && dir != null; dir = dir.getParent(), --steps) {
            NodeModulesLibraryDirectory directory = this.myMap.get(dir);
            if (directory == null) continue;
            return directory;
        }
        return null;
    }

    @NotNull
    private static String buildLibraryName(@NotNull Project project, @NotNull VirtualFile nodeModulesDir, @NotNull NotNullLazyValue<Set<VirtualFile>> contentRoots) {
        String relativePath;
        VirtualFile baseDir;
        if (project == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(8);
        }
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(9);
        }
        if (contentRoots == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(10);
        }
        if ((baseDir = project.getBaseDir()) != null && (relativePath = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, baseDir, false)) != null) {
            String string = relativePath;
            if (string == null) {
                NodeModulesLibrariesSnapshot.$$$reportNull$$$0(11);
            }
            return string;
        }
        VirtualFile contentRoot = NodeModulesLibrariesSnapshot.findContentRoot(nodeModulesDir, (Set)contentRoots.getValue());
        if (contentRoot != null) {
            String relativePath2 = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, contentRoot, false);
            if (relativePath2 != null) {
                String string = relativePath2;
                if (string == null) {
                    NodeModulesLibrariesSnapshot.$$$reportNull$$$0(12);
                }
                return string;
            }
            LOG.error("Failed to buildRelativeName(" + nodeModulesDir.getPath() + ", " + contentRoot.getPath() + ")");
        }
        LOG.warn("Cannot generate library name for " + nodeModulesDir.getPath());
        String path = NodeModulesLibrariesSnapshot.buildRelativeName(nodeModulesDir, nodeModulesDir, true);
        if (path != null) {
            String string = path;
            if (string == null) {
                NodeModulesLibrariesSnapshot.$$$reportNull$$$0(13);
            }
            return string;
        }
        LOG.error("Failed to build relative name to itself: " + nodeModulesDir.getPath());
        if ("unknown_node_modules" == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(14);
        }
        return "unknown_node_modules";
    }

    @Nullable
    private static String buildRelativeName(@NotNull VirtualFile nodeModulesDir, @NotNull VirtualFile root, boolean prependEllipses) {
        String relativePath;
        if (nodeModulesDir == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(15);
        }
        if (root == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(16);
        }
        if (nodeModulesDir.equals(root)) {
            VirtualFile parentRoot = root.getParent();
            if (parentRoot == null) {
                return nodeModulesDir.getPath();
            }
            root = parentRoot;
        }
        if ((relativePath = VfsUtilCore.getRelativePath((VirtualFile)nodeModulesDir, (VirtualFile)root, (char)'/')) != null) {
            String path = root.getName() + '/' + relativePath;
            return prependEllipses ? ".../" + path : path;
        }
        return null;
    }

    @Nullable
    private static VirtualFile findContentRoot(@NotNull VirtualFile file, @NotNull Set<VirtualFile> contentRoots) {
        VirtualFile f;
        if (file == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(17);
        }
        if (contentRoots == null) {
            NodeModulesLibrariesSnapshot.$$$reportNull$$$0(18);
        }
        for (f = file; f != null && !contentRoots.contains(f); f = f.getParent()) {
        }
        return f;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDirs";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot";
                break;
            }
            case 3: 
            case 4: 
            case 9: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeModulesDir";
                break;
            }
            case 5: 
            case 7: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageJson";
                break;
            }
            case 10: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "contentRoots";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/library/NodeModulesLibrariesSnapshot";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryDirs";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "buildLibraryName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryName";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "findLibraryDir";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "onFileCreatedOrDeleted";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "onPackageJsonFileChanged";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findNodeModulesDirectoryByTopLevelDependentFile";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildLibraryName";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "buildRelativeName";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "findContentRoot";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$1";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

