/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter.remote;

import com.intellij.javascript.nodejs.NodeJSRemoteInterpreterManager;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterEditor;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreter;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.ui.CommonActionsPanel;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.NotNullFunction;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.StatusText;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Graphics;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NodeJsRemoteInterpreterType
extends NodeJsInterpreterType<NodeJsRemoteInterpreter> {
    private static final NodeJsRemoteInterpreterType INSTANCE = new NodeJsRemoteInterpreterType();
    private final NodeJSRemoteInterpreterManager myRemoteInterpreterManager = NodeJSRemoteInterpreterManager.getInstance();

    @NotNull
    public static NodeJsRemoteInterpreterType getInstance() {
        NodeJsRemoteInterpreterType nodeJsRemoteInterpreterType = INSTANCE;
        if (nodeJsRemoteInterpreterType == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(0);
        }
        return nodeJsRemoteInterpreterType;
    }

    @Override
    @NotNull
    public String getName() {
        if ("remote" == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(1);
        }
        return "remote";
    }

    @Override
    public boolean isAvailable() {
        return this.myRemoteInterpreterManager != null;
    }

    public boolean isRemoteReference(@NotNull NodeJsInterpreterRef ref) {
        String refName;
        if (ref == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(2);
        }
        return (refName = FileUtil.toSystemIndependentName((String)ref.getReferenceName())).startsWith("vagrant://") || refName.startsWith("sftp://") || refName.startsWith("docker://") || refName.startsWith("ssh://");
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter findByReferenceName(@NotNull String referenceName) {
        if (referenceName == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(3);
        }
        return new NodeJsRemoteInterpreter(referenceName);
    }

    @Override
    @NotNull
    public List<NodeJsRemoteInterpreter> getInterpreters() {
        if (this.myRemoteInterpreterManager != null) {
            List list = ContainerUtil.map(this.myRemoteInterpreterManager.getRemoteInterpreters(), (Function)((NotNullFunction)NodeJsRemoteInterpreter::new));
            if (list == null) {
                NodeJsRemoteInterpreterType.$$$reportNull$$$0(4);
            }
            return list;
        }
        List<NodeJsRemoteInterpreter> list = Collections.emptyList();
        if (list == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(5);
        }
        return list;
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter showAddDialog(@NotNull Project project) {
        String id;
        if (project == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(6);
        }
        if (this.myRemoteInterpreterManager != null && (id = this.myRemoteInterpreterManager.createRemoteInterpreter(project)) != null) {
            return new NodeJsRemoteInterpreter(id);
        }
        return null;
    }

    @Override
    public boolean isInplaceEditorAvailable() {
        return false;
    }

    @Override
    @Nullable
    public NodeJsRemoteInterpreter edit(@NotNull Project project, @NotNull NodeJsRemoteInterpreter interpreter) {
        String createdId;
        if (project == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(7);
        }
        if (interpreter == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(8);
        }
        if (this.myRemoteInterpreterManager != null && (createdId = this.myRemoteInterpreterManager.editRemoteInterpreter(project, interpreter.getRemoteUrl())) != null) {
            return new NodeJsRemoteInterpreter(createdId);
        }
        return null;
    }

    @Override
    @NotNull
    public NodeJsInterpreterEditor<NodeJsRemoteInterpreter> getEditor(@NotNull Project project) {
        if (project == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(9);
        }
        MyEditor myEditor = new MyEditor();
        if (myEditor == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(10);
        }
        return myEditor;
    }

    @Override
    public void setInterpreters(@NotNull List<NodeJsRemoteInterpreter> interpreters) {
        if (interpreters == null) {
            NodeJsRemoteInterpreterType.$$$reportNull$$$0(11);
        }
        if (this.myRemoteInterpreterManager != null) {
            HashSet toDelete = ContainerUtil.newHashSet(this.myRemoteInterpreterManager.getRemoteInterpreters());
            for (NodeJsRemoteInterpreter interpreter : interpreters) {
                toDelete.remove(interpreter.getRemoteUrl());
            }
            for (String url : toDelete) {
                this.myRemoteInterpreterManager.deleteRemoteInterpreter(url);
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "referenceName";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreter";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getInterpreters";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isRemoteReference";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findByReferenceName";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showAddDialog";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "edit";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getEditor";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setInterpreters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyEditor
    implements NodeJsInterpreterEditor<NodeJsRemoteInterpreter> {
        private final JPanel myPanel;
        private NodeJsRemoteInterpreter myCurrent;

        public MyEditor() {
            final Ref emptyTextRef = Ref.create();
            this.myPanel = new JPanel(new BorderLayout()){

                @Override
                protected void paintComponent(Graphics g) {
                    super.paintComponent(g);
                    ((StatusText)emptyTextRef.get()).paint((Component)this, g);
                }
            };
            StatusText emptyText = new StatusText(this.myPanel){

                protected boolean isStatusVisible() {
                    return true;
                }
            };
            emptyText.setText(MyEditor.getEmptyText());
            emptyTextRef.set((Object)emptyText);
            this.myPanel.setBorder(DialogWrapper.ourDefaultBorder);
        }

        @NotNull
        private static String getEmptyText() {
            Shortcut shortcut;
            ShortcutSet shortcutSet = CommonActionsPanel.getCommonShortcut((CommonActionsPanel.Buttons)CommonActionsPanel.Buttons.EDIT);
            if (shortcutSet != null && (shortcut = (Shortcut)ArrayUtil.getFirstElement((Object[])shortcutSet.getShortcuts())) != null) {
                String string = "Edit the selected remote interpreter with " + KeymapUtil.getShortcutText((Shortcut)shortcut);
                if (string == null) {
                    MyEditor.$$$reportNull$$$0(0);
                }
                return string;
            }
            if ("Edit the remote interpreter with double click" == null) {
                MyEditor.$$$reportNull$$$0(1);
            }
            return "Edit the remote interpreter with double click";
        }

        @Override
        public void resetEditor(@NotNull NodeJsRemoteInterpreter interpreter) {
            if (interpreter == null) {
                MyEditor.$$$reportNull$$$0(2);
            }
            this.myCurrent = interpreter;
        }

        @Override
        @NotNull
        public NodeJsRemoteInterpreter applyEditor() {
            NodeJsRemoteInterpreter nodeJsRemoteInterpreter = this.myCurrent;
            if (nodeJsRemoteInterpreter == null) {
                MyEditor.$$$reportNull$$$0(3);
            }
            return nodeJsRemoteInterpreter;
        }

        @Override
        @NotNull
        public Component getEditorComponent() {
            JPanel jPanel = this.myPanel;
            if (jPanel == null) {
                MyEditor.$$$reportNull$$$0(4);
            }
            return jPanel;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 2: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 2: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType$MyEditor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "interpreter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEmptyText";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/remote/NodeJsRemoteInterpreterType$MyEditor";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "applyEditor";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getEditorComponent";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "resetEditor";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

