/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.nodejs.interpreter;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterRef;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterType;
import com.intellij.javascript.nodejs.interpreter.local.NodeJsLocalInterpreterType;
import com.intellij.javascript.nodejs.interpreter.remote.NodeJsRemoteInterpreterType;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class NodeJsInterpreterRefList {
    private final List<NodeJsInterpreterRef> myAliasRefs;
    private final List<NodeJsInterpreterRef> myConstantRefs;

    private NodeJsInterpreterRefList(@NotNull List<NodeJsInterpreterRef> interpreterRefs, @NotNull List<NodeJsInterpreter> interpreters) {
        if (interpreterRefs == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(0);
        }
        if (interpreters == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(1);
        }
        this.myAliasRefs = new ArrayList<NodeJsInterpreterRef>(interpreterRefs);
        this.myConstantRefs = new ArrayList<NodeJsInterpreterRef>(ContainerUtil.map(interpreters, NodeJsInterpreter::toRef));
    }

    List<NodeJsInterpreterRef> getAllAvailableAsRefs(boolean withProjectRef) {
        ArrayList interpreterRefs = ContainerUtil.newArrayList();
        if (withProjectRef) {
            interpreterRefs.add(NodeJsInterpreterRef.createProjectRef());
        }
        interpreterRefs.addAll(this.myAliasRefs);
        interpreterRefs.addAll(this.myConstantRefs);
        return interpreterRefs;
    }

    public void addIfMissing(@NotNull NodeJsInterpreterRef interpreterRef) {
        if (interpreterRef == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(2);
        }
        if (interpreterRef.isProjectRef()) {
            return;
        }
        if (interpreterRef.isConstantRef()) {
            if (!this.myConstantRefs.contains(interpreterRef)) {
                this.myConstantRefs.add(0, interpreterRef);
            }
        } else if (!this.myAliasRefs.contains(interpreterRef)) {
            this.myAliasRefs.add(interpreterRef);
        }
    }

    @NotNull
    static NodeJsInterpreterRefList create(boolean withRemote) {
        NodeJsInterpreterRefList nodeJsInterpreterRefList = NodeJsInterpreterRefList.create(NodeJsInterpreterRefList.getTypes(withRemote));
        if (nodeJsInterpreterRefList == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(3);
        }
        return nodeJsInterpreterRefList;
    }

    @NotNull
    static NodeJsInterpreterRefList create(@NotNull List<NodeJsInterpreterType> types) {
        if (types == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(4);
        }
        ArrayList interpreterRefs = ContainerUtil.newArrayList();
        ArrayList interpreters = ContainerUtil.newArrayList();
        for (NodeJsInterpreterType type : types) {
            interpreterRefs.addAll(type.getInterpreterRefs());
            interpreters.addAll(type.getInterpreters());
        }
        NodeJsInterpreterRefList nodeJsInterpreterRefList = new NodeJsInterpreterRefList(interpreterRefs, interpreters);
        if (nodeJsInterpreterRefList == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(5);
        }
        return nodeJsInterpreterRefList;
    }

    @NotNull
    static List<NodeJsInterpreterType> getTypes(boolean enableRemote) {
        ArrayList enabledTypes = ContainerUtil.newArrayList();
        if (enableRemote) {
            enabledTypes.add(NodeJsRemoteInterpreterType.getInstance());
        }
        enabledTypes.add(NodeJsLocalInterpreterType.getInstance());
        ArrayList arrayList = enabledTypes;
        if (arrayList == null) {
            NodeJsInterpreterRefList.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRefs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreters";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interpreterRef";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRefList";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "types";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/nodejs/interpreter/NodeJsInterpreterRefList";
                break;
            }
            case 3: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addIfMissing";
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

