/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.MutableLookupElement;
import com.intellij.javascript.JSFunctionWithSubstitutor;
import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.DialectOptionHolder;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.completion.JSLookupUtilImpl;
import com.intellij.lang.javascript.frameworks.amd.JSAmdPsiUtil;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSDestructuringParameter;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSNamespace;
import com.intellij.lang.javascript.psi.JSNewExpression;
import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSParameterItem;
import com.intellij.lang.javascript.psi.JSParameterTypeDecorator;
import com.intellij.lang.javascript.psi.JSRecordType;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.lang.javascript.psi.ecmal4.JSSuperExpression;
import com.intellij.lang.javascript.psi.impl.JSPsiImplUtils;
import com.intellij.lang.javascript.psi.resolve.JSResolveResult;
import com.intellij.lang.javascript.psi.resolve.JSResolveUtil;
import com.intellij.lang.javascript.psi.stubs.impl.JSImplicitFunctionImpl;
import com.intellij.lang.javascript.psi.types.JSCompositeFunctionPropertySignatureImpl;
import com.intellij.lang.javascript.psi.types.JSGenericTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSubstitutor;
import com.intellij.lang.javascript.psi.util.JSClassUtils;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoHandlerWithTabActionSupport;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.ParameterInfoUtils;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.lang.typescript.psi.TypeScriptPsiUtil;
import com.intellij.lang.typescript.resolve.TypeScriptGenericTypesEvaluator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorBase;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.search.searches.DefinitionsScopedSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JSParameterInfoHandler
implements ParameterInfoHandlerWithTabActionSupport<JSArgumentList, JSFunctionWithSubstitutor, JSExpression> {
    private static final Set<Class> ourArgumentListAllowedParentClassesSet = ContainerUtil.newHashSet((Object[])new Class[]{JSCallExpression.class});
    private static final Set<Class<?>> ourStopSearch = Collections.singleton(JSFunction.class);
    private static final int MAX_CANCELED_RETRY_COUNT = 5;

    public boolean couldShowInLookup() {
        return true;
    }

    @NotNull
    public Set<? extends Class> getArgListStopSearchClasses() {
        Set<Class<?>> set = ourStopSearch;
        if (set == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(0);
        }
        return set;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        if (!(item instanceof MutableLookupElement)) {
            return null;
        }
        Object o = item.getObject();
        if (o instanceof JSFunctionItem) {
            LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
            HashSet untypedKeysForTypedSignatures = ContainerUtil.newHashSet();
            if (o instanceof JSFunction) {
                for (PsiElement el : DefinitionsScopedSearch.search((PsiElement)((JSFunction)o))) {
                    if (!(el instanceof JSFunction)) continue;
                    JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, (JSFunctionItem)((JSFunction)el), null);
                }
            }
            ArrayList<JSFunctionWithSubstitutor> result = new ArrayList<JSFunctionWithSubstitutor>(typedSignatures.size() + 1);
            result.add(new JSFunctionWithSubstitutor((JSFunctionItem)o, null));
            ContainerUtil.addAll(result, typedSignatures.values());
            return ArrayUtil.toObjectArray(result);
        }
        return ArrayUtil.EMPTY_OBJECT_ARRAY;
    }

    private static void doAddSignature(@NotNull Map<String, JSFunctionWithSubstitutor> typedSignatures, @NotNull Map<String, JSFunctionWithSubstitutor> untypedSignatures, @NotNull Set<String> untypedKeysForTypedSignatures, @NotNull JSFunctionItem functionItem, @Nullable JSTypeSubstitutor typeSubstitutor) {
        String untypedSignature;
        String typedSignature;
        if (typedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (untypedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if (untypedKeysForTypedSignatures == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(3);
        }
        if (functionItem == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if ((typedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)false, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text).equals(untypedSignature = JSParameterInfoHandler.buildSignature((JSFunctionItem)functionItem, (boolean)true, (int)-1, (JSTypeSubstitutor)typeSubstitutor).text)) {
            if (!untypedSignatures.containsKey(untypedSignature)) {
                untypedSignatures.put(untypedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            }
        } else if (!typedSignatures.containsKey(typedSignature)) {
            typedSignatures.put(typedSignature, new JSFunctionWithSubstitutor(functionItem, typeSubstitutor));
            untypedKeysForTypedSignatures.add(untypedSignature);
        }
    }

    public Object[] getParametersForDocumentation(JSFunctionWithSubstitutor p, ParameterInfoContext context) {
        return p.myFunctionItem.getParameters();
    }

    public JSArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        JSArgumentList argList;
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(5);
        }
        if ((argList = JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset())) == null) {
            return null;
        }
        if (this.skipTypeScript() && DialectDetector.isTypeScript((PsiElement)argList)) {
            return null;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            Stream<JSFunctionWithSubstitutor> resultStream = this.fillSignaturesForArgumentList(context, argList);
            if (resultStream != null) {
                context.setItemsToShow(resultStream.toArray());
                return argList;
            }
            context.setItemsToShow(null);
            return null;
        }
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            if (context == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(44);
            }
            int canceledCount = 0;
            while (canceledCount < 5) {
                boolean isInvalid = (Boolean)ReadAction.compute(() -> {
                    if (context == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(45);
                    }
                    if (!argList.isValid() || JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset()) != argList) {
                        return true;
                    }
                    Editor editor = context.getEditor();
                    return context.getProject().isDisposed() || editor.isDisposed();
                });
                if (isInvalid) {
                    return;
                }
                ProgressIndicatorBase indicator = new ProgressIndicatorBase();
                boolean success = this.runInReadActionWithWritePriority(context, argList, (ProgressIndicator)indicator);
                if (success) {
                    return;
                }
                if (!indicator.isCanceled()) continue;
                ++canceledCount;
            }
        });
        return null;
    }

    private boolean runInReadActionWithWritePriority(@NotNull CreateParameterInfoContext context, @NotNull JSArgumentList argList, @NotNull ProgressIndicator indicator) {
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (argList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(7);
        }
        if (indicator == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(8);
        }
        return ProgressManager.getInstance().runInReadActionWithWriteActionPriority(() -> {
            Stream<JSFunctionWithSubstitutor> resultStream;
            if (context == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(40);
            }
            if (argList == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(41);
            }
            if ((resultStream = this.fillSignaturesForArgumentList(context, argList)) != null) {
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (context == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(42);
                    }
                    if (argList == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(43);
                    }
                    context.setItemsToShow(resultStream.toArray());
                    this.showParameterInfo(argList, context);
                });
            }
        }, indicator);
    }

    @Nullable
    public static JSArgumentList findArgumentList(PsiFile file, int offset) {
        JSCallExpression callExpression;
        JSArgumentList argList = (JSArgumentList)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, JSArgumentList.class, (Class[])new Class[]{JSStatement.class, JSFunctionExpression.class});
        if (argList == null && (callExpression = (JSCallExpression)ParameterInfoUtils.findParentOfTypeWithStopElements((PsiFile)file, (int)offset, JSCallExpression.class, (Class[])new Class[]{JSStatement.class})) != null) {
            argList = callExpression.getArgumentList();
        }
        return argList;
    }

    @Nullable
    protected Stream<JSFunctionWithSubstitutor> fillSignaturesForArgumentList(CreateParameterInfoContext context, @NotNull JSArgumentList argList) {
        if (argList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(9);
        }
        ApplicationManager.getApplication().assertReadAccessAllowed();
        PsiElement psiElement = argList.getParent();
        if (!(psiElement instanceof JSCallExpression)) {
            return null;
        }
        JSCallExpression parent = (JSCallExpression)psiElement;
        JSExpression methodExpression = JSUtils.unparenthesize(parent.getMethodExpression());
        if (methodExpression instanceof JSReferenceExpression || methodExpression instanceof JSIndexedPropertyAccessExpression) {
            return this.fillSignaturesForReferenceOrIndexAccessExpression(parent, methodExpression);
        }
        if (methodExpression instanceof JSSuperExpression) {
            PsiElement clazz = methodExpression.getReference().resolve();
            if (clazz instanceof JSFunction) {
                if (clazz instanceof TypeScriptFunction) {
                    Collection<? extends JSFunctionItem> overloadDeclarations = TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)clazz);
                    return overloadDeclarations.stream().map(c -> new JSFunctionWithSubstitutor((JSFunctionItem)c, null));
                }
                return Stream.of(new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunction)clazz), null));
            }
        } else if (methodExpression instanceof JSFunctionExpression) {
            return Stream.of(new JSFunctionWithSubstitutor((JSFunctionItem)((JSFunctionExpression)methodExpression), null));
        }
        return null;
    }

    private static Collection<PsiElement> getResolvedPsiElements(JSExpression methodExpression) {
        if (methodExpression instanceof JSReferenceExpression) {
            ResolveResult[] resolveResults = ((JSReferenceExpression)methodExpression).multiResolve(true);
            if (resolveResults.length <= 0) {
                return Collections.emptyList();
            }
            return JSResolveResult.toElements(resolveResults, false);
        }
        if (methodExpression instanceof JSIndexedPropertyAccessExpression) {
            Object value;
            ArrayList elements = ContainerUtil.newArrayList();
            JSExpression indexExpression = ((JSIndexedPropertyAccessExpression)methodExpression).getIndexExpression();
            String propertyName = null;
            if (indexExpression instanceof JSLiteralExpression && (value = ((JSLiteralExpression)indexExpression).getValue()) instanceof String) {
                propertyName = (String)value;
            }
            if (JSPsiImplUtils.isSymbolRef(indexExpression)) {
                propertyName = "[" + indexExpression.getText() + "]";
            }
            if (propertyName != null) {
                JSRecordType recordType;
                JSRecordType.PropertySignature propertySignature;
                JSType qualifierType = JSResolveUtil.getExpressionJSType(((JSIndexedPropertyAccessExpression)methodExpression).getQualifier());
                if ((qualifierType = JSTypeUtils.getValuableType(qualifierType)) != null && (propertySignature = (recordType = qualifierType.asRecordType()).findPropertySignature(propertyName)) != null) {
                    JSRecordType.MemberSource source = propertySignature.getMemberSource();
                    if (source.getMemberSourceKind() != JSRecordType.MemberSourceKind.Union) {
                        elements.addAll(source.getAllSourceElements());
                    } else if (propertySignature instanceof JSCompositeFunctionPropertySignatureImpl) {
                        for (JSRecordType.PropertySignature part : ((JSCompositeFunctionPropertySignatureImpl)propertySignature).getMembers()) {
                            source = part.getMemberSource();
                            if (source.getMemberSourceKind() == JSRecordType.MemberSourceKind.Union) continue;
                            elements.addAll(source.getAllSourceElements());
                        }
                    }
                }
            }
            return elements;
        }
        throw new UnsupportedOperationException("Expression " + methodExpression.getClass() + " is not supported");
    }

    private JSExpression getQualifier(@NotNull JSExpression methodExpression) {
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(10);
        }
        if (methodExpression instanceof JSReferenceExpression) {
            return ((JSReferenceExpression)methodExpression).getQualifier();
        }
        if (methodExpression instanceof JSIndexedPropertyAccessExpression) {
            return ((JSIndexedPropertyAccessExpression)methodExpression).getQualifier();
        }
        throw new UnsupportedOperationException("Expression " + methodExpression.getClass() + " is not supported");
    }

    @Nullable
    protected Stream<JSFunctionWithSubstitutor> fillSignaturesForReferenceOrIndexAccessExpression(@NotNull JSCallExpression parent, @NotNull JSExpression methodExpression) {
        Collection<PsiElement> elements;
        if (parent == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(11);
        }
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(12);
        }
        if ((elements = JSParameterInfoHandler.getResolvedPsiElements(methodExpression)).size() == 0) {
            return null;
        }
        elements = JSParameterInfoHandler.getElementsWithConstructors(parent, elements);
        LinkedHashMap<String, JSFunctionWithSubstitutor> typedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>(elements.size());
        LinkedHashMap<String, JSFunctionWithSubstitutor> untypedSignatures = new LinkedHashMap<String, JSFunctionWithSubstitutor>();
        HashSet untypedKeysForTypedSignatures = ContainerUtil.newHashSet();
        JSExpression qualifier = this.getQualifier(methodExpression);
        ArrayList<JSFunctionItem> items = JSParameterInfoHandler.getFunctionItems(parent, methodExpression, elements);
        JSTypeSubstitutor typeSubstitutor = JSParameterInfoHandler.getTypeSubstitutor(methodExpression, qualifier, items);
        for (JSFunctionItem functionItem : items) {
            JSParameterInfoHandler.doAddSignature(typedSignatures, untypedSignatures, untypedKeysForTypedSignatures, functionItem, typeSubstitutor);
        }
        Stream typedStream = typedSignatures.values().stream();
        Stream.Builder untypedStreamBuilder = Stream.builder();
        for (Map.Entry entry : untypedSignatures.entrySet()) {
            if (untypedKeysForTypedSignatures.contains(entry.getKey())) continue;
            untypedStreamBuilder.add(entry.getValue());
        }
        return Stream.concat(typedStream, untypedStreamBuilder.build());
    }

    @NotNull
    private static ArrayList<JSFunctionItem> getFunctionItems(@NotNull JSCallExpression parent, @NotNull JSExpression methodExpression, @NotNull Collection<PsiElement> elements) {
        if (parent == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(13);
        }
        if (methodExpression == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(14);
        }
        if (elements == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(15);
        }
        ArrayList items = ContainerUtil.newArrayList();
        for (PsiElement element : elements) {
            Collection<? extends JSFunctionItem> functionItems = JSParameterInfoHandler.getFunctionItems(parent, methodExpression, element);
            if (functionItems.size() == 0) continue;
            items.addAll(functionItems);
        }
        ArrayList arrayList = items;
        if (arrayList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(16);
        }
        return arrayList;
    }

    @Nullable
    private static JSTypeSubstitutor getTypeSubstitutor(JSExpression methodExpression, @Nullable JSExpression qualifier, @NotNull List<JSFunctionItem> items) {
        JSNamespace namespace;
        JSType qualifierType;
        JSFunctionItem firstFunction;
        if (items == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(17);
        }
        if ((firstFunction = (JSFunctionItem)ContainerUtil.getFirstItem(items)) instanceof TypeScriptFunction) {
            return TypeScriptGenericTypesEvaluator.getInstance().getTypeSubstitutorForMember((JSElement)ContainerUtil.getFirstItem(items), (PsiElement)methodExpression);
        }
        if (qualifier != null && (qualifierType = JSResolveUtil.getExpressionJSType(qualifier)) != null && (namespace = JSTypeUtils.getNamespaceMatchingType(qualifierType, true, false)) != null) {
            return (JSTypeSubstitutor)namespace.getUserData(JSNamespace.GENERIC_ARGUMENTS_KEY);
        }
        return null;
    }

    private static Collection<PsiElement> getElementsWithConstructors(JSCallExpression parent, Collection<PsiElement> elements) {
        if (parent instanceof JSNewExpression) {
            ArrayList newElements = ContainerUtil.newArrayListWithCapacity((int)elements.size());
            for (PsiElement element : elements) {
                if (element instanceof JSClass) {
                    ResolveResult[] constructorResults;
                    JSClass jsClass = (JSClass)element;
                    for (ResolveResult result : constructorResults = JSClassUtils.resolveES6Constructor(jsClass, parent.getMethodExpression())) {
                        PsiElement resultConstructor = result.getElement();
                        if (resultConstructor == null) continue;
                        newElements.add(resultConstructor);
                    }
                    continue;
                }
                newElements.add(element);
            }
            elements = newElements;
        }
        return elements;
    }

    @NotNull
    private static Collection<? extends JSFunctionItem> getFunctionItems(JSCallExpression parent, JSExpression methodExpression, PsiElement element) {
        JSFunctionItem functionItem = JSParameterInfoHandler.calculatePossibleFunctionCarefully(element, (PsiElement)methodExpression);
        if (functionItem == null) {
            JSType jsType = JSTypeUtils.getTypeOfElement(element);
            if ((jsType = JSTypeUtils.getValuableType(jsType)) != null) {
                List result;
                Collection functionTypes = JSTypeUtils.getFunctionType(jsType, parent instanceof JSNewExpression).collect(Collectors.toList());
                if (functionTypes.isEmpty()) {
                    List list = ContainerUtil.emptyList();
                    if (list == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(18);
                    }
                    return list;
                }
                DialectOptionHolder holder = DialectDetector.dialectOfElement(element);
                List list = result = holder != null && holder.isECMA4 ? ContainerUtil.emptyList() : JSParameterInfoHandler.getFunctionItemsForTypes(functionTypes);
                if (result.size() > 0) {
                    List list2 = result;
                    if (list2 == null) {
                        JSParameterInfoHandler.$$$reportNull$$$0(19);
                    }
                    return list2;
                }
                PsiElement sourceElement = jsType.getSource().getSourceElement();
                if (sourceElement instanceof JSFunctionItem) {
                    functionItem = (JSFunctionItem)sourceElement;
                }
            }
        }
        if (functionItem instanceof TypeScriptFunction) {
            Collection<? extends JSFunctionItem> collection = TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)functionItem);
            if (collection == null) {
                JSParameterInfoHandler.$$$reportNull$$$0(20);
            }
            return collection;
        }
        List list = ContainerUtil.createMaybeSingletonList((Object)functionItem);
        if (list == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(21);
        }
        return list;
    }

    @NotNull
    private static Collection<JSFunctionItem> getFunctionItemsForTypes(@NotNull Collection<JSType> functionTypes) {
        if (functionTypes == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(22);
        }
        LinkedHashSet result = ContainerUtil.newLinkedHashSet();
        for (JSType functionType : functionTypes) {
            PsiElement functionSourceElement;
            if (functionType instanceof JSGenericTypeImpl) {
                functionType = ((JSGenericTypeImpl)functionType).getType();
            }
            if (!((functionSourceElement = functionType.getSource().getSourceElement()) instanceof JSFunctionItem)) continue;
            JSFunctionItem currentFunction = (JSFunctionItem)functionSourceElement;
            if (currentFunction instanceof TypeScriptFunction) {
                result.addAll(TypeScriptPsiUtil.getAllOverloadSignatures((TypeScriptFunction)currentFunction));
                continue;
            }
            result.add(currentFunction);
        }
        LinkedHashSet linkedHashSet = result;
        if (linkedHashSet == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(23);
        }
        return linkedHashSet;
    }

    public void showParameterInfo(@NotNull JSArgumentList element, @NotNull CreateParameterInfoContext context) {
        if (element == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(24);
        }
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(25);
        }
        context.showHint((PsiElement)element, element.getTextOffset(), (ParameterInfoHandler)this);
    }

    public JSArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(26);
        }
        return JSParameterInfoHandler.findArgumentList(context.getFile(), context.getOffset());
    }

    public void updateParameterInfo(@NotNull JSArgumentList parameterOwner, @NotNull UpdateParameterInfoContext context) {
        if (parameterOwner == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(27);
        }
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(28);
        }
        if (context.getParameterOwner() != parameterOwner) {
            context.removeHint();
            return;
        }
        int currentParameterIndex = ParameterInfoUtils.getCurrentParameterIndex((ASTNode)parameterOwner.getNode(), (int)context.getOffset(), (IElementType)JSTokenTypes.COMMA);
        context.setCurrentParameter(currentParameterIndex);
    }

    @NotNull
    public String getParameterCloseChars() {
        if (",){" == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(29);
        }
        return ",){";
    }

    public boolean tracksParameterIndex() {
        return true;
    }

    public void updateUI(JSFunctionWithSubstitutor pair, @NotNull ParameterInfoUIContext context) {
        JSFunctionItem p;
        if (context == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(30);
        }
        if (!((p = pair.myFunctionItem) instanceof JSImplicitFunctionImpl) && !p.isValid()) {
            return;
        }
        JSParameterItem[] params = p.getParameters();
        int currentParameterIndex = context.getCurrentParameterIndex() >= 0 ? context.getCurrentParameterIndex() : params.length;
        JSParameterItem parameter = currentParameterIndex < params.length ? params[currentParameterIndex] : null;
        SignatureInfo signatureInfo = JSParameterInfoHandler.buildSignature(p, false, currentParameterIndex, pair.myTypeSubstitutor);
        String name = signatureInfo.text;
        String currentParameterSignature = parameter != null ? JSParameterInfoHandler.getSignatureForParameter(parameter, pair.myTypeSubstitutor) : null;
        int highlightStart = parameter != null ? signatureInfo.selectedParameterStart : 0;
        int highlightEnd = parameter != null ? highlightStart + currentParameterSignature.length() : 0;
        context.setupUIComponentPresentation(name, highlightStart, highlightEnd, false, false, false, context.getDefaultParameterColor());
    }

    @Nullable
    public static JSFunctionItem calculatePossibleFunctionCarefully(@NotNull PsiElement resolveResult, @Nullable PsiElement methodExpression) {
        PsiElement module;
        if (resolveResult == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(31);
        }
        if (resolveResult instanceof JSParameter && (module = JSAmdPsiUtil.findReferencedModule((JSParameter)resolveResult)) != null) {
            resolveResult = module;
        }
        return JSPsiImplUtils.calculatePossibleFunction(resolveResult, methodExpression);
    }

    @NotNull
    private static SignatureInfo buildSignature(@NotNull JSFunctionItem function, boolean skipType, int selectedParameterIndex, @Nullable JSTypeSubstitutor typeSubstitutor) {
        if (function == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(32);
        }
        JSParameterItem[] params = function.getParameters();
        SignatureInfo info = new SignatureInfo();
        if (params.length > 0) {
            StringBuilder result = new StringBuilder();
            for (int i = 0; i < params.length; ++i) {
                if (result.length() > 0) {
                    result.append(", ");
                }
                if (selectedParameterIndex == i) {
                    info.selectedParameterStart = result.toString().length();
                }
                result.append(JSParameterInfoHandler.getSignatureForParameter(params[i], skipType, typeSubstitutor));
            }
            if (function.isReferencesArguments()) {
                result.append(", ...");
            }
            info.text = result.toString();
        } else {
            String signature = function.isReferencesArguments() ? "..." : CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]);
            info.text = signature;
        }
        SignatureInfo signatureInfo = info;
        if (signatureInfo == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(33);
        }
        return signatureInfo;
    }

    private static String getSignatureForParameter(JSParameterItem p, boolean skipType, @Nullable JSTypeSubstitutor typeSubstitutor) {
        JSParameterTypeDecorator decorator = p.getTypeDecorator();
        JSType type = p.getTypeIncludingOverridden();
        if (type != null) {
            type = JSTypeUtils.applyGenericArguments(type, (Map<String, JSType>)typeSubstitutor);
        }
        String initializerText = p instanceof JSParameter ? ((JSParameter)p).getLiteralOrReferenceInitializerText() : null;
        DialectOptionHolder holder = p instanceof PsiElement ? DialectDetector.dialectOfElement((PsiElement)p) : null;
        if (!(skipType |= p instanceof JSDestructuringParameter && ((JSDestructuringParameter)p).getTypeElement() == null) && type != null) {
            boolean needOptional;
            String s = type.getTypeText(JSType.TypeTextFormat.PRESENTABLE);
            boolean isActionScript = holder != null && holder.isECMA4;
            boolean isTypeScript = holder != null && holder.isTypeScript;
            boolean useColonTypeNotation = isTypeScript || isActionScript || holder != null && holder.isFlow;
            StringBuilder result = new StringBuilder();
            boolean bl = needOptional = p.isOptional() && initializerText == null;
            if (useColonTypeNotation) {
                if (p.isRest()) {
                    result.append("... ");
                    result.append(p.getName());
                } else {
                    result.append(p.getName());
                    if (needOptional) {
                        result.append('?');
                    }
                }
                result.append(":");
                if (isTypeScript) {
                    result.append(" ");
                }
                result.append(JSLookupUtilImpl.getShortName(s));
            } else {
                result.append("[");
                if (decorator.isRest()) {
                    result.append("...");
                }
                result.append(s);
                if (needOptional) {
                    result.append(", optional");
                }
                result.append("] ").append(p.getName());
            }
            if (initializerText != null) {
                result.append(" = ");
                result.append(initializerText);
            }
            return result.toString();
        }
        String res = p.getName();
        if (p.isRest()) {
            res = "... " + res;
        }
        if (p.isOptional() && decorator.isExplicitlyDeclared()) {
            res = "[optional] " + res;
        }
        if (initializerText != null) {
            res = res + " = " + initializerText;
        }
        return res;
    }

    public static String getSignatureForParameter(JSParameterItem p) {
        return JSParameterInfoHandler.getSignatureForParameter(p, null);
    }

    public static String getSignatureForParameter(JSParameterItem p, @Nullable JSTypeSubstitutor typeSubstitutor) {
        return JSParameterInfoHandler.getSignatureForParameter(p, false, typeSubstitutor);
    }

    @NotNull
    public JSExpression[] getActualParameters(@NotNull JSArgumentList jsArgumentList) {
        if (jsArgumentList == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(34);
        }
        JSExpression[] jSExpressionArray = jsArgumentList.getArguments();
        if (jSExpressionArray == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(35);
        }
        return jSExpressionArray;
    }

    @NotNull
    public IElementType getActualParameterDelimiterType() {
        IElementType iElementType = JSTokenTypes.COMMA;
        if (iElementType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(36);
        }
        return iElementType;
    }

    @NotNull
    public IElementType getActualParametersRBraceType() {
        IElementType iElementType = JSTokenTypes.RBRACE;
        if (iElementType == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(37);
        }
        return iElementType;
    }

    @NotNull
    public Set<Class> getArgumentListAllowedParentClasses() {
        Set<Class> set = ourArgumentListAllowedParentClassesSet;
        if (set == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(38);
        }
        return set;
    }

    @NotNull
    public Class<JSArgumentList> getArgumentListClass() {
        if (JSArgumentList.class == null) {
            JSParameterInfoHandler.$$$reportNull$$$0(39);
        }
        return JSArgumentList.class;
    }

    protected boolean skipTypeScript() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javascript/JSParameterInfoHandler";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typedSignatures";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untypedSignatures";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "untypedKeysForTypedSignatures";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionItem";
                break;
            }
            case 5: 
            case 6: 
            case 25: 
            case 26: 
            case 28: 
            case 30: 
            case 40: 
            case 42: 
            case 44: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 7: 
            case 9: 
            case 41: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argList";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indicator";
                break;
            }
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "functionTypes";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parameterOwner";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jsArgumentList";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgListStopSearchClasses";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javascript/JSParameterInfoHandler";
                break;
            }
            case 16: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionItems";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getFunctionItemsForTypes";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "getParameterCloseChars";
                break;
            }
            case 33: {
                objectArray = objectArray2;
                objectArray2[1] = "buildSignature";
                break;
            }
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameters";
                break;
            }
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParameterDelimiterType";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getActualParametersRBraceType";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListAllowedParentClasses";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "getArgumentListClass";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doAddSignature";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findElementForParameterInfo";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "runInReadActionWithWritePriority";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "fillSignaturesForArgumentList";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getQualifier";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "fillSignaturesForReferenceOrIndexAccessExpression";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionItems";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getTypeSubstitutor";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionItemsForTypes";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "showParameterInfo";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "updateParameterInfo";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "updateUI";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "calculatePossibleFunctionCarefully";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "buildSignature";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "getActualParameters";
                break;
            }
            case 40: 
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "lambda$runInReadActionWithWritePriority$3";
                break;
            }
            case 42: 
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$2";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "lambda$findElementForParameterInfo$1";
                break;
            }
            case 45: {
                objectArray = objectArray;
                objectArray[2] = "lambda$null$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 17: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 30: 
            case 31: 
            case 32: 
            case 34: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SignatureInfo {
        String text;
        int selectedParameterStart = -1;

        private SignatureInfo() {
        }
    }
}

