/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dupLocator;

import com.intellij.dupLocator.DuplocateVisitor;
import com.intellij.dupLocator.DuplocatorSettings;
import com.intellij.dupLocator.DuplocatorState;
import com.intellij.dupLocator.PsiElementRole;
import com.intellij.dupLocator.treeHash.DuplicatesProfileBase;
import com.intellij.dupLocator.treeHash.FragmentsCollector;
import com.intellij.dupLocator.treeHash.NodeSpecificHasherBase;
import com.intellij.dupLocator.util.PsiFragment;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.JSExtendedLanguagesTokenSetProvider;
import com.intellij.lang.javascript.JSMinifiedFileUtil;
import com.intellij.lang.javascript.JSTokenTypes;
import com.intellij.lang.javascript.JavaScriptSupportLoader;
import com.intellij.lang.javascript.JavascriptLanguage;
import com.intellij.lang.javascript.psi.JSAssignmentExpression;
import com.intellij.lang.javascript.psi.JSBlockStatement;
import com.intellij.lang.javascript.psi.JSBreakStatement;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSContinueStatement;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSLabeledStatement;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSReturnStatement;
import com.intellij.lang.javascript.psi.JSStatement;
import com.intellij.lang.javascript.psi.JSVarStatement;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.ecmal4.JSClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.tree.LeafPsiElement;
import com.intellij.psi.tree.TokenSet;
import com.intellij.util.Producer;
import com.intellij.util.indexing.FileContent;
import org.jetbrains.annotations.NotNull;

public class JSDuplicatesProfile
extends DuplicatesProfileBase {
    public boolean isMyLanguage(@NotNull Language language) {
        if (language == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(0);
        }
        return language.isKindOf((Language)JavascriptLanguage.INSTANCE);
    }

    public PsiElementRole getRole(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(1);
        }
        if ((parent = element.getParent()) instanceof JSVariable && ((JSVariable)parent).getNameIdentifier() == element) {
            return PsiElementRole.VARIABLE_NAME;
        }
        if (parent instanceof JSFunction && ((JSFunction)parent).getNameIdentifier() == element) {
            return PsiElementRole.FUNCTION_NAME;
        }
        return null;
    }

    @NotNull
    public DuplocateVisitor createVisitor(@NotNull FragmentsCollector collector, boolean forIndexing) {
        if (collector == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(2);
        }
        NodeSpecificHasherBase nodeSpecificHasherBase = new NodeSpecificHasherBase(DuplocatorSettings.getInstance(), collector, this, forIndexing){

            public int getNodeHash(PsiElement node) {
                if (this.myForIndexing) {
                    if (node instanceof LeafPsiElement) {
                        return 0;
                    }
                    if (node instanceof JSReferenceExpression) {
                        String name;
                        PsiElement parent = node.getParent();
                        if (parent instanceof JSCallExpression && ((JSCallExpression)parent).getMethodExpression() == node) {
                            String name2 = ((JSReferenceExpression)node).getReferencedName();
                            if (name2 != null) {
                                return name2.hashCode();
                            }
                        } else if (((JSReferenceExpression)node).getQualifier() instanceof JSReferenceExpression && (name = ((JSReferenceExpression)node).getReferencedName()) != null) {
                            return name.hashCode();
                        }
                        return 0;
                    }
                    if (node instanceof JSVariable) {
                        return 0;
                    }
                }
                return super.getNodeHash(node);
            }
        };
        if (nodeSpecificHasherBase == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(3);
        }
        return nodeSpecificHasherBase;
    }

    @NotNull
    public Language getLanguage(@NotNull PsiElement element) {
        if (element == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(4);
        }
        Language language = JSDuplicatesProfile.getLanguageForElement(element);
        if (language == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(5);
        }
        return language;
    }

    public int getNodeCost(@NotNull PsiElement element) {
        if (element == null) {
            JSDuplicatesProfile.$$$reportNull$$$0(6);
        }
        if (element instanceof JSStatement || element instanceof JSFunction || element instanceof JSClass) {
            return 2;
        }
        if (element instanceof JSExpression) {
            return 1;
        }
        return 0;
    }

    public boolean shouldPutInIndex(PsiFragment fragment, int cost, DuplocatorState state) {
        PsiElement[] elements = fragment.getElements();
        if (elements.length == 0) {
            return false;
        }
        return JSDuplicatesProfile.isAcceptableElement(elements[0]);
    }

    private static boolean isAcceptableElement(PsiElement element) {
        if (element instanceof JSStatement) {
            if (element instanceof JSBlockStatement) {
                ASTNode node = element.getNode();
                ASTNode firstStatement = node.findChildByType(JSExtendedLanguagesTokenSetProvider.STATEMENTS);
                if (firstStatement == null) {
                    return false;
                }
                for (ASTNode last = node.getLastChildNode(); last != null; last = last.getTreePrev()) {
                    if (!JSExtendedLanguagesTokenSetProvider.STATEMENTS.contains(last.getElementType())) continue;
                    if (last != firstStatement) break;
                    return JSDuplicatesProfile.isAcceptableElement(last.getPsi());
                }
                if (element.getParent() instanceof JSFunction) {
                    return false;
                }
            }
            if (!(element instanceof JSExpressionStatement || element instanceof JSLabeledStatement || element instanceof JSContinueStatement || element instanceof JSBreakStatement || element instanceof JSVarStatement || element instanceof JSReturnStatement)) {
                return true;
            }
        }
        if (element instanceof JSExpression && element.getParent() instanceof JSExpressionStatement && !(element instanceof JSAssignmentExpression)) {
            return true;
        }
        return element instanceof JSFunction;
    }

    public TokenSet getLiterals() {
        return JSTokenTypes.LITERALS;
    }

    public static Language getLanguageForElement(PsiElement element) {
        Language language = DialectDetector.languageOfElement(element);
        if (language != JavaScriptSupportLoader.ECMA_SCRIPT_L4) {
            return JavascriptLanguage.INSTANCE;
        }
        return language;
    }

    public boolean supportDuplicatesIndex() {
        return true;
    }

    public boolean acceptsContentForIndexing(FileContent fileContent) {
        return !JSMinifiedFileUtil.isFileContentMinified(fileContent.getFileName(), (Producer<CharSequence>)((Producer)() -> fileContent.getContentAsText()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "language";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collector";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/dupLocator/JSDuplicatesProfile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/dupLocator/JSDuplicatesProfile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createVisitor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getLanguage";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isMyLanguage";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getRole";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "createVisitor";
                break;
            }
            case 3: 
            case 5: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLanguage";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getNodeCost";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

