/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.transform;

import com.sun.javafx.geom.transform.Affine3D;
import com.sun.javafx.geom.transform.BaseTransform;
import javafx.geometry.Point2D;
import javafx.geometry.Point3D;
import javafx.scene.transform.Affine;
import javafx.scene.transform.NonInvertibleTransformException;
import javafx.scene.transform.Transform;

public class TransformUtils {
    public static Transform immutableTransform(double mxx, double mxy, double mxz, double tx, double myx, double myy, double myz, double ty, double mzx, double mzy, double mzz, double tz) {
        return new ImmutableTransform(mxx, mxy, mxz, tx, myx, myy, myz, ty, mzx, mzy, mzz, tz);
    }

    public static Transform immutableTransform(Transform t) {
        return new ImmutableTransform(t.getMxx(), t.getMxy(), t.getMxz(), t.getTx(), t.getMyx(), t.getMyy(), t.getMyz(), t.getTy(), t.getMzx(), t.getMzy(), t.getMzz(), t.getTz());
    }

    public static Transform immutableTransform(Transform reuse, double mxx, double mxy, double mxz, double tx, double myx, double myy, double myz, double ty, double mzx, double mzy, double mzz, double tz) {
        if (reuse == null) {
            return new ImmutableTransform(mxx, mxy, mxz, tx, myx, myy, myz, ty, mzx, mzy, mzz, tz);
        }
        ((ImmutableTransform)reuse).setToTransform(mxx, mxy, mxz, tx, myx, myy, myz, ty, mzx, mzy, mzz, tz);
        return reuse;
    }

    public static Transform immutableTransform(Transform reuse, Transform t) {
        return TransformUtils.immutableTransform((ImmutableTransform)reuse, t.getMxx(), t.getMxy(), t.getMxz(), t.getTx(), t.getMyx(), t.getMyy(), t.getMyz(), t.getTy(), t.getMzx(), t.getMzy(), t.getMzz(), t.getTz());
    }

    public static Transform immutableTransform(Transform reuse, Transform left, Transform right) {
        if (reuse == null) {
            reuse = new ImmutableTransform();
        }
        ((ImmutableTransform)reuse).setToConcatenation((ImmutableTransform)left, (ImmutableTransform)right);
        return reuse;
    }

    static class ImmutableTransform
    extends Transform {
        private static final int APPLY_IDENTITY = 0;
        private static final int APPLY_TRANSLATE = 1;
        private static final int APPLY_SCALE = 2;
        private static final int APPLY_SHEAR = 4;
        private static final int APPLY_NON_3D = 0;
        private static final int APPLY_3D_COMPLEX = 4;
        private transient int state2d;
        private transient int state3d;
        private double xx;
        private double xy;
        private double xz;
        private double yx;
        private double yy;
        private double yz;
        private double zx;
        private double zy;
        private double zz;
        private double xt;
        private double yt;
        private double zt;

        public ImmutableTransform() {
            this.zz = 1.0;
            this.yy = 1.0;
            this.xx = 1.0;
        }

        public ImmutableTransform(Transform transform) {
            this(transform.getMxx(), transform.getMxy(), transform.getMxz(), transform.getTx(), transform.getMyx(), transform.getMyy(), transform.getMyz(), transform.getTy(), transform.getMzx(), transform.getMzy(), transform.getMzz(), transform.getTz());
        }

        public ImmutableTransform(double mxx, double mxy, double mxz, double tx, double myx, double myy, double myz, double ty, double mzx, double mzy, double mzz, double tz) {
            this.xx = mxx;
            this.xy = mxy;
            this.xz = mxz;
            this.xt = tx;
            this.yx = myx;
            this.yy = myy;
            this.yz = myz;
            this.yt = ty;
            this.zx = mzx;
            this.zy = mzy;
            this.zz = mzz;
            this.zt = tz;
            this.updateState();
        }

        private void setToTransform(double mxx, double mxy, double mxz, double tx, double myx, double myy, double myz, double ty, double mzx, double mzy, double mzz, double tz) {
            this.xx = mxx;
            this.xy = mxy;
            this.xz = mxz;
            this.xt = tx;
            this.yx = myx;
            this.yy = myy;
            this.yz = myz;
            this.yt = ty;
            this.zx = mzx;
            this.zy = mzy;
            this.zz = mzz;
            this.zt = tz;
            this.updateState();
        }

        private void setToConcatenation(ImmutableTransform left, ImmutableTransform right) {
            if (left.state3d == 0 && right.state3d == 0) {
                this.xx = left.xx * right.xx + left.xy * right.yx;
                this.xy = left.xx * right.xy + left.xy * right.yy;
                this.xt = left.xx * right.xt + left.xy * right.yt + left.xt;
                this.yx = left.yx * right.xx + left.yy * right.yx;
                this.yy = left.yx * right.xy + left.yy * right.yy;
                this.yt = left.yx * right.xt + left.yy * right.yt + left.yt;
                if (this.state3d != 0) {
                    this.zt = 0.0;
                    this.zy = 0.0;
                    this.zx = 0.0;
                    this.yz = 0.0;
                    this.xz = 0.0;
                    this.zz = 1.0;
                    this.state3d = 0;
                }
                this.updateState2D();
            } else {
                this.xx = left.xx * right.xx + left.xy * right.yx + left.xz * right.zx;
                this.xy = left.xx * right.xy + left.xy * right.yy + left.xz * right.zy;
                this.xz = left.xx * right.xz + left.xy * right.yz + left.xz * right.zz;
                this.xt = left.xx * right.xt + left.xy * right.yt + left.xz * right.zt + left.xt;
                this.yx = left.yx * right.xx + left.yy * right.yx + left.yz * right.zx;
                this.yy = left.yx * right.xy + left.yy * right.yy + left.yz * right.zy;
                this.yz = left.yx * right.xz + left.yy * right.yz + left.yz * right.zz;
                this.yt = left.yx * right.xt + left.yy * right.yt + left.yz * right.zt + left.yt;
                this.zx = left.zx * right.xx + left.zy * right.yx + left.zz * right.zx;
                this.zy = left.zx * right.xy + left.zy * right.yy + left.zz * right.zy;
                this.zz = left.zx * right.xz + left.zy * right.yz + left.zz * right.zz;
                this.zt = left.zx * right.xt + left.zy * right.yt + left.zz * right.zt + left.zt;
                this.updateState();
            }
        }

        @Override
        public double getMxx() {
            return this.xx;
        }

        @Override
        public double getMxy() {
            return this.xy;
        }

        @Override
        public double getMxz() {
            return this.xz;
        }

        @Override
        public double getTx() {
            return this.xt;
        }

        @Override
        public double getMyx() {
            return this.yx;
        }

        @Override
        public double getMyy() {
            return this.yy;
        }

        @Override
        public double getMyz() {
            return this.yz;
        }

        @Override
        public double getTy() {
            return this.yt;
        }

        @Override
        public double getMzx() {
            return this.zx;
        }

        @Override
        public double getMzy() {
            return this.zy;
        }

        @Override
        public double getMzz() {
            return this.zz;
        }

        @Override
        public double getTz() {
            return this.zt;
        }

        @Override
        public double determinant() {
            switch (this.state3d) {
                default: {
                    ImmutableTransform.stateError();
                }
                case 0: {
                    switch (this.state2d) {
                        default: {
                            ImmutableTransform.stateError();
                        }
                        case 6: 
                        case 7: {
                            return this.xx * this.yy - this.xy * this.yx;
                        }
                        case 4: 
                        case 5: {
                            return -(this.xy * this.yx);
                        }
                        case 2: 
                        case 3: {
                            return this.xx * this.yy;
                        }
                        case 0: 
                        case 1: 
                    }
                    return 1.0;
                }
                case 1: {
                    return 1.0;
                }
                case 2: 
                case 3: {
                    return this.xx * this.yy * this.zz;
                }
                case 4: 
            }
            return this.xx * (this.yy * this.zz - this.zy * this.yz) + this.xy * (this.yz * this.zx - this.zz * this.yx) + this.xz * (this.yx * this.zy - this.zx * this.yy);
        }

        @Override
        public Transform createConcatenation(Transform transform) {
            Affine a = new Affine(this);
            a.append(transform);
            return a;
        }

        @Override
        public Affine createInverse() throws NonInvertibleTransformException {
            Affine t = new Affine(this);
            t.invert();
            return t;
        }

        @Override
        public Transform clone() {
            return new ImmutableTransform(this);
        }

        @Override
        public Point2D transform(double x, double y) {
            this.ensureCanTransform2DPoint();
            switch (this.state2d) {
                default: {
                    ImmutableTransform.stateError();
                }
                case 7: {
                    return new Point2D(this.xx * x + this.xy * y + this.xt, this.yx * x + this.yy * y + this.yt);
                }
                case 6: {
                    return new Point2D(this.xx * x + this.xy * y, this.yx * x + this.yy * y);
                }
                case 5: {
                    return new Point2D(this.xy * y + this.xt, this.yx * x + this.yt);
                }
                case 4: {
                    return new Point2D(this.xy * y, this.yx * x);
                }
                case 3: {
                    return new Point2D(this.xx * x + this.xt, this.yy * y + this.yt);
                }
                case 2: {
                    return new Point2D(this.xx * x, this.yy * y);
                }
                case 1: {
                    return new Point2D(x + this.xt, y + this.yt);
                }
                case 0: 
            }
            return new Point2D(x, y);
        }

        @Override
        public Point3D transform(double x, double y, double z) {
            switch (this.state3d) {
                default: {
                    ImmutableTransform.stateError();
                }
                case 0: {
                    switch (this.state2d) {
                        default: {
                            ImmutableTransform.stateError();
                        }
                        case 7: {
                            return new Point3D(this.xx * x + this.xy * y + this.xt, this.yx * x + this.yy * y + this.yt, z);
                        }
                        case 6: {
                            return new Point3D(this.xx * x + this.xy * y, this.yx * x + this.yy * y, z);
                        }
                        case 5: {
                            return new Point3D(this.xy * y + this.xt, this.yx * x + this.yt, z);
                        }
                        case 4: {
                            return new Point3D(this.xy * y, this.yx * x, z);
                        }
                        case 3: {
                            return new Point3D(this.xx * x + this.xt, this.yy * y + this.yt, z);
                        }
                        case 2: {
                            return new Point3D(this.xx * x, this.yy * y, z);
                        }
                        case 1: {
                            return new Point3D(x + this.xt, y + this.yt, z);
                        }
                        case 0: 
                    }
                    return new Point3D(x, y, z);
                }
                case 1: {
                    return new Point3D(x + this.xt, y + this.yt, z + this.zt);
                }
                case 2: {
                    return new Point3D(this.xx * x, this.yy * y, this.zz * z);
                }
                case 3: {
                    return new Point3D(this.xx * x + this.xt, this.yy * y + this.yt, this.zz * z + this.zt);
                }
                case 4: 
            }
            return new Point3D(this.xx * x + this.xy * y + this.xz * z + this.xt, this.yx * x + this.yy * y + this.yz * z + this.yt, this.zx * x + this.zy * y + this.zz * z + this.zt);
        }

        @Override
        public Point2D deltaTransform(double x, double y) {
            this.ensureCanTransform2DPoint();
            switch (this.state2d) {
                default: {
                    ImmutableTransform.stateError();
                }
                case 6: 
                case 7: {
                    return new Point2D(this.xx * x + this.xy * y, this.yx * x + this.yy * y);
                }
                case 4: 
                case 5: {
                    return new Point2D(this.xy * y, this.yx * x);
                }
                case 2: 
                case 3: {
                    return new Point2D(this.xx * x, this.yy * y);
                }
                case 0: 
                case 1: 
            }
            return new Point2D(x, y);
        }

        @Override
        public Point3D deltaTransform(double x, double y, double z) {
            switch (this.state3d) {
                default: {
                    ImmutableTransform.stateError();
                }
                case 0: {
                    switch (this.state2d) {
                        default: {
                            ImmutableTransform.stateError();
                        }
                        case 6: 
                        case 7: {
                            return new Point3D(this.xx * x + this.xy * y, this.yx * x + this.yy * y, z);
                        }
                        case 4: 
                        case 5: {
                            return new Point3D(this.xy * y, this.yx * x, z);
                        }
                        case 2: 
                        case 3: {
                            return new Point3D(this.xx * x, this.yy * y, z);
                        }
                        case 0: 
                        case 1: 
                    }
                    return new Point3D(x, y, z);
                }
                case 1: {
                    return new Point3D(x, y, z);
                }
                case 2: 
                case 3: {
                    return new Point3D(this.xx * x, this.yy * y, this.zz * z);
                }
                case 4: 
            }
            return new Point3D(this.xx * x + this.xy * y + this.xz * z, this.yx * x + this.yy * y + this.yz * z, this.zx * x + this.zy * y + this.zz * z);
        }

        @Override
        public Point2D inverseTransform(double x, double y) throws NonInvertibleTransformException {
            this.ensureCanTransform2DPoint();
            switch (this.state2d) {
                default: {
                    return super.inverseTransform(x, y);
                }
                case 5: {
                    if (this.xy == 0.0 || this.yx == 0.0) {
                        throw new NonInvertibleTransformException("Determinant is 0");
                    }
                    return new Point2D(1.0 / this.yx * y - this.yt / this.yx, 1.0 / this.xy * x - this.xt / this.xy);
                }
                case 4: {
                    if (this.xy == 0.0 || this.yx == 0.0) {
                        throw new NonInvertibleTransformException("Determinant is 0");
                    }
                    return new Point2D(1.0 / this.yx * y, 1.0 / this.xy * x);
                }
                case 3: {
                    if (this.xx == 0.0 || this.yy == 0.0) {
                        throw new NonInvertibleTransformException("Determinant is 0");
                    }
                    return new Point2D(1.0 / this.xx * x - this.xt / this.xx, 1.0 / this.yy * y - this.yt / this.yy);
                }
                case 2: {
                    if (this.xx == 0.0 || this.yy == 0.0) {
                        throw new NonInvertibleTransformException("Determinant is 0");
                    }
                    return new Point2D(1.0 / this.xx * x, 1.0 / this.yy * y);
                }
                case 1: {
                    return new Point2D(x - this.xt, y - this.yt);
                }
                case 0: 
            }
            return new Point2D(x, y);
        }

        @Override
        public Point3D inverseTransform(double x, double y, double z) throws NonInvertibleTransformException {
            switch (this.state3d) {
                default: {
                    ImmutableTransform.stateError();
                }
                case 0: {
                    switch (this.state2d) {
                        default: {
                            return super.inverseTransform(x, y, z);
                        }
                        case 5: {
                            if (this.xy == 0.0 || this.yx == 0.0) {
                                throw new NonInvertibleTransformException("Determinant is 0");
                            }
                            return new Point3D(1.0 / this.yx * y - this.yt / this.yx, 1.0 / this.xy * x - this.xt / this.xy, z);
                        }
                        case 4: {
                            if (this.xy == 0.0 || this.yx == 0.0) {
                                throw new NonInvertibleTransformException("Determinant is 0");
                            }
                            return new Point3D(1.0 / this.yx * y, 1.0 / this.xy * x, z);
                        }
                        case 3: {
                            if (this.xx == 0.0 || this.yy == 0.0) {
                                throw new NonInvertibleTransformException("Determinant is 0");
                            }
                            return new Point3D(1.0 / this.xx * x - this.xt / this.xx, 1.0 / this.yy * y - this.yt / this.yy, z);
                        }
                        case 2: {
                            if (this.xx == 0.0 || this.yy == 0.0) {
                                throw new NonInvertibleTransformException("Determinant is 0");
                            }
                            return new Point3D(1.0 / this.xx * x, 1.0 / this.yy * y, z);
                        }
                        case 1: {
                            return new Point3D(x - this.xt, y - this.yt, z);
                        }
                        case 0: 
                    }
                    return new Point3D(x, y, z);
                }
                case 1: {
                    return new Point3D(x - this.xt, y - this.yt, z - this.zt);
                }
                case 2: {
                    if (this.xx == 0.0 || this.yy == 0.0 || this.zz == 0.0) {
                        throw new NonInvertibleTransformException("Determinant is 0");
                    }
                    return new Point3D(1.0 / this.xx * x, 1.0 / this.yy * y, 1.0 / this.zz * z);
                }
                case 3: {
                    if (this.xx == 0.0 || this.yy == 0.0 || this.zz == 0.0) {
                        throw new NonInvertibleTransformException("Determinant is 0");
                    }
                    return new Point3D(1.0 / this.xx * x - this.xt / this.xx, 1.0 / this.yy * y - this.yt / this.yy, 1.0 / this.zz * z - this.zt / this.zz);
                }
                case 4: 
            }
            return super.inverseTransform(x, y, z);
        }

        @Override
        public Point2D inverseDeltaTransform(double x, double y) throws NonInvertibleTransformException {
            this.ensureCanTransform2DPoint();
            switch (this.state2d) {
                default: {
                    return super.inverseDeltaTransform(x, y);
                }
                case 4: 
                case 5: {
                    if (this.xy == 0.0 || this.yx == 0.0) {
                        throw new NonInvertibleTransformException("Determinant is 0");
                    }
                    return new Point2D(1.0 / this.yx * y, 1.0 / this.xy * x);
                }
                case 2: 
                case 3: {
                    if (this.xx == 0.0 || this.yy == 0.0) {
                        throw new NonInvertibleTransformException("Determinant is 0");
                    }
                    return new Point2D(1.0 / this.xx * x, 1.0 / this.yy * y);
                }
                case 0: 
                case 1: 
            }
            return new Point2D(x, y);
        }

        @Override
        public Point3D inverseDeltaTransform(double x, double y, double z) throws NonInvertibleTransformException {
            switch (this.state3d) {
                default: {
                    ImmutableTransform.stateError();
                }
                case 0: {
                    switch (this.state2d) {
                        default: {
                            return super.inverseDeltaTransform(x, y, z);
                        }
                        case 4: 
                        case 5: {
                            if (this.xy == 0.0 || this.yx == 0.0) {
                                throw new NonInvertibleTransformException("Determinant is 0");
                            }
                            return new Point3D(1.0 / this.yx * y, 1.0 / this.xy * x, z);
                        }
                        case 2: 
                        case 3: {
                            if (this.xx == 0.0 || this.yy == 0.0) {
                                throw new NonInvertibleTransformException("Determinant is 0");
                            }
                            return new Point3D(1.0 / this.xx * x, 1.0 / this.yy * y, z);
                        }
                        case 0: 
                        case 1: 
                    }
                    return new Point3D(x, y, z);
                }
                case 1: {
                    return new Point3D(x, y, z);
                }
                case 2: 
                case 3: {
                    if (this.xx == 0.0 || this.yy == 0.0 || this.zz == 0.0) {
                        throw new NonInvertibleTransformException("Determinant is 0");
                    }
                    return new Point3D(1.0 / this.xx * x, 1.0 / this.yy * y, 1.0 / this.zz * z);
                }
                case 4: 
            }
            return super.inverseDeltaTransform(x, y, z);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Transform [\n");
            sb.append("\t").append(this.xx);
            sb.append(", ").append(this.xy);
            sb.append(", ").append(this.xz);
            sb.append(", ").append(this.xt);
            sb.append('\n');
            sb.append("\t").append(this.yx);
            sb.append(", ").append(this.yy);
            sb.append(", ").append(this.yz);
            sb.append(", ").append(this.yt);
            sb.append('\n');
            sb.append("\t").append(this.zx);
            sb.append(", ").append(this.zy);
            sb.append(", ").append(this.zz);
            sb.append(", ").append(this.zt);
            return sb.append("\n]").toString();
        }

        private void updateState() {
            this.updateState2D();
            this.state3d = 0;
            if (this.xz != 0.0 || this.yz != 0.0 || this.zx != 0.0 || this.zy != 0.0) {
                this.state3d = 4;
            } else if ((this.state2d & 4) == 0) {
                if (this.zt != 0.0) {
                    this.state3d |= 1;
                }
                if (this.zz != 1.0) {
                    this.state3d |= 2;
                }
                if (this.state3d != 0) {
                    this.state3d |= this.state2d & 3;
                }
            } else if (this.zz != 1.0 || this.zt != 0.0) {
                this.state3d = 4;
            }
        }

        private void updateState2D() {
            this.state2d = this.xy == 0.0 && this.yx == 0.0 ? (this.xx == 1.0 && this.yy == 1.0 ? (this.xt == 0.0 && this.yt == 0.0 ? 0 : 1) : (this.xt == 0.0 && this.yt == 0.0 ? 2 : 3)) : (this.xx == 0.0 && this.yy == 0.0 ? (this.xt == 0.0 && this.yt == 0.0 ? 4 : 5) : (this.xt == 0.0 && this.yt == 0.0 ? 6 : 7));
        }

        void ensureCanTransform2DPoint() throws IllegalStateException {
            if (this.state3d != 0) {
                throw new IllegalStateException("Cannot transform 2D point with a 3D transform");
            }
        }

        private static void stateError() {
            throw new InternalError("missing case in a switch");
        }

        @Override
        @Deprecated
        public void impl_apply(Affine3D trans) {
            trans.concatenate(this.xx, this.xy, this.xz, this.xt, this.yx, this.yy, this.yz, this.yt, this.zx, this.zy, this.zz, this.zt);
        }

        @Override
        @Deprecated
        public BaseTransform impl_derive(BaseTransform trans) {
            return trans.deriveWithConcatenation(this.xx, this.xy, this.xz, this.xt, this.yx, this.yy, this.yz, this.yt, this.zx, this.zy, this.zz, this.zt);
        }

        int getState2d() {
            return this.state2d;
        }

        int getState3d() {
            return this.state3d;
        }
    }
}

