/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.behavior;

import com.sun.javafx.scene.control.behavior.BehaviorBase;
import com.sun.javafx.scene.control.behavior.KeyBinding;
import com.sun.javafx.scene.control.behavior.TwoLevelFocusComboBehavior;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.SelectionModel;
import javafx.scene.control.SingleSelectionModel;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;

public class ChoiceBoxBehavior<T>
extends BehaviorBase<ChoiceBox<T>> {
    protected static final List<KeyBinding> CHOICE_BUTTON_BINDINGS = new ArrayList<KeyBinding>();
    private TwoLevelFocusComboBehavior tlFocus;

    @Override
    protected void callAction(String name) {
        if (name.equals("Cancel")) {
            this.cancel();
        } else if (name.equals("Press")) {
            this.keyPressed();
        } else if (name.equals("Release")) {
            this.keyReleased();
        } else if (name.equals("Down")) {
            this.showPopup();
        } else {
            super.callAction(name);
        }
    }

    public ChoiceBoxBehavior(ChoiceBox<T> control) {
        super(control, CHOICE_BUTTON_BINDINGS);
        if (Utils.isTwoLevelFocus()) {
            this.tlFocus = new TwoLevelFocusComboBehavior(control);
        }
    }

    @Override
    public void dispose() {
        if (this.tlFocus != null) {
            this.tlFocus.dispose();
        }
        super.dispose();
    }

    public void select(int index) {
        SingleSelectionModel sm = ((ChoiceBox)this.getControl()).getSelectionModel();
        if (sm == null) {
            return;
        }
        ((SelectionModel)sm).select(index);
    }

    public void close() {
        ((ChoiceBox)this.getControl()).hide();
    }

    public void showPopup() {
        ((ChoiceBox)this.getControl()).show();
    }

    @Override
    public void mousePressed(MouseEvent e) {
        ChoiceBox choiceButton = (ChoiceBox)this.getControl();
        super.mousePressed(e);
        if (choiceButton.isFocusTraversable()) {
            choiceButton.requestFocus();
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        ChoiceBox choiceButton = (ChoiceBox)this.getControl();
        super.mouseReleased(e);
        if (choiceButton.isShowing() || !choiceButton.contains(e.getX(), e.getY())) {
            choiceButton.hide();
        } else if (e.getButton() == MouseButton.PRIMARY) {
            choiceButton.show();
        }
    }

    private void keyPressed() {
        ChoiceBox choiceButton = (ChoiceBox)this.getControl();
        if (!choiceButton.isShowing()) {
            choiceButton.show();
        }
    }

    private void keyReleased() {
    }

    public void cancel() {
        ChoiceBox choiceButton = (ChoiceBox)this.getControl();
        choiceButton.hide();
    }

    static {
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_PRESSED, "Press"));
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.SPACE, KeyEvent.KEY_RELEASED, "Release"));
        if (Utils.isTwoLevelFocus()) {
            CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_PRESSED, "Press"));
            CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.ENTER, KeyEvent.KEY_RELEASED, "Release"));
        }
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.ESCAPE, KeyEvent.KEY_RELEASED, "Cancel"));
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.DOWN, KeyEvent.KEY_RELEASED, "Down"));
        CHOICE_BUTTON_BINDINGS.add(new KeyBinding(KeyCode.CANCEL, KeyEvent.KEY_RELEASED, "Cancel"));
    }
}

