/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.jshell.protocol;

import com.intellij.execution.jshell.protocol.Endpoint;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.function.Consumer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;

public class MessageReader<T>
extends Endpoint {
    private final BufferedReader myIn;
    private final JAXBContext myContext;

    public MessageReader(InputStream input, Class<T> msgType) throws Exception {
        this.myIn = new BufferedReader(new InputStreamReader(input));
        this.myContext = JAXBContext.newInstance((Class[])new Class[]{msgType});
    }

    public T receive(Consumer<String> unparsedOutputSink) throws IOException {
        String line;
        while ((line = this.myIn.readLine()) != null) {
            if ("__#begin#__".equals(line)) {
                StringBuilder buf = new StringBuilder();
                String body = this.myIn.readLine();
                while (!"__#end#__".equals(body.trim())) {
                    buf.append(body).append("\n");
                    body = this.myIn.readLine();
                }
                try {
                    return (T)this.myContext.createUnmarshaller().unmarshal((Reader)new StringReader(buf.toString()));
                }
                catch (JAXBException e) {
                    throw new IOException(e);
                }
            }
            unparsedOutputSink.accept(line + "\n");
        }
        return null;
    }
}

