/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.toolWindow.panels;

import com.intellij.facet.Facet;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.NullableFactory;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringApiBundle;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.impl.SpringCombinedModelFactory;
import com.intellij.spring.toolWindow.SpringBeansViewSettings;
import com.intellij.spring.toolWindow.panels.SpringBeanPointerFinderRecursivePanel;
import com.intellij.spring.toolWindow.panels.SpringBeansModulesPanel;
import com.intellij.spring.toolWindow.panels.SpringConfigFilesFinderRecursivePanel;
import com.intellij.ui.FinderRecursivePanel;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringFileSetFinderRecursivePanel
extends FinderRecursivePanel<SpringFileSet> {
    private static final Condition<SpringFileSet> FILESET_NOT_REMOVED_CONDITION = set -> !set.isRemoved();
    private final Module myModule;
    @NotNull
    private final DefaultActionGroup myStructureViewActionGroup;
    private final ToggleAction myShowConfigurationAction;

    public SpringFileSetFinderRecursivePanel(@NotNull SpringBeansModulesPanel panel, @NotNull Module module, @NotNull DefaultActionGroup structureViewActionGroup) {
        if (panel == null) {
            SpringFileSetFinderRecursivePanel.$$$reportNull$$$0(0);
        }
        if (module == null) {
            SpringFileSetFinderRecursivePanel.$$$reportNull$$$0(1);
        }
        if (structureViewActionGroup == null) {
            SpringFileSetFinderRecursivePanel.$$$reportNull$$$0(2);
        }
        super((FinderRecursivePanel)panel);
        this.myModule = module;
        this.myStructureViewActionGroup = structureViewActionGroup;
        this.myShowConfigurationAction = new ToggleAction(SpringApiBundle.message((String)"spring.beans.view.show.configuration.files", (Object[])new Object[0]), null, SpringApiIcons.SpringConfig){

            public boolean isSelected(AnActionEvent e) {
                return SpringBeansViewSettings.getInstance(SpringFileSetFinderRecursivePanel.this.getProject()).isShowFiles();
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                super.update(e);
                e.getPresentation().setEnabled(SpringBeansViewSettings.getInstance(SpringFileSetFinderRecursivePanel.this.getProject()).isShowModules() && SpringBeansViewSettings.getInstance(SpringFileSetFinderRecursivePanel.this.getProject()).isShowFileSets());
            }

            public void setSelected(AnActionEvent e, boolean state) {
                SpringBeansViewSettings.getInstance(SpringFileSetFinderRecursivePanel.this.getProject()).setShowFiles(state);
                SpringFileSetFinderRecursivePanel.this.updateRightComponent(true);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/toolWindow/panels/SpringFileSetFinderRecursivePanel$1", "update"));
            }
        };
        this.myStructureViewActionGroup.add((AnAction)this.myShowConfigurationAction);
    }

    @NotNull
    protected List<SpringFileSet> getListItems() {
        SpringFacet springFacet = SpringFacet.getInstance((Module)this.myModule);
        assert (springFacet != null) : this.myModule;
        Set fileSets = SpringFileSetService.getInstance().getAllSets(springFacet);
        List list = ContainerUtil.filter((Collection)fileSets, FILESET_NOT_REMOVED_CONDITION);
        if (list == null) {
            SpringFileSetFinderRecursivePanel.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
            return this.getSelectedValue();
        }
        if (LangDataKeys.MODULE.is(dataId)) {
            SpringFileSet value = (SpringFileSet)this.getSelectedValue();
            return value == null ? null : value.getFacet().getModule();
        }
        return super.getData(dataId);
    }

    protected AnAction[] getCustomListActions() {
        return new AnAction[]{ActionManager.getInstance().getAction("SpringChangeActiveProfiles")};
    }

    public void dispose() {
        this.myStructureViewActionGroup.remove((AnAction)this.myShowConfigurationAction);
        super.dispose();
    }

    protected String getListEmptyText() {
        return "No application contexts defined";
    }

    @NotNull
    protected String getItemText(SpringFileSet fileSet) {
        String string = fileSet.getName();
        if (string == null) {
            SpringFileSetFinderRecursivePanel.$$$reportNull$$$0(4);
        }
        return string;
    }

    @Nullable
    protected Icon getItemIcon(SpringFileSet fileSet) {
        return fileSet.getIcon();
    }

    protected void doCustomizeCellRenderer(SimpleColoredComponent comp, JList list, SpringFileSet value, int index, boolean selected, boolean hasFocus) {
        comp.clear();
        comp.setIcon(this.getItemIcon(value));
        comp.append(this.getItemText(value));
        if (value.isAutodetected()) {
            comp.append(" " + SpringBundle.message("facet.context.autodetected.suffix", new Object[0]), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        }
    }

    protected boolean performEditAction() {
        SpringFacet springFacet = SpringFacet.getInstance((Module)this.myModule);
        if (springFacet != null) {
            ModulesConfigurator.showFacetSettingsDialog((Facet)springFacet, null);
        }
        return true;
    }

    @Nullable
    protected JComponent createRightComponent(SpringFileSet fileSet) {
        if (SpringBeansViewSettings.getInstance(this.getProject()).isShowFiles()) {
            return new SpringConfigFilesFinderRecursivePanel(this, fileSet, this.myModule);
        }
        NullableFactory factory = () -> SpringCombinedModelFactory.createModel(fileSet, this.myModule);
        return new SpringBeanPointerFinderRecursivePanel(this, (NullableFactory<CommonSpringModel>)factory);
    }

    protected boolean hasChildren(SpringFileSet fileSet) {
        return !fileSet.getFiles().isEmpty();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "structureViewActionGroup";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/toolWindow/panels/SpringFileSetFinderRecursivePanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/toolWindow/panels/SpringFileSetFinderRecursivePanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getListItems";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getItemText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

