/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.references;

import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiLiteral;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DefaultSpringBeanQualifier;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringQualifier;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.highlighting.autowire.SpringUastInjectionPointsAutowiringInspection;
import com.intellij.spring.model.jam.qualifiers.SpringJamQualifier;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

@Deprecated
public class SpringQualifierReference
extends PsiReferenceBase.Poly<PsiLiteralExpression> {
    public SpringQualifierReference(PsiLiteralExpression element) {
        super((PsiElement)element);
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    private CommonSpringModel getSpringModel() {
        CommonSpringModel commonSpringModel = SpringModelUtils.getInstance().getSpringModel(this.myElement);
        if (commonSpringModel == null) {
            SpringQualifierReference.$$$reportNull$$$0(0);
        }
        return commonSpringModel;
    }

    @NotNull
    public Object[] getVariants() {
        PsiClass psiAnnoClass = SpringUastInjectionPointsAutowiringInspection.findAnnoPsiClass((PsiLiteral)this.myElement);
        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiVariable.class);
        if (psiAnnoClass != null && variable != null) {
            PsiType type = variable.getType();
            CommonSpringModel model = this.getSpringModel();
            Set<SpringBeanPointer> pointers = SpringAutowireUtil.autowireByType(model, type);
            HashSet variants = new HashSet();
            for (SpringBeanPointer beanPointer : pointers) {
                CommonSpringBean bean = beanPointer.getSpringBean();
                Collection qualifiers = bean.getSpringQualifiers();
                if (!qualifiers.isEmpty()) {
                    for (SpringQualifier qualifier : qualifiers) {
                        String value = qualifier.getQualifierValue();
                        if (value == null || !(qualifier instanceof DefaultSpringBeanQualifier) && !Comparing.equal((Object)qualifier.getQualifierType(), (Object)psiAnnoClass)) continue;
                        variants.add(SpringConverterUtil.createCompletionVariant((SpringBeanPointer)beanPointer, (String)value));
                    }
                    continue;
                }
                ContainerUtil.addIfNotNull((Collection)variants, (Object)SpringConverterUtil.createCompletionVariant((SpringBeanPointer)beanPointer));
            }
            Object[] objectArray = ArrayUtil.toObjectArray((Collection)variants);
            if (objectArray == null) {
                SpringQualifierReference.$$$reportNull$$$0(1);
            }
            return objectArray;
        }
        if (EMPTY_ARRAY == null) {
            SpringQualifierReference.$$$reportNull$$$0(2);
        }
        return EMPTY_ARRAY;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiClass psiAnnoClass;
        PsiAnnotation annotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)this.myElement, PsiAnnotation.class);
        PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class);
        if (member == null) {
            if (ResolveResult.EMPTY_ARRAY == null) {
                SpringQualifierReference.$$$reportNull$$$0(3);
            }
            return ResolveResult.EMPTY_ARRAY;
        }
        Object value = ((PsiLiteralExpression)this.myElement).getValue();
        if (value instanceof String && (psiAnnoClass = SpringUastInjectionPointsAutowiringInspection.findAnnoPsiClass((PsiLiteral)this.myElement)) != null) {
            PsiElement psiElement;
            SpringBeanPointer springBeanPointer;
            CommonSpringModel model = this.getSpringModel();
            ArrayList<PsiElementResolveResult> results = new ArrayList<PsiElementResolveResult>();
            SpringJamQualifier jamQualifier = new SpringJamQualifier(annotation, null);
            List qualifiedBeans = model.findQualifiedBeans((SpringQualifier)jamQualifier);
            for (SpringBeanPointer beanPointer : qualifiedBeans) {
                CommonSpringBean bean = beanPointer.getSpringBean();
                for (SpringQualifier qualifier : bean.getSpringQualifiers()) {
                    results.add(new PsiElementResolveResult(qualifier.getIdentifyingPsiElement()));
                }
            }
            String qualifierValue = jamQualifier.getQualifierValue();
            if (qualifierValue != null && (springBeanPointer = SpringModelSearchers.findBean((CommonSpringModel)model, (String)qualifierValue)) != null && springBeanPointer.isValid() && (psiElement = springBeanPointer.getPsiElement()) != null) {
                results.add(new PsiElementResolveResult(psiElement));
            }
            ResolveResult[] resolveResultArray = results.toArray(new ResolveResult[results.size()]);
            if (resolveResultArray == null) {
                SpringQualifierReference.$$$reportNull$$$0(4);
            }
            return resolveResultArray;
        }
        if (ResolveResult.EMPTY_ARRAY == null) {
            SpringQualifierReference.$$$reportNull$$$0(5);
        }
        return ResolveResult.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/spring/references/SpringQualifierReference";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSpringModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "multiResolve";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

