/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.perspectives.diagrams;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.diagram.DiagramDataModel;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.SuggestedNameInfo;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.stereotype.SpringStereotypeElement;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringModelSearchers;
import com.intellij.spring.model.utils.SpringPropertyUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.CollectionElements;
import com.intellij.spring.model.xml.beans.LookupMethod;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringValueHolderDefinition;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.spring.perspectives.diagrams.SpringDependencyType;
import com.intellij.spring.perspectives.diagrams.SpringDiagramEdge;
import com.intellij.spring.perspectives.diagrams.SpringDiagramEdgeCreationUtil;
import com.intellij.spring.perspectives.diagrams.SpringDiagramNode;
import com.intellij.spring.perspectives.diagrams.beans.SpringBeanPointerWrapper;
import com.intellij.spring.perspectives.diagrams.beans.SpringElementWrapper;
import com.intellij.spring.perspectives.diagrams.beans.UserDefinedClassWrapper;
import com.intellij.spring.perspectives.diagrams.edges.ByConstructorAutowire;
import com.intellij.spring.perspectives.diagrams.edges.ByNameAutowire;
import com.intellij.spring.perspectives.diagrams.edges.ByTypeAutowire;
import com.intellij.spring.perspectives.diagrams.edges.DependsOnEdge;
import com.intellij.spring.perspectives.diagrams.edges.FactoryBeanEdge;
import com.intellij.spring.perspectives.diagrams.edges.ImportedBeanEdge;
import com.intellij.spring.perspectives.diagrams.edges.InjectionEdge;
import com.intellij.spring.perspectives.diagrams.edges.JavaBeanEdge;
import com.intellij.spring.perspectives.diagrams.edges.LookupMethodEdge;
import com.intellij.spring.perspectives.diagrams.edges.ParentBeanEdge;
import com.intellij.spring.perspectives.diagrams.edges.ScannedBeanEdge;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomElementVisitor;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringDiagramBeansProcessingModel
extends DiagramDataModel<SpringElementWrapper> {
    private static final Key<Boolean> PROCESSED_KEY = Key.create((String)"PROCESSED_KEY");
    private final Collection<DiagramNode<SpringElementWrapper>> myNodes = ContainerUtil.newLinkedHashSet();
    private final Collection<DiagramEdge<SpringElementWrapper>> myEdges = ContainerUtil.newLinkedHashSet();

    public SpringDiagramBeansProcessingModel(Project project, DiagramProvider<SpringElementWrapper> springBaseBeanPointerDiagramProvider) {
        super(project, springBaseBeanPointerDiagramProvider);
    }

    @NotNull
    public Collection<DiagramNode<SpringElementWrapper>> getNodes() {
        Collection<DiagramNode<SpringElementWrapper>> collection = this.myNodes;
        if (collection == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<DiagramEdge<SpringElementWrapper>> getEdges() {
        Collection<DiagramEdge<SpringElementWrapper>> collection = this.myEdges;
        if (collection == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(1);
        }
        return collection;
    }

    protected void processDependencies(@NotNull CommonSpringModel model, @NotNull Set<SpringBeanPointer> pointerSet, @NotNull SpringBeanPointer pointer, @NotNull DiagramNode<SpringElementWrapper> node) {
        if (model == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(2);
        }
        if (pointerSet == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(3);
        }
        if (pointer == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(4);
        }
        if (node == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(5);
        }
        if (this.isProcessed(node)) {
            return;
        }
        SpringDiagramBeansProcessingModel.setProcessed(node);
        CommonSpringBean springBean = pointer.getSpringBean();
        if (!springBean.isValid()) {
            return;
        }
        this.processXmlBeanDependencies(model, pointerSet, pointer, node, springBean);
        this.processStereotypeElementDependencies(model, pointerSet, node, springBean);
        this.addAnnotatedAutowiring(node, springBean, model);
    }

    private void processStereotypeElementDependencies(@NotNull CommonSpringModel model, @NotNull Set<SpringBeanPointer> pointerSet, @NotNull DiagramNode<SpringElementWrapper> node, CommonSpringBean springBean) {
        if (model == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(6);
        }
        if (pointerSet == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(7);
        }
        if (node == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(8);
        }
        if (springBean instanceof SpringStereotypeElement) {
            SpringStereotypeElement stereotypeElement = (SpringStereotypeElement)springBean;
            this.addJavaImportedDependencies(node, stereotypeElement, model, pointerSet);
            this.addJavaComponentScans(node, stereotypeElement, model, pointerSet);
            this.addJavaBeans(node, stereotypeElement, model);
        }
    }

    private void processXmlBeanDependencies(@NotNull CommonSpringModel model, @NotNull Set<SpringBeanPointer> beans, @NotNull SpringBeanPointer pointer, @NotNull DiagramNode<SpringElementWrapper> node, @NotNull CommonSpringBean springBean) {
        if (model == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(9);
        }
        if (beans == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(10);
        }
        if (pointer == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(11);
        }
        if (node == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(12);
        }
        if (springBean == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(13);
        }
        if (springBean instanceof SpringBean) {
            this.addSpringBeanDependencies(node, pointer, model, beans, (SpringBean)springBean);
        } else if (springBean instanceof CollectionElements) {
            this.addCollectionElements(node, pointer, beans, model);
        } else if (springBean instanceof SpringBeansPackagesScanBean) {
            if (model.getModule() != null) {
                for (CommonSpringBean bean : ((SpringBeansPackagesScanBean)springBean).getScannedElements(model.getModule())) {
                    this.addScannedBeanNode(node, model, beans, bean);
                }
            }
        } else if (springBean instanceof DomSpringBean) {
            this.addPointedDependencies(node, pointer, beans, model);
        }
    }

    @Nullable
    public DiagramNode<SpringElementWrapper> getOrCreateElement(SpringBeanPointer beanPointer, @Nullable Module module) {
        DiagramNode<SpringElementWrapper> target = this.getNode(beanPointer);
        if (target == null) {
            target = this.addNode(beanPointer, module);
        }
        return target;
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> addNode(SpringBeanPointer element, Module module) {
        return element == null ? null : this.addNode((SpringElementWrapper)SpringBeanPointerWrapper.create((SpringBeanPointer)element, (Module)module));
    }

    private DiagramNode<SpringElementWrapper> addNode(SpringElementWrapper beanPointerWrapper) {
        SpringDiagramNode node = new SpringDiagramNode(beanPointerWrapper, this.getProvider());
        if (!this.myNodes.contains(node)) {
            this.myNodes.add((DiagramNode<SpringElementWrapper>)node);
        }
        return node;
    }

    private void addCollectionElements(DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer pointer, Set<SpringBeanPointer> modelBeans, CommonSpringModel model) {
        CommonSpringBean springBean = pointer.getSpringBean();
        if (springBean instanceof CollectionElements) {
            LinkedHashMap<SpringBeanPointer, DomElement> beans = new LinkedHashMap<SpringBeanPointer, DomElement>();
            SpringPropertyUtils.addCollectionReferences((CollectionElements)((CollectionElements)springBean), beans);
            this.handleBeanMap(sourceNode, model, modelBeans, beans);
        }
    }

    private void addSpringBeanDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer springBeanPointer, CommonSpringModel model, Set<SpringBeanPointer> modelBeans, @NotNull SpringBean bean) {
        if (sourceNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(14);
        }
        if (bean == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(15);
        }
        this.addXmlBeanInjectedDependencies(sourceNode, bean, model, modelBeans);
        this.addXmlBeanLookupMethodInjectedDependencies(sourceNode, bean, modelBeans, model);
        this.addXmlBeanFactoryBeanDependencies(sourceNode, bean, modelBeans);
        this.addXmlBeanParentBeanDependencies(sourceNode, bean, modelBeans, model);
        this.addXmlBeanDependsOnDependencies(sourceNode, bean, model);
        this.addXmlBeanAutowiredDependencies(sourceNode, bean, model);
    }

    private void addJavaImportedDependencies(@NotNull DiagramNode<SpringElementWrapper> node, @NotNull SpringStereotypeElement commonSpringBean, @NotNull CommonSpringModel model, @NotNull Set<SpringBeanPointer> beans) {
        if (node == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(16);
        }
        if (commonSpringBean == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(17);
        }
        if (model == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(18);
        }
        if (beans == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(19);
        }
        PsiClass psiClass = commonSpringBean.getPsiElement();
        List springImports = SemService.getSemService((Project)psiClass.getProject()).getSemElements(SpringImport.IMPORT_JAM_KEY, (PsiElement)psiClass);
        for (SpringImport springImport : springImports) {
            for (PsiClass aClass : springImport.getImportedClasses()) {
                List importedBeans = SpringModelSearchers.findBeans((CommonSpringModel)model, (SpringModelSearchParameters.BeanClass)SpringModelSearchParameters.byClass((PsiClass)aClass));
                if (importedBeans.size() != 1) continue;
                SpringBeanPointer targetPointer = (SpringBeanPointer)importedBeans.get(0);
                DiagramNode<SpringElementWrapper> targetNode = this.getNode(targetPointer);
                if (targetNode == null) {
                    targetNode = this.addNode(targetPointer, model.getModule());
                }
                if (targetNode == null) continue;
                this.processDependencies(model, beans, targetPointer, targetNode);
                this.addEdge(new ImportedBeanEdge(node, targetNode, SpringDiagramBeansProcessingModel.getShortAnnotationName(springImport.getAnnotation())));
            }
        }
    }

    @Nullable
    private static String getShortAnnotationName(@Nullable PsiAnnotation annotation) {
        if (annotation != null) {
            String qualifiedName = annotation.getQualifiedName();
            return qualifiedName == null ? null : "@" + StringUtil.getShortName((String)qualifiedName);
        }
        return null;
    }

    private void addJavaComponentScans(@NotNull DiagramNode<SpringElementWrapper> node, @NotNull SpringStereotypeElement commonSpringBean, @NotNull CommonSpringModel model, @NotNull Set<SpringBeanPointer> beans) {
        Module module;
        if (node == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(20);
        }
        if (commonSpringBean == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(21);
        }
        if (model == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(22);
        }
        if (beans == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(23);
        }
        if ((module = model.getModule()) == null) {
            return;
        }
        PsiClass psiClass = commonSpringBean.getPsiElement();
        List scans = SpringJamUtils.getInstance().getBeansPackagesScan(psiClass);
        for (SpringBeansPackagesScan scan : scans) {
            Set scannedElements = scan.getScannedElements(module);
            for (CommonSpringBean springBean : scannedElements) {
                this.addScannedBeanNode(node, model, beans, springBean);
            }
        }
    }

    private void addJavaBeans(@NotNull DiagramNode<SpringElementWrapper> node, @NotNull SpringStereotypeElement stereotypeElement, @NotNull CommonSpringModel model) {
        if (node == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(24);
        }
        if (stereotypeElement == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(25);
        }
        if (model == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(26);
        }
        for (SpringJavaBean springJavaBean : stereotypeElement.getBeans()) {
            SpringBeanPointer targetPointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)springJavaBean);
            DiagramNode<SpringElementWrapper> targetNode = this.getNode(targetPointer);
            if (targetNode == null) {
                targetNode = this.addNode(targetPointer, model.getModule());
            }
            if (targetNode == null) continue;
            this.addEdge(new JavaBeanEdge(node, targetNode));
        }
    }

    private void addScannedBeanNode(DiagramNode<SpringElementWrapper> node, CommonSpringModel model, Set<SpringBeanPointer> beans, CommonSpringBean bean) {
        SpringBeanPointer targetPointer = BeanService.getInstance().createSpringBeanPointer(bean);
        DiagramNode<SpringElementWrapper> targetNode = this.getNode(targetPointer);
        if (targetNode == null) {
            targetNode = this.addNode(targetPointer, model.getModule());
        }
        if (targetNode != null) {
            this.processDependencies(model, beans, targetPointer, targetNode);
            this.addEdge(new ScannedBeanEdge(node, targetNode));
        }
    }

    private void addPointedDependencies(final DiagramNode<SpringElementWrapper> sourceNode, SpringBeanPointer springBeanPointer, final Set<SpringBeanPointer> pointerSet, final CommonSpringModel model) {
        CommonSpringBean springBean = springBeanPointer.getSpringBean();
        if (SpringDiagramBeansProcessingModel.isCustomSchemaBean(springBean)) {
            ((DomSpringBean)springBean).acceptChildren(new DomElementVisitor(){

                public void visitDomElement(DomElement element) {
                    if (element instanceof SpringBean && DomUtil.hasXml((DomElement)element)) {
                        SpringBeanPointer pointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)((SpringBean)element));
                        DiagramNode targetNode = SpringDiagramBeansProcessingModel.this.getNode(pointer);
                        if (targetNode == null) {
                            targetNode = SpringDiagramBeansProcessingModel.this.addNode(pointer, model.getModule());
                        }
                        if (targetNode != null) {
                            SpringDiagramBeansProcessingModel.this.processDependencies(model, pointerSet, pointer, (DiagramNode<SpringElementWrapper>)targetNode);
                            SpringDiagramBeansProcessingModel.this.addEdge((SpringDiagramEdge)new InjectionEdge((DiagramNode<SpringElementWrapper>)sourceNode, (DiagramNode<SpringElementWrapper>)targetNode, element));
                        }
                    } else if (element instanceof GenericAttributeValue && DomUtil.hasXml((DomElement)element)) {
                        SpringBeanPointer beanPointer;
                        DiagramNode<SpringElementWrapper> target;
                        Object pointer = ((GenericDomValue)element).getValue();
                        if (pointer instanceof SpringBeanPointer && (target = SpringDiagramBeansProcessingModel.this.getOrCreateElement(beanPointer = (SpringBeanPointer)pointer, model.getModule())) != null) {
                            XmlAttribute xmlAttribute = ((GenericAttributeValue)element).getXmlAttribute();
                            String attrName = xmlAttribute != null ? xmlAttribute.getLocalName() : null;
                            SpringDiagramBeansProcessingModel.this.addEdge((SpringDiagramEdge)new InjectionEdge((DiagramNode<SpringElementWrapper>)sourceNode, target, element, attrName));
                        }
                    } else if (element instanceof SpringValueHolderDefinition) {
                        SpringDiagramBeansProcessingModel.this.addSpringValueHolderDependencies((DiagramNode<SpringElementWrapper>)sourceNode, pointerSet, (SpringValueHolderDefinition)element, model);
                    } else {
                        List children = DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)true);
                        for (DomElement child : children) {
                            child.accept((DomElementVisitor)this);
                        }
                    }
                }
            });
        }
    }

    private void addEdge(@Nullable DiagramNode<SpringElementWrapper> source, @Nullable DiagramNode<SpringElementWrapper> target, @NotNull SpringDependencyType info) {
        if (info == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(27);
        }
        this.addEdge(source, target, info, null);
    }

    private void addEdge(@Nullable DiagramNode<SpringElementWrapper> source, @Nullable DiagramNode<SpringElementWrapper> target, @NotNull SpringDependencyType info, @Nullable String customInfo) {
        if (info == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(28);
        }
        if (source != null && target != null) {
            this.addEdge(new SpringDiagramEdge(source, target, info, customInfo));
        }
    }

    private void addEdge(SpringDiagramEdge edge) {
        if (!this.myEdges.contains(edge)) {
            this.myEdges.add((DiagramEdge<SpringElementWrapper>)edge);
        }
    }

    public long getModificationCount() {
        return super.getModificationCount() + PsiManager.getInstance((Project)this.getProject()).getModificationTracker().getJavaStructureModificationCount();
    }

    private static boolean isCustomSchemaBean(CommonSpringBean springBean) {
        return springBean instanceof DomSpringBean && !(springBean instanceof SpringBean);
    }

    private void addXmlBeanAutowiredDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBean springBean, CommonSpringModel model) {
        if (sourceNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(29);
        }
        if (SpringAutowireUtil.isByTypeAutowired(springBean)) {
            this.addXmlByTypeAutowireDependencies(sourceNode, springBean, model);
        } else if (SpringAutowireUtil.isByNameAutowired(springBean)) {
            this.addXmlByNameAutowireDependencies(sourceNode, springBean, model.getModule());
        } else if (SpringAutowireUtil.isConstructorAutowire(springBean)) {
            this.addXmlConstructorAutowireDependencies(sourceNode, springBean, model);
        }
    }

    private void addAnnotatedAutowiring(@NotNull DiagramNode<SpringElementWrapper> sourceNode, CommonSpringBean commonSpringBean, CommonSpringModel model) {
        if (sourceNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(30);
        }
        Map<PsiMember, Set<SpringBeanPointer>> map = SpringAutowireUtil.getAutowireAnnotationProperties(commonSpringBean, model);
        for (Map.Entry<PsiMember, Set<SpringBeanPointer>> entry : map.entrySet()) {
            PsiMember member = entry.getKey();
            Set<SpringBeanPointer> springBeans = entry.getValue();
            for (SpringBeanPointer bean : springBeans) {
                DiagramNode<SpringElementWrapper> targetNode = this.getOrCreateElement(bean, model.getModule());
                if (targetNode == null) continue;
                this.addEdge(sourceNode, targetNode, SpringDiagramBeansProcessingModel.getAnnotatedAutowireType(member));
            }
        }
    }

    private static SpringDependencyType getAnnotatedAutowireType(PsiMember member) {
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, Collections.singleton("javax.annotation.Resource"))) {
            return SpringDependencyType.ANNO_RESOURCE_AUTOWIRED;
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)member, Collections.singleton("javax.inject.Inject"))) {
            return SpringDependencyType.ANNO_INJECT_AUTOWIRED;
        }
        return SpringDependencyType.ANNO_AUTOWIRED;
    }

    private void addXmlConstructorAutowireDependencies(DiagramNode<SpringElementWrapper> sourceNode, @NotNull SpringBean springBean, @NotNull CommonSpringModel model) {
        if (springBean == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(31);
        }
        if (model == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(32);
        }
        Map<PsiType, Collection<SpringBeanPointer>> autowiredProperties = SpringAutowireUtil.getConstructorAutowiredProperties(springBean, model);
        for (Collection<SpringBeanPointer> springBeans : autowiredProperties.values()) {
            for (SpringBeanPointer bean : springBeans) {
                DiagramNode<SpringElementWrapper> targetNode = this.getOrCreateElement(bean, model.getModule());
                if (targetNode == null) continue;
                this.addEdge(new ByConstructorAutowire(sourceNode, targetNode));
            }
        }
    }

    private void addXmlByNameAutowireDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBean springBean, Module module) {
        if (sourceNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(33);
        }
        Map<PsiMethod, SpringBeanPointer> autowiredProperties = SpringAutowireUtil.getByNameAutowiredProperties(springBean);
        for (SpringBeanPointer bean : autowiredProperties.values()) {
            DiagramNode<SpringElementWrapper> targetNode;
            if (bean == null || (targetNode = this.getOrCreateElement(bean, module)) == null) continue;
            this.addEdge(new ByNameAutowire(sourceNode, targetNode));
        }
    }

    private void addXmlByTypeAutowireDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBean springBean, CommonSpringModel model) {
        if (sourceNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(34);
        }
        Map<PsiMethod, Collection<SpringBeanPointer>> autowiredProperties = SpringAutowireUtil.getByTypeAutowiredProperties(springBean, model);
        for (Collection<SpringBeanPointer> springBeans : autowiredProperties.values()) {
            for (SpringBeanPointer bean : springBeans) {
                DiagramNode<SpringElementWrapper> targetNode = this.getOrCreateElement(bean, model.getModule());
                if (targetNode == null) continue;
                this.addEdge(new ByTypeAutowire(sourceNode, targetNode));
            }
        }
    }

    private void addXmlBeanParentBeanDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, @NotNull SpringBean springBean, @NotNull Set<SpringBeanPointer> modelBeans, CommonSpringModel model) {
        DiagramNode<SpringElementWrapper> targetNode;
        GenericAttributeValue parentBean;
        SpringBeanPointer parentBeanValue;
        if (sourceNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(35);
        }
        if (springBean == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(36);
        }
        if (modelBeans == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(37);
        }
        if ((parentBeanValue = (SpringBeanPointer)(parentBean = springBean.getParentBean()).getValue()) == null) {
            return;
        }
        SpringBeanPointer parentBeanPointer = parentBeanValue.getBasePointer();
        if (modelBeans.contains(parentBeanPointer) && (targetNode = this.getOrCreateElement(parentBeanPointer, model.getModule())) != null) {
            this.addEdge((SpringDiagramEdge)new ParentBeanEdge(sourceNode, targetNode, (DomElement)parentBean));
        }
    }

    private void addXmlBeanDependsOnDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBean bean, CommonSpringModel model) {
        GenericAttributeValue dependsOn;
        List dependsOnBeanPointer;
        if (sourceNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(38);
        }
        if ((dependsOnBeanPointer = (List)(dependsOn = bean.getDependsOn()).getValue()) != null) {
            for (SpringBeanPointer dependsOnBean : dependsOnBeanPointer) {
                SpringBeanPointer pointer;
                DiagramNode<SpringElementWrapper> targetNode;
                if (dependsOnBean == null || (targetNode = this.getOrCreateElement(pointer = dependsOnBean.getBasePointer(), model.getModule())) == null) continue;
                this.addEdge((SpringDiagramEdge)new DependsOnEdge(sourceNode, targetNode, (DomElement)dependsOn));
            }
        }
    }

    private void addXmlBeanFactoryBeanDependencies(@NotNull DiagramNode<SpringElementWrapper> node, SpringBean springBean, Set<SpringBeanPointer> modelBeans) {
        DiagramNode<SpringElementWrapper> source;
        GenericAttributeValue factoryBean;
        SpringBeanPointer factoryBeanValue;
        if (node == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(39);
        }
        if ((factoryBeanValue = (SpringBeanPointer)(factoryBean = springBean.getFactoryBean()).getValue()) == null) {
            return;
        }
        SpringBeanPointer factoryBeanPointer = factoryBeanValue.getBasePointer();
        if (modelBeans.contains(factoryBeanPointer) && (source = this.getOrCreateElement(factoryBeanPointer, this.getActualModel().getModule())) != null) {
            this.addEdge((SpringDiagramEdge)new FactoryBeanEdge(source, node, (DomElement)factoryBean));
        }
    }

    private void addXmlBeanInjectedDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, SpringBean springBean, CommonSpringModel model, Set<SpringBeanPointer> modelBeans) {
        if (sourceNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(40);
        }
        for (SpringValueHolderDefinition valueHolderDefinition : SpringPropertyUtils.getValueHolders((CommonSpringBean)springBean)) {
            this.addSpringValueHolderDependencies(sourceNode, modelBeans, valueHolderDefinition, model);
        }
    }

    private void addSpringValueHolderDependencies(DiagramNode<SpringElementWrapper> sourceNode, Set<SpringBeanPointer> modelBeans, SpringValueHolderDefinition valueHolderDefinition, CommonSpringModel model) {
        this.handleBeanMap(sourceNode, model, modelBeans, SpringPropertyUtils.getValueHolderDependencies((SpringValueHolderDefinition)valueHolderDefinition));
    }

    private void handleBeanMap(DiagramNode<SpringElementWrapper> sourceNode, CommonSpringModel model, Set<SpringBeanPointer> modelBeans, Map<SpringBeanPointer, DomElement> beanMap) {
        for (Map.Entry<SpringBeanPointer, DomElement> entry : beanMap.entrySet()) {
            SpringBeanPointer bean = entry.getKey();
            DomElement identifyingElement = entry.getValue();
            if (!SpringDiagramBeansProcessingModel.modelBeansContain(modelBeans, bean)) continue;
            DiagramNode<SpringElementWrapper> targetNode = this.getNode(bean);
            if (targetNode == null) {
                targetNode = this.addNode(bean, model.getModule());
            }
            if (targetNode == null) continue;
            this.processDependencies(model, modelBeans, bean, targetNode);
            this.addEdge((SpringDiagramEdge)new InjectionEdge(sourceNode, targetNode, identifyingElement));
        }
    }

    private static void setProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
        if (targetNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(41);
        }
        targetNode.putUserData(PROCESSED_KEY, (Object)true);
    }

    protected boolean isProcessed(@NotNull DiagramNode<SpringElementWrapper> targetNode) {
        Boolean isProcessed;
        if (targetNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(42);
        }
        return (isProcessed = (Boolean)targetNode.getUserData(PROCESSED_KEY)) != null && isProcessed != false;
    }

    @Nullable
    private DiagramNode<SpringElementWrapper> getNode(@NotNull SpringBeanPointer bean) {
        if (bean == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(43);
        }
        for (DiagramNode<SpringElementWrapper> node : this.myNodes) {
            if (!bean.equals(((SpringElementWrapper)node.getIdentifyingElement()).getWrapped())) continue;
            return node;
        }
        return null;
    }

    private static boolean modelBeansContain(Collection<SpringBeanPointer> modelBeans, SpringBeanPointer bean) {
        if (modelBeans.contains(bean)) {
            return true;
        }
        CommonSpringBean commonSpringBean = bean.getSpringBean();
        if (commonSpringBean instanceof DomSpringBean) {
            for (DomSpringBean parent = (DomSpringBean)((DomSpringBean)commonSpringBean).getParentOfType(DomSpringBean.class, true); parent != null; parent = (DomSpringBean)parent.getParentOfType(DomSpringBean.class, true)) {
                SpringBeanPointer beanPointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)parent);
                if (!modelBeans.contains(beanPointer)) continue;
                return true;
            }
        }
        return false;
    }

    private void addXmlBeanLookupMethodInjectedDependencies(@NotNull DiagramNode<SpringElementWrapper> sourceNode, @NotNull SpringBean springBean, @NotNull Set<SpringBeanPointer> modelBeans, CommonSpringModel model) {
        if (sourceNode == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(44);
        }
        if (springBean == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(45);
        }
        if (modelBeans == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(46);
        }
        for (LookupMethod method : springBean.getLookupMethods()) {
            DiagramNode<SpringElementWrapper> targetNode;
            SpringBeanPointer pointer;
            GenericAttributeValue bean = method.getBean();
            SpringBeanPointer beanValue = (SpringBeanPointer)bean.getValue();
            if (beanValue == null || !modelBeans.contains(pointer = beanValue.getBasePointer()) || (targetNode = this.getOrCreateElement(pointer, model.getModule())) == null) continue;
            this.addEdge((SpringDiagramEdge)new LookupMethodEdge(sourceNode, targetNode, (DomElement)bean));
        }
    }

    public DiagramEdge<SpringElementWrapper> createEdge(@NotNull DiagramNode<SpringElementWrapper> from, @NotNull DiagramNode<SpringElementWrapper> to) {
        DiagramEdge<SpringElementWrapper> edge;
        if (from == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(47);
        }
        if (to == null) {
            SpringDiagramBeansProcessingModel.$$$reportNull$$$0(48);
        }
        if ((edge = SpringDiagramEdgeCreationUtil.createEdge(from, to, this.myEdges, this.getBuilder(), this.getActualModel())) != null) {
            this.myEdges.add(edge);
        }
        return edge;
    }

    public void removeNode(DiagramNode<SpringElementWrapper> node) {
        ArrayList<DiagramEdge<SpringElementWrapper>> edges = new ArrayList<DiagramEdge<SpringElementWrapper>>();
        for (DiagramEdge<SpringElementWrapper> edge : this.myEdges) {
            if (!edge.getTarget().equals(node) && !edge.getSource().equals(node)) continue;
            edges.add(edge);
        }
        this.myEdges.removeAll(edges);
        this.myNodes.remove(node);
    }

    protected abstract CommonSpringModel getActualModel();

    protected void clearAll() {
        this.myEdges.clear();
        this.myNodes.clear();
    }

    public DiagramNode<SpringElementWrapper> addElement(SpringElementWrapper element) {
        if (element instanceof UserDefinedClassWrapper) {
            LocalXmlModel localXmlModel;
            DomFileElement root;
            PsiClass wrapped = (PsiClass)((UserDefinedClassWrapper)element).getWrapped();
            CommonSpringModel model = this.getActualModel();
            if (model instanceof LocalXmlModel && (root = (localXmlModel = (LocalXmlModel)model).getRoot()) != null) {
                if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{localXmlModel.getConfig()})) {
                    return null;
                }
                Beans beans = (Beans)root.getRootElement();
                SpringBean springBean = beans.addBean();
                springBean.getClazz().setStringValue(wrapped.getQualifiedName());
                Project project = wrapped.getProject();
                JavaCodeStyleManager codeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
                SuggestedNameInfo info = codeStyleManager.suggestVariableName(VariableKind.FIELD, null, null, (PsiType)PsiTypesUtil.getClassType((PsiClass)wrapped));
                for (String beanName : info.names) {
                    if (SpringModelSearchers.findBean((CommonSpringModel)model, (String)beanName) != null) continue;
                    springBean.getId().setStringValue(beanName);
                }
                SpringBean stableCopy = (SpringBean)springBean.createStableCopy();
                PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                psiDocumentManager.doPostponedOperationsAndUnblockDocument(psiDocumentManager.getDocument(((XmlFile)localXmlModel.getConfig()).getContainingFile()));
                SpringBeanPointer pointer = BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)stableCopy);
                return this.addNode(pointer, element.getModule());
            }
        }
        return this.addNode(element);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/perspectives/diagrams/SpringDiagramBeansProcessingModel";
                break;
            }
            case 2: 
            case 6: 
            case 9: 
            case 18: 
            case 22: 
            case 26: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointerSet";
                break;
            }
            case 4: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 5: 
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 10: 
            case 19: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 13: 
            case 31: 
            case 36: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 14: 
            case 29: 
            case 30: 
            case 33: 
            case 34: 
            case 35: 
            case 38: 
            case 40: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceNode";
                break;
            }
            case 15: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bean";
                break;
            }
            case 17: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonSpringBean";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stereotypeElement";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "info";
                break;
            }
            case 37: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modelBeans";
                break;
            }
            case 41: 
            case 42: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetNode";
                break;
            }
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "from";
                break;
            }
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "to";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getEdges";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/perspectives/diagrams/SpringDiagramBeansProcessingModel";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processDependencies";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processStereotypeElementDependencies";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "processXmlBeanDependencies";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "addSpringBeanDependencies";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addJavaImportedDependencies";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "addJavaComponentScans";
                break;
            }
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "addJavaBeans";
                break;
            }
            case 27: 
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "addEdge";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanAutowiredDependencies";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "addAnnotatedAutowiring";
                break;
            }
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "addXmlConstructorAutowireDependencies";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "addXmlByNameAutowireDependencies";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "addXmlByTypeAutowireDependencies";
                break;
            }
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanParentBeanDependencies";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanDependsOnDependencies";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanFactoryBeanDependencies";
                break;
            }
            case 40: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanInjectedDependencies";
                break;
            }
            case 41: {
                objectArray = objectArray;
                objectArray[2] = "setProcessed";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "isProcessed";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getNode";
                break;
            }
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "addXmlBeanLookupMethodInjectedDependencies";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "createEdge";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

