/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.jam.testContexts;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AbstractBaseJavaLocalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class SpringTestingTransactionalInspection
extends AbstractBaseJavaLocalInspectionTool {
    public ProblemDescriptor[] checkClass(@NotNull PsiClass aClass, @NotNull InspectionManager manager, boolean isOnTheFly) {
        Module module;
        if (aClass == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(0);
        }
        if (manager == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(1);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)aClass)) == null || !SpringTestContextUtil.getInstance().isTestContextConfigurationClass(aClass)) {
            return null;
        }
        ProblemsHolder holder = new ProblemsHolder(manager, aClass.getContainingFile(), isOnTheFly);
        for (PsiMethod method : aClass.getMethods()) {
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{"org.springframework.test.context.transaction.BeforeTransaction", "org.springframework.test.context.transaction.AfterTransaction"});
            if (annotation == null) continue;
            SpringTestingTransactionalInspection.checkLifecycleTransactionMethod(holder, method, annotation);
        }
        return holder.getResultsArray();
    }

    private static void checkLifecycleTransactionMethod(@NotNull ProblemsHolder holder, @NotNull PsiMethod method, @NotNull PsiAnnotation annotation) {
        if (holder == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(2);
        }
        if (method == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(3);
        }
        if (annotation == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(4);
        }
        if (method.getParameterList().getParametersCount() > 0) {
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("spring.testing.transactional.wrong.number.of.arguments.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
        if (!PsiType.VOID.equals((Object)method.getReturnType())) {
            holder.registerProblem((PsiElement)annotation, SpringBundle.message("spring.testing.transactional.void.method.return.type.error.message", new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
        }
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringTestingTransactionalInspection" == null) {
            SpringTestingTransactionalInspection.$$$reportNull$$$0(5);
        }
        return "SpringTestingTransactionalInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "manager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/jam/testContexts/SpringTestingTransactionalInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/jam/testContexts/SpringTestingTransactionalInspection";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkClass";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkLifecycleTransactionMethod";
                break;
            }
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

