/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiNameHelper;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.values.converters.FieldRetrievingFactoryBeanConverterImpl;
import com.intellij.spring.model.xml.beans.Alias;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringBeanNameConventionInspection
extends SpringBeanInspectionBase {
    @NotNull
    @NonNls
    public String getShortName() {
        if ("SpringBeanNameConventionInspection" == null) {
            SpringBeanNameConventionInspection.$$$reportNull$$$0(0);
        }
        return "SpringBeanNameConventionInspection";
    }

    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel springModel) {
        GenericAttributeValue springBeanId;
        if (springBean == null) {
            SpringBeanNameConventionInspection.$$$reportNull$$$0(1);
        }
        if (beans == null) {
            SpringBeanNameConventionInspection.$$$reportNull$$$0(2);
        }
        if (holder == null) {
            SpringBeanNameConventionInspection.$$$reportNull$$$0(3);
        }
        if (!DomUtil.hasXml((DomElement)(springBeanId = springBean.getId()))) {
            return;
        }
        String beanId = springBeanId.getStringValue();
        if (SpringBeanNameConventionInspection.acceptBean(springBean, beanId)) {
            SpringBeanNameConventionInspection.checkName((DomElement)springBeanId, beanId, holder);
        }
    }

    private static boolean acceptBean(SpringBean springBean, String beanId) {
        return !StringUtil.isEmpty((String)beanId) && !SpringBeanNameConventionInspection.hasSymbols(beanId, ".") && !SpringBeanNameConventionInspection.hasSymbols(beanId, "-") && (!FieldRetrievingFactoryBeanConverterImpl.isFieldRetrievingFactoryBean((CommonSpringBean)springBean) || !FieldRetrievingFactoryBeanConverterImpl.isResolved(springBean.getManager().getProject(), beanId));
    }

    private static boolean hasSymbols(@NotNull String beanId, @NotNull String smb) {
        if (beanId == null) {
            SpringBeanNameConventionInspection.$$$reportNull$$$0(4);
        }
        if (smb == null) {
            SpringBeanNameConventionInspection.$$$reportNull$$$0(5);
        }
        if (!beanId.contains(smb)) {
            return false;
        }
        for (String s : StringUtil.split((String)beanId, (String)smb, (boolean)true, (boolean)false)) {
            if (!StringUtil.isEmptyOrSpaces((String)s)) continue;
            return false;
        }
        return true;
    }

    private static void checkAlias(Alias alias, DomElementAnnotationHolder holder) {
        String aliasName = alias.getAlias().getStringValue();
        SpringBeanNameConventionInspection.checkName((DomElement)alias.getAlias(), aliasName, holder);
    }

    private static void checkName(DomElement domElement, @NotNull String name, DomElementAnnotationHolder holder) {
        boolean keyword;
        PsiNameHelper psiNameHelper;
        boolean identifier;
        if (name == null) {
            SpringBeanNameConventionInspection.$$$reportNull$$$0(6);
        }
        if (!(identifier = (psiNameHelper = PsiNameHelper.getInstance((Project)domElement.getManager().getProject())).isIdentifier(name)) && !(keyword = psiNameHelper.isKeyword(name))) {
            holder.createProblem(domElement, SpringBundle.message("model.inspection.invalid.identifier.message", name), new LocalQuickFix[0]);
        }
        if (Character.isUpperCase(name.charAt(0))) {
            holder.createProblem(domElement, SpringBundle.message("model.inspection.invalid.lowercase.name.message", name), new LocalQuickFix[0]);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/xml/SpringBeanNameConventionInspection";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanId";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "smb";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/xml/SpringBeanNameConventionInspection";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "checkBean";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasSymbols";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "checkName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

