/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.autowire.xml;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.highlighting.dom.SpringBeanInspectionBase;
import com.intellij.spring.model.highlighting.xml.SpringConstructorArgResolveUtil;
import com.intellij.spring.model.utils.SpringAutowireUtil;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.SpringModelElement;
import com.intellij.spring.model.xml.beans.Autowire;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.ConstructorArg;
import com.intellij.spring.model.xml.beans.DefaultableBoolean;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringProperty;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.highlighting.DomElementAnnotationHolder;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringXmlAutowireExplicitlyInspection
extends SpringBeanInspectionBase {
    public void checkFileElement(DomFileElement<Beans> domFileElement, DomElementAnnotationHolder holder) {
        super.checkFileElement(domFileElement, holder);
        Beans beans = (Beans)domFileElement.getRootElement();
        GenericAttributeValue defaultAutowireAttribute = beans.getDefaultAutowire();
        Autowire defaultAutowire = (Autowire)defaultAutowireAttribute.getValue();
        if (defaultAutowire != null && !Autowire.NO.equals((Object)defaultAutowire)) {
            holder.createProblem((DomElement)defaultAutowireAttribute, HighlightSeverity.WARNING, SpringBundle.message("spring.bean.autowire.escape", new Object[0]), new LocalQuickFix[]{SpringXmlAutowireExplicitlyInspection.createDefaultAutowireEscapeQuickFixes((Beans)beans.createStableCopy(), defaultAutowire)});
        }
    }

    private static LocalQuickFix createDefaultAutowireEscapeQuickFixes(final Beans beans, final Autowire defaultAutowire) {
        return new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("spring.bean.autowire.escape", new Object[0]);
                if (string == null) {
                    1.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    1.$$$reportNull$$$0(2);
                }
                if (!beans.isValid()) {
                    return;
                }
                UsageTrigger.trigger((String)"spring.DefaultAutowireEscapeQuickFix");
                new WriteCommandAction.Simple(project, new PsiFile[]{DomUtil.getFile((DomElement)beans)}){

                    protected void run() {
                        for (SpringBean bean : beans.getBeans()) {
                            Autowire autowire;
                            if (!SpringXmlAutowireExplicitlyInspection.isAutowireCandidate(bean) || (autowire = (Autowire)bean.getAutowire().getValue()) != null && !autowire.getValue().equals(defaultAutowire.getValue()) && !autowire.equals((Object)Autowire.DEFAULT)) continue;
                            SpringXmlAutowireExplicitlyInspection.escapeAutowire(defaultAutowire.getValue(), bean);
                        }
                        beans.getDefaultAutowire().undefine();
                    }
                }.execute();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/xml/SpringXmlAutowireExplicitlyInspection$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/xml/SpringXmlAutowireExplicitlyInspection$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    protected void checkBean(@NotNull SpringBean springBean, @NotNull Beans beans, @NotNull DomElementAnnotationHolder holder, @Nullable CommonSpringModel model) {
        if (springBean == null) {
            SpringXmlAutowireExplicitlyInspection.$$$reportNull$$$0(0);
        }
        if (beans == null) {
            SpringXmlAutowireExplicitlyInspection.$$$reportNull$$$0(1);
        }
        if (holder == null) {
            SpringXmlAutowireExplicitlyInspection.$$$reportNull$$$0(2);
        }
        if (SpringXmlAutowireExplicitlyInspection.isAutowireCandidate(springBean)) {
            SpringXmlAutowireExplicitlyInspection.addAutowireEscapeWarning(springBean, holder);
        }
    }

    private static boolean isAutowireCandidate(SpringBean springBean) {
        DefaultableBoolean autoWireCandidate = (DefaultableBoolean)springBean.getAutowireCandidate().getValue();
        return autoWireCandidate == null || autoWireCandidate.getBooleanValue() != false;
    }

    private static void addAutowireEscapeWarning(SpringBean springBean, DomElementAnnotationHolder holder) {
        Autowire autowire = (Autowire)springBean.getAutowire().getValue();
        if (autowire != null && !Autowire.NO.equals((Object)autowire)) {
            holder.createProblem((DomElement)springBean.getAutowire(), HighlightSeverity.WARNING, SpringBundle.message("spring.bean.use.autowire", new Object[0]), new LocalQuickFix[]{SpringXmlAutowireExplicitlyInspection.createEscapeAutowireQuickFixes((SpringBean)springBean.createStableCopy(), autowire)});
        }
    }

    private static LocalQuickFix createEscapeAutowireQuickFixes(final SpringBean springBean, final @NotNull Autowire autowire) {
        if (autowire == null) {
            SpringXmlAutowireExplicitlyInspection.$$$reportNull$$$0(3);
        }
        return new LocalQuickFix(){

            @NotNull
            public String getFamilyName() {
                String string = SpringBundle.message("spring.bean.autowire.escape", new Object[0]);
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (descriptor == null) {
                    2.$$$reportNull$$$0(2);
                }
                if (!springBean.isValid()) {
                    return;
                }
                UsageTrigger.trigger((String)"spring.EscapeAutowireQuickFix");
                new WriteCommandAction.Simple(springBean.getManager().getProject(), new PsiFile[]{DomUtil.getFile((DomElement)springBean)}){

                    protected void run() throws Throwable {
                        SpringXmlAutowireExplicitlyInspection.escapeAutowire(autowire.getValue(), springBean);
                    }
                }.execute();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                RuntimeException runtimeException;
                Object[] objectArray;
                Object[] objectArray2;
                int n2;
                String string;
                switch (n) {
                    default: {
                        string = "@NotNull method %s.%s must not return null";
                        break;
                    }
                    case 1: 
                    case 2: {
                        string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        n2 = 2;
                        break;
                    }
                    case 1: 
                    case 2: {
                        n2 = 3;
                        break;
                    }
                }
                Object[] objectArray3 = new Object[n2];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/xml/SpringXmlAutowireExplicitlyInspection$2";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "project";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "descriptor";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getFamilyName";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/xml/SpringXmlAutowireExplicitlyInspection$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "applyFix";
                        break;
                    }
                }
                String string2 = String.format(string, objectArray);
                switch (n) {
                    default: {
                        runtimeException = new IllegalStateException(string2);
                        break;
                    }
                    case 1: 
                    case 2: {
                        runtimeException = new IllegalArgumentException(string2);
                        break;
                    }
                }
                throw runtimeException;
            }
        };
    }

    private static void escapeAutowire(@NotNull String autowire, SpringBean springBean) {
        if (autowire == null) {
            SpringXmlAutowireExplicitlyInspection.$$$reportNull$$$0(4);
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getSpringModel((SpringModelElement)springBean);
        if (autowire.equals(Autowire.BY_TYPE.getValue())) {
            SpringXmlAutowireExplicitlyInspection.escapeByTypeAutowire(springBean, model);
        } else if (autowire.equals(Autowire.BY_NAME.getValue())) {
            SpringXmlAutowireExplicitlyInspection.escapeByNameAutowire(springBean);
        } else if (autowire.equals(Autowire.CONSTRUCTOR.getValue())) {
            SpringXmlAutowireExplicitlyInspection.escapeConstructorAutowire(springBean, model);
        } else if (autowire.equals(Autowire.AUTODETECT.getValue())) {
            if (SpringConstructorArgResolveUtil.hasEmptyConstructor(springBean) && !SpringConstructorArgResolveUtil.isInstantiatedByFactory(springBean)) {
                SpringXmlAutowireExplicitlyInspection.escapeByTypeAutowire(springBean, model);
            } else {
                SpringXmlAutowireExplicitlyInspection.escapeConstructorAutowire(springBean, model);
            }
        }
    }

    private static void escapeConstructorAutowire(SpringBean springBean, CommonSpringModel model) {
        Map<PsiType, Collection<SpringBeanPointer>> map = SpringAutowireUtil.getConstructorAutowiredProperties(springBean, model);
        for (PsiType psiType : map.keySet()) {
            ConstructorArg arg = springBean.addConstructorArg();
            arg.getType().setStringValue(psiType.getCanonicalText());
            arg.getRefAttr().setStringValue(SpringXmlAutowireExplicitlyInspection.chooseReferencedBeanName(map.get(psiType)));
        }
        springBean.getAutowire().undefine();
    }

    private static void escapeByNameAutowire(SpringBean springBean) {
        Map<PsiMethod, SpringBeanPointer> autowiredProperties = SpringAutowireUtil.getByNameAutowiredProperties(springBean);
        for (PsiMethod psiMethod : autowiredProperties.keySet()) {
            SpringProperty springProperty = springBean.addProperty();
            SpringBeanPointer autowiredBean = autowiredProperties.get(psiMethod);
            String refBeanName = autowiredBean != null && autowiredBean.getName() != null ? autowiredBean.getName() : "";
            springProperty.getName().setStringValue(PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod));
            springProperty.getRefAttr().setStringValue(refBeanName);
        }
        springBean.getAutowire().undefine();
    }

    private static void escapeByTypeAutowire(SpringBean springBean, CommonSpringModel model) {
        Map<PsiMethod, Collection<SpringBeanPointer>> autowiredProperties = SpringAutowireUtil.getByTypeAutowiredProperties(springBean, model);
        for (PsiMethod psiMethod : autowiredProperties.keySet()) {
            SpringProperty springProperty = springBean.addProperty();
            springProperty.getName().setStringValue(PropertyUtilBase.getPropertyNameBySetter((PsiMethod)psiMethod));
            springProperty.getRefAttr().setStringValue(SpringXmlAutowireExplicitlyInspection.chooseReferencedBeanName(autowiredProperties.get(psiMethod)));
        }
        springBean.getAutowire().undefine();
    }

    @NotNull
    private static String chooseReferencedBeanName(Collection<SpringBeanPointer> autowiredBeans) {
        if (autowiredBeans != null) {
            for (SpringBeanPointer autowiredBean : autowiredBeans) {
                CommonSpringModel model;
                String beanName = SpringBeanCoreUtils.getReferencedName(autowiredBean, (model = SpringModelUtils.getInstance().getSpringModelByBean(autowiredBean.getSpringBean())).getAllCommonBeans());
                if (beanName == null || beanName.trim().length() <= 0) continue;
                String string = beanName;
                if (string == null) {
                    SpringXmlAutowireExplicitlyInspection.$$$reportNull$$$0(5);
                }
                return string;
            }
        }
        if ("" == null) {
            SpringXmlAutowireExplicitlyInspection.$$$reportNull$$$0(6);
        }
        return "";
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("SpringXmlAutowireExplicitlyInspection" == null) {
            SpringXmlAutowireExplicitlyInspection.$$$reportNull$$$0(7);
        }
        return "SpringXmlAutowireExplicitlyInspection";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "springBean";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beans";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "autowire";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/autowire/xml/SpringXmlAutowireExplicitlyInspection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/autowire/xml/SpringXmlAutowireExplicitlyInspection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "chooseReferencedBeanName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "checkBean";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createEscapeAutowireQuickFixes";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "escapeAutowire";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

