/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters.fixes.bean;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClassType;
import com.intellij.spring.model.converters.fixes.bean.CustomNamespaceSpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.converters.fixes.bean.GenericSpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.converters.fixes.bean.ParseCustomBeanQuickFixProvider;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixManager;
import com.intellij.spring.model.converters.fixes.bean.SpringBeanResolveQuickFixProvider;
import com.intellij.spring.model.converters.fixes.bean.UseExistingBeanQuickFixProvider;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.SmartList;
import com.intellij.util.xml.ConvertContext;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class SpringBeanResolveQuickFixManagerImpl
extends SpringBeanResolveQuickFixManager {
    private static final SpringBeanResolveQuickFixProvider[] PROVIDERS = new SpringBeanResolveQuickFixProvider[]{new CustomNamespaceSpringBeanResolveQuickFixProvider(), new GenericSpringBeanResolveQuickFixProvider(), new ParseCustomBeanQuickFixProvider(), new UseExistingBeanQuickFixProvider()};

    public LocalQuickFix[] getQuickFixes(ConvertContext context, @Nullable Beans beans, String beanId, List<PsiClassType> requiredClasses) {
        if (beans == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        SmartList fixes = new SmartList();
        for (SpringBeanResolveQuickFixProvider provider : PROVIDERS) {
            fixes.addAll(provider.getQuickFixes(context, beans, beanId, requiredClasses));
        }
        return fixes.toArray(new LocalQuickFix[fixes.size()]);
    }
}

