/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.converters;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.converters.SpringBeanNamesConverter;
import com.intellij.spring.model.converters.SpringConverterUtil;
import com.intellij.spring.model.utils.SpringBeanCoreUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpringBeanNamesConverterImpl
extends SpringBeanNamesConverter {
    public String toString(List<String> strings, ConvertContext context) {
        return StringUtil.join(strings, (String)",");
    }

    public List<String> fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return SpringCommonUtils.tokenize((String)s);
    }

    @NotNull
    public PsiReference[] createReferences(final GenericDomValue<List<String>> genericDomValue, final PsiElement element, final ConvertContext context) {
        List strings = (List)genericDomValue.getValue();
        if (strings != null) {
            ArrayList<1> references = new ArrayList<1>(strings.size());
            for (String string : strings) {
                int offset = element.getText().indexOf(string);
                if (offset < 0) continue;
                references.add(new PsiReferenceBase<PsiElement>(element, TextRange.from((int)offset, (int)string.length())){

                    public PsiElement resolve() {
                        SpringBean bean = (SpringBean)genericDomValue.getParent();
                        assert (bean != null);
                        return BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)bean).getPsiElement();
                    }

                    public boolean isSoft() {
                        return true;
                    }

                    @NotNull
                    public Object[] getVariants() {
                        Object[] objectArray = SpringBeanCoreUtils.suggestBeanNames((CommonSpringBean)SpringConverterUtil.getCurrentBean((ConvertContext)context));
                        if (objectArray == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return objectArray;
                    }

                    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                        SpringBean bean = (SpringBean)genericDomValue.getParent();
                        assert (bean != null);
                        bean.setName(newElementName);
                        return element;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanNamesConverterImpl$1", "getVariants"));
                    }
                });
            }
            PsiReference[] psiReferenceArray = references.toArray(new PsiReference[references.size()]);
            if (psiReferenceArray == null) {
                SpringBeanNamesConverterImpl.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            SpringBeanNamesConverterImpl.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/converters/SpringBeanNamesConverterImpl", "createReferences"));
    }
}

