/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks.util;

import com.intellij.facet.frameworks.LibrariesDownloadAssistant;
import com.intellij.facet.frameworks.beans.Artifact;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.Disposable;
import com.intellij.spring.model.actions.patterns.frameworks.util.LibrariesConfigurationManager;
import com.intellij.util.containers.HashMap;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class LibrariesConfigurationManagerImpl
extends LibrariesConfigurationManager
implements Disposable {
    private static final String[] LIBRARIES = new String[]{"hibernate", "ibatis", "jdo", "jpa", "quartz", "toplink"};
    @NonNls
    private static final String RESOURCES_PATH = "/resources/frameworks/";
    private final Map<String, List<LibraryInfo>> myLibraries = new HashMap();

    public LibrariesConfigurationManagerImpl() {
        for (String library : LIBRARIES) {
            URL url = LibrariesConfigurationManagerImpl.createUrl(library);
            Artifact[] versions = LibrariesDownloadAssistant.getVersions((URL[])new URL[]{url});
            if (versions.length <= 0) continue;
            Artifact version = versions[versions.length - 1];
            this.myLibraries.put(library, Arrays.asList(LibrariesDownloadAssistant.getLibraryInfos((Artifact)version)));
        }
    }

    private static URL createUrl(String library) {
        return LibrariesConfigurationManagerImpl.class.getResource(RESOURCES_PATH + library + ".xml");
    }

    @Nullable
    public LibraryInfo[] getLibraryInfos(String frameworkId) {
        List<LibraryInfo> libraryInfos = this.myLibraries.get(frameworkId);
        return libraryInfos == null ? LibraryInfo.EMPTY_ARRAY : libraryInfos.toArray(new LibraryInfo[libraryInfos.size()]);
    }

    public void dispose() {
    }
}

