/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns.frameworks;

import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.facet.ui.libraries.LibraryInfo;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.model.actions.patterns.PatternIcons;
import com.intellij.spring.model.actions.patterns.frameworks.AbstractFrameworkIntegrationAction;
import com.intellij.spring.model.actions.patterns.frameworks.ui.LibrariesInfo;
import com.intellij.spring.model.actions.patterns.frameworks.ui.TemplateInfo;
import com.intellij.spring.model.actions.patterns.frameworks.util.LibrariesConfigurationManager;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class AddToplinkAction
extends AbstractFrameworkIntegrationAction {
    @NonNls
    private static final String TOPLINK_STRING_ID = "toplink";

    protected String[] getBeansClassNames() {
        return new String[]{"org.springframework.orm.toplink.LocalSessionFactoryBean"};
    }

    public LibrariesInfo getLibrariesInfo(Module module) {
        LibraryInfo[] libraryInfos = LibrariesConfigurationManager.getInstance((Project)module.getProject()).getLibraryInfos(TOPLINK_STRING_ID);
        return new LibrariesInfo(libraryInfos, module, TOPLINK_STRING_ID);
    }

    public List<TemplateInfo> getTemplateInfos(Module module) {
        LinkedList<TemplateInfo> infos = new LinkedList<TemplateInfo>();
        TemplateSettings settings = TemplateSettings.getInstance();
        TemplateInfo datasource = new TemplateInfo(module, settings.getTemplateById("datasource"), SpringBundle.message("spring.patterns.data.access.data.source", new Object[0]), null, false);
        TemplateInfo sf = new TemplateInfo(module, settings.getTemplateById("toplink-session-factory"), SpringBundle.message("spring.patterns.data.access.toplink.session.factory", new Object[0]), null);
        TemplateInfo sfa = new TemplateInfo(module, settings.getTemplateById("toplink-session-adapter"), SpringBundle.message("spring.patterns.data.access.toplink.transaction.aware.session.adapter", new Object[0]), null, false);
        TemplateInfo ttm = new TemplateInfo(module, settings.getTemplateById("toplink-transaction-manager"), SpringBundle.message("spring.patterns.data.access.toplink.transaction.manager", new Object[0]), null);
        infos.add(datasource);
        infos.add(sf);
        infos.add(sfa);
        infos.add(ttm);
        return infos;
    }

    public String getDescription() {
        return SpringBundle.message("spring.patterns.toplink", new Object[0]);
    }

    @Nullable
    protected Icon getIcon() {
        return PatternIcons.TOPLINK_ICON;
    }
}

