/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions.patterns;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.dom.SpringDomUtils;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSpringConfigActionGroup
extends DefaultActionGroup {
    public AbstractSpringConfigActionGroup() {
        this.setPopup(true);
    }

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        DataContext dataContext = event.getDataContext();
        Project project = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (project == null || editor == null) {
            presentation.setVisible(false);
            return;
        }
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(editor.getDocument());
        boolean enabled = file instanceof XmlFile && SpringDomUtils.isSpringXml((XmlFile)((XmlFile)file)) && AbstractSpringConfigActionGroup.isInsideRootTag(editor, (XmlFile)file);
        presentation.setEnabled(enabled);
        presentation.setVisible(enabled);
        if (enabled) {
            event.getPresentation().setText(this.getDescription());
            event.getPresentation().setIcon(this.getIcon());
        }
    }

    private static boolean isInsideRootTag(Editor editor, XmlFile xmlFile) {
        TextRange textRange;
        XmlTag tag;
        XmlDocument document = xmlFile.getDocument();
        return document != null && (tag = document.getRootTag()) != null && (textRange = tag.getTextRange()).contains(editor.getCaretModel().getOffset());
    }

    @Nullable
    protected Icon getIcon() {
        return null;
    }

    protected abstract String getDescription();
}

