/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.DerivedSpringBeanPointer;
import com.intellij.spring.model.SpringBeanPointer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SpringBaseBeanPointer<T extends CommonSpringBean>
implements SpringBeanPointer<T> {
    private final String myName;
    private final Project myProject;
    private CachedValue<PsiType[]> effectiveTypesValue;
    private final VolatileNotNullLazyValue<String[]> myAliases;

    protected SpringBaseBeanPointer(@Nullable String name, @NotNull Project project) {
        if (project == null) {
            SpringBaseBeanPointer.$$$reportNull$$$0(0);
        }
        this.myAliases = new VolatileNotNullLazyValue<String[]>(){

            @NotNull
            protected String[] compute() {
                String[] stringArray = SpringBaseBeanPointer.this.getSpringBean().getAliases();
                if (stringArray == null) {
                    1.$$$reportNull$$$0(0);
                }
                return stringArray;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/SpringBaseBeanPointer$1", "compute"));
            }
        };
        this.myName = name;
        this.myProject = project;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    public PsiType[] getEffectiveBeanTypes() {
        if (this.effectiveTypesValue == null) {
            this.effectiveTypesValue = CachedValuesManager.getManager((Project)this.myProject).createCachedValue(() -> {
                PsiType[] types = BeanService.getInstance().getEffectiveBeanTypes(this.getSpringBean());
                return CachedValueProvider.Result.createSingleDependency((Object)types, (Object)PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT);
            }, false);
        }
        return (PsiType[])this.effectiveTypesValue.getValue();
    }

    public String[] getAliases() {
        return (String[])this.myAliases.getValue();
    }

    @NotNull
    public SpringBeanPointer getBasePointer() {
        SpringBaseBeanPointer springBaseBeanPointer = this;
        if (springBaseBeanPointer == null) {
            SpringBaseBeanPointer.$$$reportNull$$$0(1);
        }
        return springBaseBeanPointer;
    }

    public SpringBeanPointer derive(@NotNull String name) {
        if (name == null) {
            SpringBaseBeanPointer.$$$reportNull$$$0(2);
        }
        return Comparing.equal((String)name, (String)this.getName()) ? this : new DerivedSpringBeanPointer(this, name);
    }

    public boolean isReferenceTo(@Nullable CommonSpringBean springBean) {
        if (springBean == null) {
            return false;
        }
        PsiFile file = springBean.getContainingFile();
        return file.equals(this.getContainingFile()) && springBean.equals(this.getSpringBean());
    }

    public boolean isAbstract() {
        return false;
    }

    @Nullable
    public SpringBeanPointer getParentPointer() {
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SpringBeanPointer)) {
            return false;
        }
        SpringBeanPointer that = (SpringBeanPointer)o;
        return Comparing.equal((String)this.myName, (String)that.getName()) && Comparing.equal((Object)this.getPsiElement(), (Object)that.getPsiElement());
    }

    public int hashCode() {
        return this.myName != null ? this.myName.hashCode() : 0;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.myName + "]";
    }

    protected Project getProject() {
        return this.myProject;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/SpringBaseBeanPointer";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/SpringBaseBeanPointer";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBasePointer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "derive";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

