/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model.diagram.extras;

import com.intellij.diagram.DiagramBuilder;
import com.intellij.diagram.DiagramColorManagerBase;
import com.intellij.diagram.DiagramEdge;
import com.intellij.diagram.DiagramNode;
import com.intellij.openapi.project.Project;
import com.intellij.spring.contexts.model.diagram.beans.SpringLocalModelDependencyEdge;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.ui.JBColor;
import java.awt.Color;
import org.jetbrains.annotations.Nullable;

public class SpringLocalModelsDiagramColorManager
extends DiagramColorManagerBase {
    private static final Color IMPORT_COLOR = JBColor.green.darker();
    private static final Color SCAN_COLOR = JBColor.blue.darker();
    private static final Color ENABLE_COLOR = JBColor.orange;
    private static final Color ERROR_COLOR = JBColor.red.darker();

    public Color getNodeHeaderColor(DiagramBuilder builder, @Nullable DiagramNode node) {
        return JBColor.background();
    }

    public Color getNodeBackground(Project project, Object nodeElement, boolean selected) {
        return JBColor.background();
    }

    public Color getEdgeColor(DiagramEdge edge) {
        if (edge instanceof SpringLocalModelDependencyEdge) {
            if (((SpringLocalModelDependencyEdge)edge).isError()) {
                return ERROR_COLOR;
            }
            LocalModelDependencyType type = ((SpringLocalModelDependencyEdge)edge).getDependency().getType();
            switch (type) {
                case IMPORT: {
                    return IMPORT_COLOR;
                }
                case COMPONENT_SCAN: {
                    return SCAN_COLOR;
                }
                case ENABLE_ANNO: {
                    return ENABLE_COLOR;
                }
            }
        }
        return super.getEdgeColor(edge);
    }
}

