/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.testFramework.PsiTestCase;
import com.intellij.testFramework.VfsTestUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ResolveTestCase
extends PsiTestCase {
    protected static final String MARKER = "<ref>";
    private Document myDocument;

    @Override
    protected void tearDown() throws Exception {
        if (this.myDocument != null) {
            FileDocumentManager.getInstance().reloadFromDisk(this.myDocument);
            this.myDocument = null;
        }
        super.tearDown();
    }

    protected PsiReference configureByFile(@NotNull String filePath2) throws Exception {
        if (filePath2 == null) {
            ResolveTestCase.$$$reportNull$$$0(0);
        }
        return this.configureByFile(filePath2, null);
    }

    protected PsiReference configureByFile(@NotNull String filePath2, @Nullable VirtualFile parentDir) throws Exception {
        if (filePath2 == null) {
            ResolveTestCase.$$$reportNull$$$0(1);
        }
        VirtualFile vFile = VfsTestUtil.findFileByCaseSensitivePath((String)(this.getTestDataPath() + filePath2));
        ResolveTestCase.assertNotNull((String)("file " + filePath2 + " not found"), (Object)vFile);
        String fileText = StringUtil.convertLineSeparators((String)VfsUtilCore.loadText(vFile));
        return this.configureByFileText(fileText, vFile.getName(), parentDir);
    }

    protected PsiReference configureByFileText(String fileText, String fileName) throws Exception {
        return this.configureByFileText(fileText, fileName, null);
    }

    protected PsiReference configureByFileText(String fileText, String fileName, @Nullable VirtualFile parentDir) throws Exception {
        int offset = fileText.indexOf(MARKER);
        ResolveTestCase.assertTrue((String)String.format("Expected to find %s marker in file but was none", MARKER), (offset >= 0 ? 1 : 0) != 0);
        fileText = fileText.substring(0, offset) + fileText.substring(offset + MARKER.length());
        if (parentDir == null) {
            this.myFile = this.createFile(this.myModule, fileName, fileText);
        } else {
            VirtualFile existing = parentDir.findChild(fileName);
            if (existing != null) {
                this.myDocument = FileDocumentManager.getInstance().getDocument(existing);
                ResolveTestCase.assertNotNull((Object)this.myDocument);
                String finalFileText = fileText;
                ApplicationManager.getApplication().runWriteAction(() -> this.myDocument.setText(finalFileText));
                this.myFile = PsiManager.getInstance(this.getProject()).findFile(existing);
                ResolveTestCase.assertNotNull((Object)this.myFile);
                ResolveTestCase.assertEquals((String)fileText, (String)this.myFile.getText());
            } else {
                this.myFile = this.createFile(this.myModule, parentDir, fileName, fileText);
            }
        }
        PsiReference ref = this.myFile.findReferenceAt(offset);
        ResolveTestCase.assertNotNull((Object)ref);
        return ref;
    }

    @Override
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/psi/resolve/";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePath", "com/intellij/testFramework/ResolveTestCase", "configureByFile"));
    }
}

