/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiIntersectionType;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import gnu.trove.THashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiTypesUtil {
    @NonNls
    private static final Map<String, String> ourUnboxedTypes = new THashMap();
    @NonNls
    private static final Map<String, String> ourBoxedTypes = new THashMap();
    @NonNls
    private static final String GET_CLASS_METHOD = "getClass";

    private PsiTypesUtil() {
    }

    public static Object getDefaultValue(PsiType type) {
        if (!(type instanceof PsiPrimitiveType)) {
            return null;
        }
        switch (type.getCanonicalText()) {
            case "boolean": {
                return false;
            }
            case "byte": {
                return (byte)0;
            }
            case "char": {
                return Character.valueOf('\u0000');
            }
            case "short": {
                return (short)0;
            }
            case "int": {
                return 0;
            }
            case "long": {
                return 0L;
            }
            case "float": {
                return Float.valueOf(0.0f);
            }
            case "double": {
                return 0.0;
            }
        }
        return null;
    }

    @NotNull
    public static String getDefaultValueOfType(PsiType type) {
        String string = PsiTypesUtil.getDefaultValueOfType(type, false);
        if (string == null) {
            PsiTypesUtil.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public static String getDefaultValueOfType(PsiType type, boolean customDefaultValues) {
        if (type instanceof PsiArrayType) {
            PsiClassType classType;
            int count = type.getArrayDimensions() - 1;
            PsiType componentType = type.getDeepComponentType();
            if (componentType instanceof PsiClassType && (classType = (PsiClassType)componentType).resolve() instanceof PsiTypeParameter) {
                if ("null" == null) {
                    PsiTypesUtil.$$$reportNull$$$0(1);
                }
                return "null";
            }
            PsiType erasedComponentType = TypeConversionUtil.erasure(componentType);
            StringBuilder buffer = new StringBuilder();
            buffer.append("new");
            buffer.append(" ");
            buffer.append(erasedComponentType.getCanonicalText());
            buffer.append("[0]");
            for (int i = 0; i < count; ++i) {
                buffer.append("[]");
            }
            String string = buffer.toString();
            if (string == null) {
                PsiTypesUtil.$$$reportNull$$$0(2);
            }
            return string;
        }
        if (type instanceof PsiPrimitiveType) {
            String string = PsiType.BOOLEAN.equals(type) ? "false" : "0";
            if (string == null) {
                PsiTypesUtil.$$$reportNull$$$0(3);
            }
            return string;
        }
        if (customDefaultValues) {
            PsiClassType rawType;
            PsiClassType psiClassType = rawType = type instanceof PsiClassType ? ((PsiClassType)type).rawType() : null;
            if (rawType != null && rawType.equalsToText("java.util.Optional")) {
                if ("java.util.Optional.empty()" == null) {
                    PsiTypesUtil.$$$reportNull$$$0(4);
                }
                return "java.util.Optional.empty()";
            }
        }
        if ("null" == null) {
            PsiTypesUtil.$$$reportNull$$$0(5);
        }
        return "null";
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String unboxIfPossible(String type) {
        if (type == null) {
            return null;
        }
        String s = ourUnboxedTypes.get(type);
        return s == null ? type : s;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    public static String boxIfPossible(String type) {
        if (type == null) {
            return null;
        }
        String s = ourBoxedTypes.get(type);
        return s == null ? type : s;
    }

    @Nullable
    public static PsiClass getPsiClass(@Nullable PsiType psiType) {
        return psiType instanceof PsiClassType ? ((PsiClassType)psiType).resolve() : null;
    }

    public static PsiClassType getClassType(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            PsiTypesUtil.$$$reportNull$$$0(6);
        }
        return JavaPsiFacade.getElementFactory(psiClass.getProject()).createType(psiClass);
    }

    @Nullable
    public static PsiClassType getLowestUpperBoundClassType(@NotNull PsiDisjunctionType type) {
        PsiType lub;
        if (type == null) {
            PsiTypesUtil.$$$reportNull$$$0(7);
        }
        if ((lub = type.getLeastUpperBound()) instanceof PsiClassType) {
            return (PsiClassType)lub;
        }
        if (lub instanceof PsiIntersectionType) {
            for (PsiType subType : ((PsiIntersectionType)lub).getConjuncts()) {
                PsiClass aClass;
                if (!(subType instanceof PsiClassType) || (aClass = ((PsiClassType)subType).resolve()) == null || aClass.isInterface()) continue;
                return (PsiClassType)subType;
            }
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiMethodReferenceExpression methodExpression, @NotNull PsiMethod method) {
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(8);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(9);
        }
        if (PsiTypesUtil.isGetClass(method)) {
            PsiType qualifierType = PsiMethodReferenceUtil.getQualifierType(methodExpression);
            return qualifierType != null ? PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true) : null;
        }
        return null;
    }

    public static PsiType patchMethodGetClassReturnType(@NotNull PsiExpression call, @NotNull PsiReferenceExpression methodExpression, @NotNull PsiMethod method, @Nullable Condition<IElementType> condition2, @NotNull LanguageLevel languageLevel) {
        if (call == null) {
            PsiTypesUtil.$$$reportNull$$$0(10);
        }
        if (methodExpression == null) {
            PsiTypesUtil.$$$reportNull$$$0(11);
        }
        if (method == null) {
            PsiTypesUtil.$$$reportNull$$$0(12);
        }
        if (languageLevel == null) {
            PsiTypesUtil.$$$reportNull$$$0(13);
        }
        if (languageLevel.isAtLeast(LanguageLevel.JDK_1_5) && PsiTypesUtil.isGetClass(method)) {
            PsiExpression qualifier = methodExpression.getQualifierExpression();
            PsiType qualifierType = null;
            Project project = call.getProject();
            if (qualifier != null) {
                qualifierType = TypeConversionUtil.erasure(qualifier.getType());
            } else if (condition2 != null) {
                ASTNode parent;
                for (parent = call.getNode().getTreeParent(); parent != null && condition2.value((Object)parent.getElementType()); parent = parent.getTreeParent()) {
                }
                if (parent != null) {
                    qualifierType = JavaPsiFacade.getInstance(project).getElementFactory().createType((PsiClass)parent.getPsi());
                }
            }
            return PsiTypesUtil.createJavaLangClassType(methodExpression, qualifierType, true);
        }
        return null;
    }

    public static boolean isGetClass(PsiMethod method) {
        if (GET_CLASS_METHOD.equals(method.getName())) {
            PsiClass aClass = method.getContainingClass();
            return aClass != null && "java.lang.Object".equals(aClass.getQualifiedName());
        }
        return false;
    }

    @Nullable
    public static PsiType createJavaLangClassType(@NotNull PsiElement context, @Nullable PsiType qualifierType, boolean captureTopLevelWildcards) {
        if (context == null) {
            PsiTypesUtil.$$$reportNull$$$0(14);
        }
        if (qualifierType != null) {
            PsiUtil.ensureValidType(qualifierType);
            JavaPsiFacade facade = JavaPsiFacade.getInstance(context.getProject());
            PsiClass javaLangClass = facade.findClass("java.lang.Class", context.getResolveScope());
            if (javaLangClass != null && javaLangClass.getTypeParameters().length == 1) {
                PsiSubstitutor substitutor = PsiSubstitutor.EMPTY.put(javaLangClass.getTypeParameters()[0], PsiWildcardType.createExtends(context.getManager(), qualifierType));
                PsiClassType classType = facade.getElementFactory().createType(javaLangClass, substitutor, PsiUtil.getLanguageLevel(context));
                return captureTopLevelWildcards ? PsiUtil.captureToplevelWildcards(classType, context) : classType;
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getExpectedTypeByParent(@NotNull PsiElement element) {
        PsiElement parent;
        if (element == null) {
            PsiTypesUtil.$$$reportNull$$$0(15);
        }
        if ((parent = PsiUtil.skipParenthesizedExprUp(element.getParent())) instanceof PsiVariable) {
            if (PsiUtil.checkSameExpression(element, ((PsiVariable)parent).getInitializer())) {
                PsiTypeElement typeElement = ((PsiVariable)parent).getTypeElement();
                if (typeElement != null && typeElement.isInferredType()) {
                    return null;
                }
                return ((PsiVariable)parent).getType();
            }
        } else if (parent instanceof PsiAssignmentExpression) {
            if (PsiUtil.checkSameExpression(element, ((PsiAssignmentExpression)parent).getRExpression())) {
                return ((PsiAssignmentExpression)parent).getLExpression().getType();
            }
        } else if (parent instanceof PsiReturnStatement) {
            Object psiElement = PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class, PsiMethod.class);
            if (psiElement instanceof PsiLambdaExpression) {
                return null;
            }
            if (psiElement instanceof PsiMethod) {
                return ((PsiMethod)psiElement).getReturnType();
            }
        } else {
            if (PsiUtil.isCondition(element, parent)) {
                return PsiType.BOOLEAN.getBoxedType(parent);
            }
            if (parent instanceof PsiArrayInitializerExpression) {
                PsiElement gParent = parent.getParent();
                if (gParent instanceof PsiNewExpression) {
                    PsiType type = ((PsiNewExpression)gParent).getType();
                    if (type instanceof PsiArrayType) {
                        return ((PsiArrayType)type).getComponentType();
                    }
                } else if (gParent instanceof PsiVariable) {
                    PsiType type = ((PsiVariable)gParent).getType();
                    if (type instanceof PsiArrayType) {
                        return ((PsiArrayType)type).getComponentType();
                    }
                } else if (gParent instanceof PsiArrayInitializerExpression) {
                    PsiType expectedTypeByParent = PsiTypesUtil.getExpectedTypeByParent(parent);
                    return expectedTypeByParent != null && expectedTypeByParent instanceof PsiArrayType ? ((PsiArrayType)expectedTypeByParent).getComponentType() : null;
                }
            }
        }
        return null;
    }

    @Nullable
    public static PsiType getMethodReturnType(PsiElement element) {
        Object methodOrLambda = PsiTreeUtil.getParentOfType(element, PsiMethod.class, PsiLambdaExpression.class);
        return methodOrLambda instanceof PsiMethod ? ((PsiMethod)methodOrLambda).getReturnType() : (methodOrLambda instanceof PsiLambdaExpression ? LambdaUtil.getFunctionalInterfaceReturnType((PsiLambdaExpression)methodOrLambda) : null);
    }

    public static boolean compareTypes(PsiType leftType, PsiType rightType, boolean ignoreEllipsis) {
        if (ignoreEllipsis) {
            if (leftType instanceof PsiEllipsisType) {
                leftType = ((PsiEllipsisType)leftType).toArrayType();
            }
            if (rightType instanceof PsiEllipsisType) {
                rightType = ((PsiEllipsisType)rightType).toArrayType();
            }
        }
        return Comparing.equal((Object)leftType, (Object)rightType);
    }

    public static boolean isDenotableType(PsiType type) {
        return !(type instanceof PsiWildcardType) && !(type instanceof PsiCapturedWildcardType);
    }

    public static boolean hasUnresolvedComponents(@NotNull PsiType type) {
        if (type == null) {
            PsiTypesUtil.$$$reportNull$$$0(16);
        }
        return type.accept(new PsiTypeVisitor<Boolean>(){

            @Override
            @Nullable
            public Boolean visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
                PsiClass psiClass = resolveResult.getElement();
                if (psiClass == null) {
                    return true;
                }
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                for (PsiTypeParameter param : PsiUtil.typeParametersIterable(psiClass)) {
                    PsiType psiType = substitutor.substitute(param);
                    if (psiType == null || !psiType.accept(this).booleanValue()) continue;
                    return true;
                }
                return (Boolean)super.visitClassType(classType);
            }

            @Override
            @Nullable
            public Boolean visitArrayType(PsiArrayType arrayType) {
                return arrayType.getComponentType().accept(this);
            }

            @Override
            @NotNull
            public Boolean visitWildcardType(PsiWildcardType wildcardType) {
                PsiType bound = wildcardType.getBound();
                Boolean bl = bound != null && bound.accept(this) != false;
                if (bl == null) {
                    1.$$$reportNull$$$0(0);
                }
                return bl;
            }

            @Override
            public Boolean visitType(PsiType type) {
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/PsiTypesUtil$1", "visitWildcardType"));
            }
        });
    }

    public static PsiType getParameterType(PsiParameter[] parameters, int i, boolean varargs) {
        PsiParameter parameter = parameters[i < parameters.length ? i : parameters.length - 1];
        PsiType parameterType = parameter.getType();
        if (parameterType instanceof PsiEllipsisType && varargs) {
            parameterType = ((PsiEllipsisType)parameterType).getComponentType();
        }
        if (!parameterType.isValid()) {
            PsiUtil.ensureValidType(parameterType, "Invalid type of parameter " + parameter + " of " + parameter.getClass());
        }
        return parameterType;
    }

    @NotNull
    public static PsiTypeParameter[] filterUnusedTypeParameters(@NotNull PsiTypeParameter[] typeParameters, PsiType ... types) {
        if (typeParameters == null) {
            PsiTypesUtil.$$$reportNull$$$0(17);
        }
        if (typeParameters.length == 0) {
            if (PsiTypeParameter.EMPTY_ARRAY == null) {
                PsiTypesUtil.$$$reportNull$$$0(18);
            }
            return PsiTypeParameter.EMPTY_ARRAY;
        }
        TypeParameterSearcher searcher = new TypeParameterSearcher();
        for (PsiType type : types) {
            type.accept(searcher);
        }
        PsiTypeParameter[] psiTypeParameterArray = searcher.getTypeParameters().toArray(PsiTypeParameter.EMPTY_ARRAY);
        if (psiTypeParameterArray == null) {
            PsiTypesUtil.$$$reportNull$$$0(19);
        }
        return psiTypeParameterArray;
    }

    @NotNull
    public static PsiTypeParameter[] filterUnusedTypeParameters(PsiType superReturnTypeInBaseClassType, @NotNull PsiTypeParameter[] typeParameters) {
        if (typeParameters == null) {
            PsiTypesUtil.$$$reportNull$$$0(20);
        }
        PsiTypeParameter[] psiTypeParameterArray = PsiTypesUtil.filterUnusedTypeParameters(typeParameters, superReturnTypeInBaseClassType);
        if (psiTypeParameterArray == null) {
            PsiTypesUtil.$$$reportNull$$$0(21);
        }
        return psiTypeParameterArray;
    }

    static {
        ourUnboxedTypes.put("java.lang.Boolean", "boolean");
        ourUnboxedTypes.put("java.lang.Byte", "byte");
        ourUnboxedTypes.put("java.lang.Short", "short");
        ourUnboxedTypes.put("java.lang.Integer", "int");
        ourUnboxedTypes.put("java.lang.Long", "long");
        ourUnboxedTypes.put("java.lang.Float", "float");
        ourUnboxedTypes.put("java.lang.Double", "double");
        ourUnboxedTypes.put("java.lang.Character", "char");
        ourBoxedTypes.put("boolean", "java.lang.Boolean");
        ourBoxedTypes.put("byte", "java.lang.Byte");
        ourBoxedTypes.put("short", "java.lang.Short");
        ourBoxedTypes.put("int", "java.lang.Integer");
        ourBoxedTypes.put("long", "java.lang.Long");
        ourBoxedTypes.put("float", "java.lang.Float");
        ourBoxedTypes.put("double", "java.lang.Double");
        ourBoxedTypes.put("char", "java.lang.Character");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 7: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodExpression";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "languageLevel";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getDefaultValueOfType";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/util/PsiTypesUtil";
                break;
            }
            case 18: 
            case 19: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "filterUnusedTypeParameters";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getClassType";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getLowestUpperBoundClassType";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "patchMethodGetClassReturnType";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createJavaLangClassType";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getExpectedTypeByParent";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "hasUnresolvedComponents";
                break;
            }
            case 17: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "filterUnusedTypeParameters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 20: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class TypeParameterSearcher
    extends PsiTypeVisitor<Boolean> {
        private final Set<PsiTypeParameter> myTypeParams = new HashSet<PsiTypeParameter>();

        public Set<PsiTypeParameter> getTypeParameters() {
            return this.myTypeParams;
        }

        @Override
        public Boolean visitType(PsiType type) {
            return false;
        }

        @Override
        public Boolean visitArrayType(PsiArrayType arrayType) {
            return arrayType.getComponentType().accept(this);
        }

        @Override
        public Boolean visitClassType(PsiClassType classType) {
            PsiClassType.ClassResolveResult resolveResult = classType.resolveGenerics();
            PsiClass aClass = resolveResult.getElement();
            if (aClass instanceof PsiTypeParameter) {
                this.myTypeParams.add((PsiTypeParameter)aClass);
            }
            if (aClass != null) {
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                for (PsiTypeParameter parameter : PsiUtil.typeParametersIterable(aClass)) {
                    PsiType psiType = substitutor.substitute(parameter);
                    if (psiType == null) continue;
                    psiType.accept(this);
                }
            }
            return false;
        }

        @Override
        public Boolean visitWildcardType(PsiWildcardType wildcardType) {
            PsiType bound = wildcardType.getBound();
            if (bound != null) {
                bound.accept(this);
            }
            return false;
        }
    }
}

