/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class PsiLiteralUtil {
    @NonNls
    public static final String HEX_PREFIX = "0x";
    @NonNls
    public static final String BIN_PREFIX = "0b";
    @NonNls
    public static final String _2_IN_31 = Long.toString(Integer.MIN_VALUE).substring(1);
    @NonNls
    public static final String _2_IN_63 = Long.toString(Long.MIN_VALUE).substring(1);

    @Nullable
    public static Integer parseInteger(String text) {
        try {
            if (text.startsWith(HEX_PREFIX)) {
                long value = PsiLiteralUtil.parseDigits(text.substring(2), 4, 32);
                return (int)value;
            }
            if (text.startsWith(BIN_PREFIX)) {
                long value = PsiLiteralUtil.parseDigits(text.substring(2), 1, 32);
                return (int)value;
            }
            if (StringUtil.startsWithChar((CharSequence)text, (char)'0')) {
                long value = PsiLiteralUtil.parseDigits(text, 3, 32);
                return (int)value;
            }
            long l = Long.parseLong(text, 10);
            if (text.equals(_2_IN_31)) {
                return (int)l;
            }
            long converted = (int)l;
            return l == converted ? Integer.valueOf((int)l) : null;
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Long parseLong(String text) {
        if (StringUtil.endsWithChar((CharSequence)text, (char)'L') || StringUtil.endsWithChar((CharSequence)text, (char)'l')) {
            text = text.substring(0, text.length() - 1);
        }
        try {
            if (text.startsWith(HEX_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text.substring(2), 4, 64);
            }
            if (text.startsWith(BIN_PREFIX)) {
                return PsiLiteralUtil.parseDigits(text.substring(2), 1, 64);
            }
            if (StringUtil.startsWithChar((CharSequence)text, (char)'0')) {
                return PsiLiteralUtil.parseDigits(text, 3, 64);
            }
            if (_2_IN_63.equals(text)) {
                return Long.MIN_VALUE;
            }
            return Long.valueOf(text, 10);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Float parseFloat(String text) {
        try {
            return Float.valueOf(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Nullable
    public static Double parseDouble(String text) {
        try {
            return Double.valueOf(text);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static long parseDigits(String text, int bitsInRadix, int maxBits) throws NumberFormatException {
        long integer;
        int radix = 1 << bitsInRadix;
        int textLength = text.length();
        if (textLength == 0) {
            throw new NumberFormatException(text);
        }
        long l = integer = textLength == 1 ? 0L : Long.parseLong(text.substring(0, textLength - 1), radix);
        if ((integer & -1L << maxBits - bitsInRadix) != 0L) {
            throw new NumberFormatException(text);
        }
        int lastDigit = Character.digit(text.charAt(textLength - 1), radix);
        if (lastDigit == -1) {
            throw new NumberFormatException(text);
        }
        integer <<= bitsInRadix;
        return integer |= (long)lastDigit;
    }
}

