/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.project;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ProjectLocator {
    private static final Key<ThreadLocal<Project>> PREFERRED_PROJECT_KEY = Key.create((String)"PREFERRED_PROJECT_KEY");

    public static ProjectLocator getInstance() {
        return ServiceManager.getService(ProjectLocator.class);
    }

    @Nullable
    public abstract Project guessProjectForFile(@Nullable VirtualFile var1);

    @NotNull
    public abstract Collection<Project> getProjectsForFile(VirtualFile var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Throwable> T computeWithPreferredProject(@NotNull VirtualFile file, @NotNull Project preferredProject, @NotNull ThrowableComputable<T, E> action) throws E {
        ThreadLocal local;
        if (file == null) {
            ProjectLocator.$$$reportNull$$$0(0);
        }
        if (preferredProject == null) {
            ProjectLocator.$$$reportNull$$$0(1);
        }
        if (action == null) {
            ProjectLocator.$$$reportNull$$$0(2);
        }
        if ((local = (ThreadLocal)file.getUserData(PREFERRED_PROJECT_KEY)) == null) {
            local = (ThreadLocal)file.putUserDataIfAbsent(PREFERRED_PROJECT_KEY, new ThreadLocal());
        }
        local.set(preferredProject);
        try {
            Object object = action.compute();
            return (T)object;
        }
        finally {
            local.remove();
        }
    }

    @Nullable
    static Project getPreferredProject(@NotNull VirtualFile file) {
        ThreadLocal local;
        if (file == null) {
            ProjectLocator.$$$reportNull$$$0(3);
        }
        return (local = (ThreadLocal)file.getUserData(PREFERRED_PROJECT_KEY)) != null ? (Project)local.get() : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "preferredProject";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/project/ProjectLocator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "computeWithPreferredProject";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getPreferredProject";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

