/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.settings;

import com.intellij.openapi.externalSystem.ExternalSystemManager;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskExecutionInfo;
import com.intellij.openapi.externalSystem.model.execution.ExternalTaskPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectBuildClasspathPojo;
import com.intellij.openapi.externalSystem.model.project.ExternalProjectPojo;
import com.intellij.openapi.externalSystem.settings.AbstractExternalSystemSettings;
import com.intellij.openapi.externalSystem.settings.ExternalProjectSettings;
import com.intellij.openapi.externalSystem.util.ExternalSystemApiUtil;
import com.intellij.openapi.externalSystem.view.ExternalProjectsViewState;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtilRt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractExternalSystemLocalSettings {
    private static final boolean PRESERVE_EXPAND_STATE = !SystemProperties.getBooleanProperty((String)"external.system.forget.expand.nodes.state", (boolean)false);
    private final AtomicReference<Map<String, Boolean>> myExpandStates;
    private final AtomicReference<List<ExternalTaskExecutionInfo>> myRecentTasks;
    private final AtomicReference<Map<ExternalProjectPojo, Collection<ExternalProjectPojo>>> myAvailableProjects;
    private final AtomicReference<Map<String, Collection<ExternalTaskPojo>>> myAvailableTasks;
    private final AtomicReference<Map<String, ExternalProjectBuildClasspathPojo>> myProjectBuildClasspath;
    private final AtomicReference<Map<String, Long>> myExternalConfigModificationStamps;
    private final AtomicReference<ExternalProjectsViewState> myExternalProjectsViewState;
    private final AtomicReference<Map<String, SyncType>> myProjectSyncType;
    @NotNull
    private final ProjectSystemId myExternalSystemId;
    @NotNull
    private final Project myProject;

    protected AbstractExternalSystemLocalSettings(@NotNull ProjectSystemId externalSystemId, @NotNull Project project) {
        if (externalSystemId == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(0);
        }
        if (project == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(1);
        }
        this.myExpandStates = new AtomicReference(new HashMap());
        this.myRecentTasks = new AtomicReference<ArrayList>(ContainerUtilRt.newArrayList());
        this.myAvailableProjects = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myAvailableTasks = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myProjectBuildClasspath = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myExternalConfigModificationStamps = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myExternalProjectsViewState = new AtomicReference<ExternalProjectsViewState>(new ExternalProjectsViewState());
        this.myProjectSyncType = new AtomicReference<HashMap>(ContainerUtilRt.newHashMap());
        this.myExternalSystemId = externalSystemId;
        this.myProject = project;
    }

    public void forgetExternalProjects(@NotNull Set<String> linkedProjectPathsToForget) {
        Map.Entry<Object, Collection<Comparable<ExternalProjectPojo>>> entry;
        if (linkedProjectPathsToForget == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(2);
        }
        Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects = this.myAvailableProjects.get();
        Iterator<Object> it = projects.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey().getPath())) continue;
            it.remove();
        }
        it = this.myAvailableTasks.get().entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey()) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath((String)entry.getKey(), this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        it = this.myRecentTasks.get().iterator();
        while (it.hasNext()) {
            ExternalTaskExecutionInfo taskInfo = (ExternalTaskExecutionInfo)it.next();
            String path2 = taskInfo.getSettings().getExternalProjectPath();
            if (!linkedProjectPathsToForget.contains(path2) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath(path2, this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        it = this.myProjectBuildClasspath.get().entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey()) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath((String)entry.getKey(), this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        it = this.myProjectSyncType.get().entrySet().iterator();
        while (it.hasNext()) {
            entry = (Map.Entry)it.next();
            if (!linkedProjectPathsToForget.contains(entry.getKey()) && !linkedProjectPathsToForget.contains(ExternalSystemApiUtil.getRootProjectPath((String)entry.getKey(), this.myExternalSystemId, this.myProject))) continue;
            it.remove();
        }
        Map<String, Long> modificationStamps = this.myExternalConfigModificationStamps.get();
        for (String path2 : linkedProjectPathsToForget) {
            modificationStamps.remove(path2);
        }
    }

    @NotNull
    public Map<String, Boolean> getExpandStates() {
        Map<String, Boolean> map = this.myExpandStates.get();
        if (map == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(3);
        }
        return map;
    }

    @NotNull
    public Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> getAvailableProjects() {
        Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> map = this.myAvailableProjects.get();
        if (map == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(4);
        }
        return map;
    }

    public void setAvailableProjects(@NotNull Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> projects) {
        if (projects == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(5);
        }
        this.myAvailableProjects.set(projects);
    }

    @NotNull
    public Map<String, Collection<ExternalTaskPojo>> getAvailableTasks() {
        Map<String, Collection<ExternalTaskPojo>> map = this.myAvailableTasks.get();
        if (map == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(6);
        }
        return map;
    }

    public void setAvailableTasks(@NotNull Map<String, Collection<ExternalTaskPojo>> tasks) {
        if (tasks == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(7);
        }
        this.myAvailableTasks.set(tasks);
    }

    @NotNull
    public List<ExternalTaskExecutionInfo> getRecentTasks() {
        List<ExternalTaskExecutionInfo> list = this.myRecentTasks.get();
        if (list == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(8);
        }
        return list;
    }

    public void setRecentTasks(@NotNull List<ExternalTaskExecutionInfo> tasks) {
        if (tasks == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(9);
        }
        this.myRecentTasks.set(tasks);
    }

    @NotNull
    public Map<String, Long> getExternalConfigModificationStamps() {
        Map<String, Long> map = this.myExternalConfigModificationStamps.get();
        if (map == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(10);
        }
        return map;
    }

    public void setExternalConfigModificationStamps(@NotNull Map<String, Long> modificationStamps) {
        if (modificationStamps == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(11);
        }
        this.myExternalConfigModificationStamps.set(modificationStamps);
    }

    @NotNull
    public Map<String, ExternalProjectBuildClasspathPojo> getProjectBuildClasspath() {
        Map<String, ExternalProjectBuildClasspathPojo> map = this.myProjectBuildClasspath.get();
        if (map == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(12);
        }
        return map;
    }

    public void setProjectBuildClasspath(@NotNull Map<String, ExternalProjectBuildClasspathPojo> projectsBuildClasspath) {
        if (projectsBuildClasspath == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(13);
        }
        this.myProjectBuildClasspath.set(projectsBuildClasspath);
    }

    public ExternalProjectsViewState getExternalProjectsViewState() {
        return this.myExternalProjectsViewState.get();
    }

    public void setExternalProjectsViewState(ExternalProjectsViewState externalProjectsViewState) {
        this.myExternalProjectsViewState.set(externalProjectsViewState);
    }

    @NotNull
    public Map<String, SyncType> getProjectSyncType() {
        Map<String, SyncType> map = this.myProjectSyncType.get();
        if (map == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(14);
        }
        return map;
    }

    public void setProjectSyncType(@NotNull Map<String, SyncType> projectSyncType) {
        if (projectSyncType == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(15);
        }
        this.myProjectSyncType.set(projectSyncType);
    }

    public void fillState(@NotNull State state) {
        if (state == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(16);
        }
        state.tasksExpandState = PRESERVE_EXPAND_STATE ? this.myExpandStates.get() : Collections.emptyMap();
        state.recentTasks = this.myRecentTasks.get();
        state.availableProjects = this.myAvailableProjects.get();
        state.availableTasks = this.myAvailableTasks.get();
        state.modificationStamps = this.myExternalConfigModificationStamps.get();
        state.projectBuildClasspath = this.myProjectBuildClasspath.get();
        state.externalProjectsViewState = this.myExternalProjectsViewState.get();
        state.projectSyncType = this.myProjectSyncType.get();
    }

    public void loadState(@NotNull State state) {
        List<ExternalTaskExecutionInfo> recentTasks;
        if (state == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(17);
        }
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myExpandStates, state.tasksExpandState);
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myAvailableProjects, state.availableProjects);
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myAvailableTasks, state.availableTasks);
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myExternalConfigModificationStamps, state.modificationStamps);
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myProjectBuildClasspath, state.projectBuildClasspath);
        AbstractExternalSystemLocalSettings.setIfNotNull(this.myProjectSyncType, state.projectSyncType);
        this.myExternalProjectsViewState.set(state.externalProjectsViewState);
        if (state.recentTasks != null && (recentTasks = this.myRecentTasks.get()) != state.recentTasks) {
            recentTasks.clear();
            recentTasks.addAll(state.recentTasks);
        }
        this.pruneOutdatedEntries();
    }

    private void pruneOutdatedEntries() {
        ExternalSystemManager<?, ?, ?, ?, ?> manager = ExternalSystemApiUtil.getManager(this.myExternalSystemId);
        assert (manager != null);
        HashSet pathsToForget = ContainerUtilRt.newHashSet();
        for (ExternalProjectPojo pojo : this.myAvailableProjects.get().keySet()) {
            pathsToForget.add(pojo.getPath());
        }
        for (String path2 : this.myAvailableTasks.get().keySet()) {
            pathsToForget.add(path2);
        }
        for (ExternalTaskExecutionInfo taskInfo : this.myRecentTasks.get()) {
            pathsToForget.add(taskInfo.getSettings().getExternalProjectPath());
        }
        AbstractExternalSystemSettings settings = (AbstractExternalSystemSettings)manager.getSettingsProvider().fun((Object)this.myProject);
        for (ExternalProjectSettings projectSettings : settings.getLinkedProjectsSettings()) {
            pathsToForget.remove(projectSettings.getExternalProjectPath());
        }
        for (Module module : ModuleManager.getInstance(this.myProject).getModules()) {
            if (!ExternalSystemApiUtil.isExternalSystemAwareModule(this.myExternalSystemId, module)) continue;
            pathsToForget.remove(ExternalSystemApiUtil.getExternalProjectPath(module));
        }
        if (!pathsToForget.isEmpty()) {
            this.forgetExternalProjects(pathsToForget);
        }
    }

    protected static <K, V> void setIfNotNull(@NotNull AtomicReference<Map<K, V>> ref, @Nullable Map<K, V> candidate) {
        if (ref == null) {
            AbstractExternalSystemLocalSettings.$$$reportNull$$$0(18);
        }
        if (candidate == null) {
            return;
        }
        Map<K, V> map = ref.get();
        if (candidate != map) {
            map.clear();
            map.putAll(candidate);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "externalSystemId";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "linkedProjectPathsToForget";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projects";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tasks";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "modificationStamps";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectsBuildClasspath";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectSyncType";
                break;
            }
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/externalSystem/settings/AbstractExternalSystemLocalSettings";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getExpandStates";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableProjects";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAvailableTasks";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getRecentTasks";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExternalConfigModificationStamps";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectBuildClasspath";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectSyncType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "forgetExternalProjects";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setAvailableProjects";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "setAvailableTasks";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setRecentTasks";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "setExternalConfigModificationStamps";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "setProjectBuildClasspath";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "setProjectSyncType";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "fillState";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "setIfNotNull";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: 
            case 12: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum SyncType {
        PREVIEW,
        IMPORT,
        RE_IMPORT;

    }

    public static class State {
        public Map<String, Boolean> tasksExpandState = ContainerUtilRt.newHashMap();
        public List<ExternalTaskExecutionInfo> recentTasks = ContainerUtilRt.newArrayList();
        public Map<ExternalProjectPojo, Collection<ExternalProjectPojo>> availableProjects = ContainerUtilRt.newHashMap();
        public Map<String, Collection<ExternalTaskPojo>> availableTasks = ContainerUtilRt.newHashMap();
        public Map<String, Long> modificationStamps = ContainerUtilRt.newHashMap();
        public Map<String, ExternalProjectBuildClasspathPojo> projectBuildClasspath = ContainerUtilRt.newHashMap();
        public ExternalProjectsViewState externalProjectsViewState;
        public Map<String, SyncType> projectSyncType = ContainerUtilRt.newHashMap();
    }
}

