/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.context;

import com.intellij.psi.xml.XmlFile;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.regex.Pattern;

public class RegexFilteredIterator
implements Iterator<XmlFile> {
    private final Iterator<XmlFile> baseIterator;
    private final String regex;
    private XmlFile nextFile = null;
    private boolean advanced = false;
    private boolean completed = false;
    private Pattern pattern;

    public RegexFilteredIterator(Iterator<XmlFile> baseIterator, String regex) {
        this.baseIterator = baseIterator;
        this.regex = regex;
        try {
            this.pattern = Pattern.compile(regex);
        }
        catch (Exception e) {
            this.pattern = null;
        }
    }

    @Override
    public boolean hasNext() {
        if (this.completed) {
            return false;
        }
        if (!this.advanced) {
            this.advance();
        }
        return !this.completed;
    }

    @Override
    public XmlFile next() {
        if (this.completed) {
            throw new NoSuchElementException();
        }
        if (!this.advanced) {
            this.advance();
        }
        this.advanced = false;
        return this.nextFile;
    }

    private void advance() {
        if (this.completed) {
            return;
        }
        do {
            if (this.baseIterator.hasNext()) {
                this.nextFile = this.baseIterator.next();
                String fileName = this.nextFile.getName();
                if (this.pattern != null && !this.pattern.matcher(fileName).matches()) continue;
                this.advanced = true;
                continue;
            }
            this.completed = true;
        } while (!this.completed && !this.advanced);
    }

    @Override
    public void remove() {
    }
}

