/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.xrp.addsubtag;

import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewDescriptor;
import com.sixrr.xrp.addsubtag.AddSubtag;
import com.sixrr.xrp.addsubtag.AddSubtagUsageViewDescriptor;
import com.sixrr.xrp.base.XRPBaseRefactoringProcessor;
import com.sixrr.xrp.base.XRPUsageInfo;
import com.sixrr.xrp.context.Context;
import com.sixrr.xrp.psi.TagSearchVisitor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class AddSubtagProcessor
extends XRPBaseRefactoringProcessor {
    private final XmlTag tag;
    private final String subtagName;
    private final boolean addOnlyIfAbsent;
    private final Context context;

    AddSubtagProcessor(XmlTag tag, String subtagName, boolean addOnlyIfAbsent, Context context) {
        super(tag.getProject());
        this.subtagName = subtagName;
        this.tag = tag;
        this.addOnlyIfAbsent = addOnlyIfAbsent;
        this.context = context;
    }

    @NotNull
    protected UsageViewDescriptor createUsageViewDescriptor(@NotNull UsageInfo[] usageInfos) {
        if (usageInfos == null) {
            AddSubtagProcessor.$$$reportNull$$$0(0);
        }
        AddSubtagUsageViewDescriptor addSubtagUsageViewDescriptor = new AddSubtagUsageViewDescriptor(this.tag, usageInfos);
        if (addSubtagUsageViewDescriptor == null) {
            AddSubtagProcessor.$$$reportNull$$$0(1);
        }
        return addSubtagUsageViewDescriptor;
    }

    @Override
    public void findUsages(@NotNull List<XRPUsageInfo> usages) {
        if (usages == null) {
            AddSubtagProcessor.$$$reportNull$$$0(2);
        }
        String tagName = this.tag.getName();
        TagSearchVisitor visitor = new TagSearchVisitor(tagName);
        for (XmlFile file : this.context) {
            file.accept((PsiElementVisitor)visitor);
        }
        List<XmlTag> tagsFound = visitor.getTags();
        for (XmlTag xmlTag : tagsFound) {
            if (this.addOnlyIfAbsent && this.subtagExists(xmlTag)) continue;
            usages.add(new AddSubtag(xmlTag, this.subtagName));
        }
    }

    private boolean subtagExists(XmlTag xmlTag) {
        XmlTag[] subtags;
        for (XmlTag subtag : subtags = xmlTag.getSubTags()) {
            if (!subtag.getName().equals(this.subtagName)) continue;
            return true;
        }
        return false;
    }

    protected String getCommandName() {
        return "Add subtag " + this.subtagName + " to tag " + this.tag.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usageInfos";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/sixrr/xrp/addsubtag/AddSubtagProcessor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/sixrr/xrp/addsubtag/AddSubtagProcessor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createUsageViewDescriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createUsageViewDescriptor";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "findUsages";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

