/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.cloud;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.cloudfoundry.CFProvider;
import com.intellij.javaee.cloudfoundry.CFVersion;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFOrganization;
import com.intellij.javaee.cloudfoundry.agent.wrappers.CFSpacesDomain;
import com.intellij.javaee.cloudfoundry.cloud.CFCloudLocation;
import com.intellij.javaee.cloudfoundry.cloud.CFCloudType;
import com.intellij.javaee.cloudfoundry.cloud.CFConnectionTask;
import com.intellij.javaee.cloudfoundry.cloud.CFServerConfiguration;
import com.intellij.javaee.cloudfoundry.cloud.CFServerRuntimeInstanceV2;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remoteServer.RemoteServerConfigurable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.util.DelayedRunner;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.Nullable;

public class CFCloudConfigurable
extends RemoteServerConfigurable
implements UnnamedConfigurable {
    private final CFServerConfiguration myConfiguration;
    private final DelayedRunner myRunner;
    private JTextField myEmailTextField;
    private JPasswordField myPasswordField;
    private JPanel myMainPanel;
    private JComboBox myVersionComboBox;
    private JComboBox myProviderComboBox;
    private JBLabel myOrganizationLabel;
    private JBLabel mySpaceLabel;
    private JComboBox myOrganizationComboBox;
    private JComboBox mySpaceComboBox;
    private JBLabel myInstanceLabel;
    private JComboBox myLocationComboBox;
    private JTextField myCustomDomainTextField;
    private JBLabel myDomainLabel;
    private JBLabel myPortLabel;
    private JTextField myPortField;
    private JBLabel myProviderLabel;
    private JBCheckBox myTrustSelfSignedCertCheckBox;
    private boolean myInResetEditor = false;
    private CFCloudType myCloudInstance;
    private CFServerConfiguration myCoreConfiguration;

    public CFCloudConfigurable(CFServerConfiguration configuration) {
        this.myConfiguration = configuration;
        this.$$$setupUI$$$();
        this.myCloudInstance = CFCloudType.getInstance();
        JComboBox cloudLocationComboBox = this.myLocationComboBox;
        for (CFCloudLocation location : CFCloudLocation.LOCATIONS) {
            cloudLocationComboBox.addItem(location);
        }
        cloudLocationComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    CFCloudConfigurable.this.buildUI();
                }
            }
        });
        this.myVersionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CFCloudConfigurable.this.onVersionChanged();
            }
        });
        JTextComponent providerText = (JTextComponent)this.myProviderComboBox.getEditor().getEditorComponent();
        providerText.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                if (!CFCloudConfigurable.this.myInResetEditor) {
                    CFCloudConfigurable.this.removeOrgSpaces();
                    CFCloudConfigurable.this.buildUI();
                }
            }
        });
        this.myOrganizationComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OrganizationItem selectedOrganization;
                CFCloudConfigurable.this.mySpaceComboBox.removeAllItems();
                if (CFCloudConfigurable.this.myOrganizationComboBox.getSelectedItem() instanceof OrganizationItem && (selectedOrganization = (OrganizationItem)CFCloudConfigurable.this.myOrganizationComboBox.getSelectedItem()) != null) {
                    for (String space : selectedOrganization.getSpaces()) {
                        CFCloudConfigurable.this.mySpaceComboBox.addItem(space);
                    }
                }
            }
        });
        for (CFVersion version : CFVersion.values()) {
            this.myVersionComboBox.addItem(version);
        }
        this.myRunner = new DelayedRunner(this.myMainPanel){

            protected boolean wasChanged() {
                CFServerConfiguration configuration = new CFServerConfiguration();
                try {
                    CFCloudConfigurable.this.applyCoreTo(configuration);
                }
                catch (ConfigurationException e) {
                    return true;
                }
                if (CFCloudConfigurable.this.myCoreConfiguration != null && CFCloudConfigurable.isCoreConfigEqual(CFCloudConfigurable.this.myCoreConfiguration, configuration)) {
                    return false;
                }
                CFCloudConfigurable.this.myCoreConfiguration = configuration;
                return true;
            }

            protected void run() {
                if (CFCloudConfigurable.this.isV2()) {
                    CFCloudConfigurable.this.loadSpacesAndOrganizations();
                }
            }
        };
    }

    @Nullable
    public JComponent createComponent() {
        return this.myMainPanel;
    }

    private void removeOrgSpaces() {
        this.myOrganizationComboBox.removeAllItems();
        this.mySpaceComboBox.removeAllItems();
    }

    private void onVersionChanged() {
        this.buildUI();
        CFVersion version = (CFVersion)((Object)this.myVersionComboBox.getSelectedItem());
        this.myProviderComboBox.removeAllItems();
        for (CFProvider provider : CFProvider.values()) {
            if (!provider.getVersion().equals((Object)version)) continue;
            this.myProviderComboBox.addItem(provider);
        }
    }

    private void buildUI() {
        boolean v2 = this.isV2();
        this.myOrganizationComboBox.setVisible(v2);
        this.myOrganizationLabel.setVisible(v2);
        this.mySpaceComboBox.setVisible(v2);
        this.mySpaceLabel.setVisible(v2);
        this.myTrustSelfSignedCertCheckBox.setVisible(v2 && !this.isKnownProvider());
        boolean v1 = !v2;
        this.myInstanceLabel.setVisible(v1);
        this.myLocationComboBox.setVisible(v1);
        CFCloudLocation location = this.getSelectedLocation();
        boolean global = location == CFCloudLocation.GLOBAL;
        this.myProviderComboBox.setVisible(global);
        this.myProviderLabel.setVisible(global);
        boolean microOffline = location == CFCloudLocation.MICRO_OFFLINE;
        this.myCustomDomainTextField.setVisible(microOffline);
        this.myDomainLabel.setVisible(microOffline);
        boolean local = location == CFCloudLocation.LOCAL;
        this.myPortField.setVisible(local);
        this.myPortLabel.setVisible(local);
    }

    private Object getSelectedProvider() {
        return this.myProviderComboBox.getEditor().getItem();
    }

    private boolean isKnownProvider() {
        return this.getSelectedProvider() instanceof CFProvider;
    }

    private CFCloudLocation getSelectedLocation() {
        return this.isV2() ? CFCloudLocation.GLOBAL : (CFCloudLocation)this.myLocationComboBox.getSelectedItem();
    }

    private void loadSpacesAndOrganizations() {
        RemoteServer tempServer = RemoteServersManager.getInstance().createServer((ServerType)this.myCloudInstance, this.generateServerName());
        CFServerConfiguration newConfiguration = (CFServerConfiguration)tempServer.getConfiguration();
        try {
            this.applyCoreTo(newConfiguration);
        }
        catch (ConfigurationException e) {
            return;
        }
        new CFConnectionTask<CFSpacesDomain, CFServerRuntimeInstanceV2>(null, "Loading Spaces and Organizations", tempServer){

            protected CFSpacesDomain run(CFServerRuntimeInstanceV2 serverRuntime) throws ServerRuntimeException {
                return serverRuntime.getSpacesDomain();
            }

            protected void postPerform(CFSpacesDomain spacesDomain) {
                CFCloudConfigurable.this.removeOrgSpaces();
                for (CFOrganization organization : spacesDomain.getOrganizations()) {
                    CFCloudConfigurable.this.myOrganizationComboBox.addItem(new OrganizationItem(organization));
                }
            }
        }.performAsync();
    }

    private boolean isV2() {
        return this.myVersionComboBox.getSelectedItem() == CFVersion.V2;
    }

    public boolean isModified() {
        CFServerConfiguration configuration = new CFServerConfiguration();
        try {
            this.applyTo(configuration);
        }
        catch (ConfigurationException e) {
            return true;
        }
        return !CFCloudConfigurable.isConfigEqual(this.myConfiguration, configuration);
    }

    private static boolean isCoreConfigEqual(CFServerConfiguration configuration1, CFServerConfiguration configuration2) {
        return Comparing.equal((Object)((Object)configuration1.getVersion()), (Object)((Object)configuration2.getVersion())) && Comparing.equal((String)configuration1.getEmail(), (String)configuration2.getEmail()) && Comparing.equal((String)configuration1.getPassword(), (String)configuration2.getPassword()) && Comparing.equal((String)configuration1.getApiUrl(), (String)configuration2.getApiUrl()) && Comparing.equal((Object)configuration1.isTrustSelfSignedCert(), (Object)configuration2.isTrustSelfSignedCert()) && Comparing.equal((Object)configuration1.getPort(), (Object)configuration2.getPort()) && Comparing.equal((String)configuration1.getDomain(), (String)configuration2.getDomain()) && Comparing.equal((String)configuration1.getLocationId(), (String)configuration2.getLocationId());
    }

    private static boolean isConfigEqual(CFServerConfiguration configuration1, CFServerConfiguration configuration2) {
        return CFCloudConfigurable.isCoreConfigEqual(configuration1, configuration2) && Comparing.equal((String)configuration1.getOrganization(), (String)configuration2.getOrganization()) && Comparing.equal((String)configuration1.getSpace(), (String)configuration2.getSpace());
    }

    private void applyTo(CFServerConfiguration configuration) throws ConfigurationException {
        CFServerConfiguration validationCoreConfig = new CFServerConfiguration();
        this.applyCoreTo(validationCoreConfig);
        String organization = "";
        String space = "";
        if (this.isV2()) {
            Object selectedOrganization = this.myOrganizationComboBox.getEditor().getItem();
            if (selectedOrganization != null) {
                organization = selectedOrganization.toString();
            }
            if (StringUtil.isEmpty((String)organization)) {
                throw new ConfigurationException("Organization required");
            }
            Object selectedSpace = this.mySpaceComboBox.getEditor().getItem();
            if (selectedSpace != null) {
                space = selectedSpace.toString();
            }
            if (StringUtil.isEmpty((String)space)) {
                throw new ConfigurationException("Space required");
            }
        }
        this.applyCoreTo(configuration);
        configuration.setOrganization(organization);
        configuration.setSpace(space);
    }

    private void applyCoreTo(CFServerConfiguration configuration) throws ConfigurationException {
        int port;
        String email = this.myEmailTextField.getText();
        if (StringUtil.isEmpty((String)email)) {
            throw new RuntimeConfigurationError("Email required");
        }
        String password = new String(this.myPasswordField.getPassword());
        if (StringUtil.isEmpty((String)password)) {
            throw new RuntimeConfigurationError("Password required");
        }
        Object provider = this.getSelectedProvider();
        boolean knownProvider = this.isKnownProvider();
        String apiUrl = knownProvider ? ((CFProvider)((Object)provider)).getApiUrl() : (String)provider;
        if (StringUtil.isEmpty((String)apiUrl)) {
            throw new RuntimeConfigurationError("Provider (API URL) required");
        }
        try {
            port = this.parsePort();
        }
        catch (ConfigurationException e) {
            port = 80;
        }
        configuration.setVersion((CFVersion)((Object)this.myVersionComboBox.getSelectedItem()));
        configuration.setEmail(email);
        configuration.setPassword(password);
        configuration.setDomain(this.myCustomDomainTextField.getText());
        configuration.setPort(port);
        configuration.setApiUrl(apiUrl);
        configuration.setLocationId(((CFCloudLocation)this.myLocationComboBox.getSelectedItem()).getId());
        configuration.setTrustSelfSignedCert(this.myTrustSelfSignedCertCheckBox.isSelected() && !knownProvider);
        configuration.setOrganization("");
        configuration.setSpace("");
    }

    public void apply() throws ConfigurationException {
        this.applyTo(this.myConfiguration);
    }

    public void reset() {
        this.myInResetEditor = true;
        try {
            this.myLocationComboBox.setSelectedItem(this.myConfiguration.getLocation());
            this.myVersionComboBox.setSelectedItem((Object)this.myConfiguration.getVersion());
            this.myEmailTextField.setText(this.myConfiguration.getEmail());
            this.myPasswordField.setText(this.myConfiguration.getPassword());
            CFProvider provider = this.myConfiguration.getProvider();
            this.myProviderComboBox.setSelectedItem(provider == null ? this.myConfiguration.getApiUrl() : provider);
            this.myTrustSelfSignedCertCheckBox.setSelected(this.myConfiguration.isTrustSelfSignedCert());
            this.myOrganizationComboBox.setSelectedItem(this.myConfiguration.getOrganization());
            this.mySpaceComboBox.setSelectedItem(this.myConfiguration.getSpace());
            this.myCustomDomainTextField.setText(this.myConfiguration.getDomain());
            this.myPortField.setText(String.valueOf(this.myConfiguration.getPort()));
            this.buildUI();
        }
        finally {
            this.myInResetEditor = false;
        }
    }

    private int parsePort() throws RuntimeConfigurationException {
        try {
            return Integer.parseInt(this.myPortField.getText());
        }
        catch (NumberFormatException e) {
            throw new RuntimeConfigurationException("Invalid port number");
        }
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this.myRunner);
    }

    protected String generateServerName() {
        return UniqueNameGenerator.generateUniqueName((String)this.myCloudInstance.getPresentableName(), s -> {
            for (RemoteServer server : RemoteServersManager.getInstance().getServers()) {
                if (!server.getName().equals(s)) continue;
                return false;
            }
            return true;
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JBCheckBox jBCheckBox;
        JTextField jTextField;
        JBLabel jBLabel;
        JBLabel jBLabel2;
        JTextField jTextField2;
        JComboBox jComboBox;
        JBLabel jBLabel3;
        JComboBox jComboBox2;
        JComboBox jComboBox3;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        JBLabel jBLabel4;
        JBLabel jBLabel5;
        JBLabel jBLabel6;
        JPasswordField jPasswordField;
        JTextField jTextField3;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JBLabel jBLabel7 = new JBLabel();
        jBLabel7.setText("Username (email):");
        jPanel.add((Component)jBLabel7, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myEmailTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JBLabel jBLabel8 = new JBLabel();
        jBLabel8.setText("Password:");
        jPanel.add((Component)jBLabel8, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPasswordField = jPasswordField = new JPasswordField();
        jPanel.add((Component)jPasswordField, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myProviderLabel = jBLabel6 = new JBLabel();
        jBLabel6.setText("Provider (API URL):");
        jPanel.add((Component)jBLabel6, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOrganizationLabel = jBLabel5 = new JBLabel();
        jBLabel5.setText("Organization:");
        jPanel.add((Component)jBLabel5, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.mySpaceLabel = jBLabel4 = new JBLabel();
        jBLabel4.setText("Space:");
        jPanel.add((Component)jBLabel4, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel9 = new JBLabel();
        jBLabel9.setText("Version:");
        jPanel.add((Component)jBLabel9, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVersionComboBox = jComboBox5 = new JComboBox();
        jComboBox5.setEditable(false);
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel();
        jComboBox5.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox5, new GridConstraints(0, 1, 1, 1, 0, 1, 4, 0, null, null, null));
        this.myProviderComboBox = jComboBox4 = new JComboBox();
        jComboBox4.setEditable(true);
        jPanel.add(jComboBox4, new GridConstraints(4, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myOrganizationComboBox = jComboBox3 = new JComboBox();
        jComboBox3.setEditable(true);
        ((Component)jComboBox3).setEnabled(true);
        DefaultComboBoxModel defaultComboBoxModel2 = new DefaultComboBoxModel();
        jComboBox3.setModel(defaultComboBoxModel2);
        jPanel.add(jComboBox3, new GridConstraints(6, 1, 1, 1, 0, 1, 4, 0, null, new Dimension(310, 24), null));
        this.mySpaceComboBox = jComboBox2 = new JComboBox();
        jComboBox2.setEditable(true);
        ((Component)jComboBox2).setEnabled(true);
        DefaultComboBoxModel defaultComboBoxModel3 = new DefaultComboBoxModel();
        jComboBox2.setModel(defaultComboBoxModel3);
        jPanel.add(jComboBox2, new GridConstraints(7, 1, 1, 1, 0, 1, 4, 0, null, new Dimension(310, 24), null));
        this.myInstanceLabel = jBLabel3 = new JBLabel();
        jBLabel3.setText("Cloud instance:");
        jPanel.add((Component)jBLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myLocationComboBox = jComboBox = new JComboBox();
        jComboBox.setEditable(false);
        DefaultComboBoxModel defaultComboBoxModel4 = new DefaultComboBoxModel();
        jComboBox.setModel(defaultComboBoxModel4);
        jPanel.add(jComboBox, new GridConstraints(3, 1, 1, 1, 0, 1, 2, 0, null, null, null));
        this.myCustomDomainTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(8, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDomainLabel = jBLabel2 = new JBLabel();
        jBLabel2.setText("Domain:");
        jPanel.add((Component)jBLabel2, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortLabel = jBLabel = new JBLabel();
        jBLabel.setText("Port:");
        jPanel.add((Component)jBLabel, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myPortField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(9, 1, 1, 1, 8, 0, 4, 0, null, new Dimension(150, -1), null));
        this.myTrustSelfSignedCertCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Trust self-signed certificates");
        jPanel.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 2, 8, 0, 0, 0, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private static class OrganizationItem {
        private CFOrganization myOrganization;

        public OrganizationItem(CFOrganization org) {
            this.myOrganization = org;
        }

        public String[] getSpaces() {
            return this.myOrganization.getSpaces();
        }

        public String toString() {
            return this.myOrganization.getName();
        }
    }
}

