/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.application.settings;

import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettings;
import com.intellij.javaee.cloudfoundry.agent.settings.CFAppSettingsRange;
import com.intellij.javaee.oss.cloud.server.config.CloudConfigEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.NotNull;

public class AppSettingsEditor
extends CloudConfigEditor<CFAppSettings, CFAppSettingsRange> {
    private static final String DEFAULT_MEMORY_ITEM = "<Default>";
    private JComboBox myMemoryComboBox;
    private JTextField myInstancesTextField;
    private JPanel myMainPanel;

    public AppSettingsEditor() {
        this.$$$setupUI$$$();
    }

    public void init(Project project, CFAppSettingsRange configDomain) {
        Object memory = this.myMemoryComboBox.getSelectedItem();
        this.myMemoryComboBox.removeAllItems();
        this.myMemoryComboBox.addItem(DEFAULT_MEMORY_ITEM);
        Integer[] integerArray = configDomain.getMemoryChoices();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int memoryChoice = integerArray[i];
            this.myMemoryComboBox.addItem(memoryChoice);
        }
        this.myMemoryComboBox.setSelectedItem(memory == null ? DEFAULT_MEMORY_ITEM : memory);
    }

    protected void resetEditorFrom(@NotNull CFAppSettings s) {
        Integer memory;
        if (s == null) {
            AppSettingsEditor.$$$reportNull$$$0(0);
        }
        this.myMemoryComboBox.setSelectedItem((memory = s.getMemory()) == null ? DEFAULT_MEMORY_ITEM : memory);
        Integer instances = s.getInstances();
        this.myInstancesTextField.setText(instances == null ? "" : String.valueOf(instances));
    }

    protected void applyEditorTo(@NotNull CFAppSettings s) throws ConfigurationException {
        Object memory;
        if (s == null) {
            AppSettingsEditor.$$$reportNull$$$0(1);
        }
        s.setMemory(DEFAULT_MEMORY_ITEM.equals(memory = this.myMemoryComboBox.getSelectedItem()) ? null : (Integer)memory);
        String instancesText = this.myInstancesTextField.getText();
        try {
            s.setInstances(StringUtil.isEmptyOrSpaces((String)instancesText) ? null : Integer.valueOf(Integer.parseInt(instancesText)));
        }
        catch (NumberFormatException e) {
            throw new ConfigurationException("Instances should be a valid number or left empty");
        }
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            AppSettingsEditor.$$$reportNull$$$0(2);
        }
        return jPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/cloudfoundry/application/settings/AppSettingsEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/cloudfoundry/application/settings/AppSettingsEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JTextField jTextField;
        JComboBox jComboBox;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Memory:");
        jPanel.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myMemoryComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Instances:");
        jPanel.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myInstancesTextField = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(1, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

