/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry.application.service;

import com.intellij.javaee.cloudfoundry.agent.service.CFServiceConfigWrapper;
import com.intellij.javaee.cloudfoundry.agent.service.CFServiceTierWrapper;
import com.intellij.javaee.cloudfoundry.agent.service.CFServiceWrapper;
import com.intellij.javaee.cloudfoundry.agent.service.CFServiceWrapperImpl;
import com.intellij.javaee.cloudfoundry.agent.service.CFServicesDomain;
import com.intellij.javaee.oss.cloud.server.config.TableItemEditor;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jetbrains.annotations.Nullable;

public class NewAppServiceEditor
implements TableItemEditor<CFServiceWrapper> {
    private JComboBox myConfigComboBox;
    private JTextField myNameTextField;
    private JTextField myDescriptionTextField;
    private JComboBox myTierComboBox;
    private JPanel myMainPanel;
    private final CFServiceConfigWrapper[] myServiceConfigs;

    public NewAppServiceEditor(CFServicesDomain servicesDomain) {
        this.$$$setupUI$$$();
        this.myServiceConfigs = servicesDomain.getAvailableServiceConfigs();
        this.myConfigComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    NewAppServiceEditor.this.doSelectConfig();
                }
            }
        });
        for (CFServiceConfigWrapper serviceConfig : servicesDomain.getAvailableServiceConfigs()) {
            this.myConfigComboBox.addItem(NewAppServiceEditor.getConfigText(serviceConfig));
        }
    }

    @Nullable
    private CFServiceConfigWrapper getSelectedConfig() {
        int selectedIndex = this.myConfigComboBox.getSelectedIndex();
        return selectedIndex == -1 ? null : this.myServiceConfigs[selectedIndex];
    }

    private void doSelectConfig() {
        this.myTierComboBox.removeAllItems();
        CFServiceConfigWrapper selectedConfig = this.getSelectedConfig();
        if (selectedConfig == null) {
            this.myDescriptionTextField.setText("");
        } else {
            for (CFServiceTierWrapper tier : selectedConfig.getTiers()) {
                this.myTierComboBox.addItem(tier.getType());
            }
            this.myDescriptionTextField.setText(selectedConfig.getDescription());
        }
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    private static String getConfigText(CFServiceConfigWrapper serviceConfig) {
        return serviceConfig.getType() + ": " + serviceConfig.getVendor() + " " + serviceConfig.getVersion();
    }

    public CFServiceWrapper createNewItem() throws ConfigurationException {
        String name = this.myNameTextField.getText();
        if (StringUtil.isEmpty((String)name)) {
            throw new ConfigurationException("Name required");
        }
        CFServiceConfigWrapper selectedConfig = this.getSelectedConfig();
        if (selectedConfig == null) {
            throw new ConfigurationException("Configuration required");
        }
        String tier = (String)this.myTierComboBox.getSelectedItem();
        if (StringUtil.isEmpty((String)tier)) {
            throw new ConfigurationException("Tier required");
        }
        return new CFServiceWrapperImpl(true, name, tier, selectedConfig.getType(), selectedConfig.getVendor(), selectedConfig.getVersion());
    }

    public String getTitle() {
        return "Service";
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JTextField jTextField;
        JTextField jTextField2;
        JComboBox jComboBox2;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Configuration:");
        jPanel.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myConfigComboBox = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Name:");
        jPanel.add((Component)jBLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myNameTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(0, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myDescriptionTextField = jTextField = new JTextField();
        jTextField.setEditable(false);
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myTierComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Tier:");
        jPanel.add((Component)jBLabel3, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        JLabel jLabel = new JLabel();
        jLabel.setText("Description:");
        jPanel.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        jBLabel.setLabelFor(jComboBox2);
        jBLabel2.setLabelFor(jTextField2);
        jBLabel3.setLabelFor(jComboBox);
        jLabel.setLabelFor(jTextField);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

