/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.cloudfoundry;

import com.intellij.javaee.cloudfoundry.CFVersion;

public enum CFProvider {
    PIVOTAL("Pivotal (api.run.pivotal.io)", "http://api.run.pivotal.io", CFVersion.V2, "cfapps.io"),
    APPFOG("AppFog (api.appfog.com)", "https://api.appfog.com", CFVersion.V1, null),
    IBM_BLUEMIX("IBM BlueMix (api.ng.bluemix.net)", "https://api.ng.bluemix.net", CFVersion.V2, "mybluemix.net"),
    UHURUCLOUD("Uhuru (api.uhurucloud.com)", "http://api.uhurucloud.com", CFVersion.V2, null),
    STATIC("Static (api.static.me)", "http://api.static.me", CFVersion.V2, null),
    IRONFOUNDRY("Tier 3 (api.ironfoundry.me)", "http://api.ironfoundry.me", CFVersion.V2, null),
    MOPAAS("MoPaaS (api.mopaas.com)", "http://api.mopaas.com", CFVersion.V1, "sturgeon.mopaas.com"),
    CLOUDNPAAS("Global ICT Partner (api.cloudnpaas.com)", "http://api.cloudnpaas.com", CFVersion.V2, null);

    private final String myName;
    private final String myApiUrl;
    private final String myDomain;
    private final CFVersion myVersion;

    private CFProvider(String name, String apiUrl, CFVersion version, String domain) {
        this.myName = name;
        this.myApiUrl = apiUrl;
        this.myDomain = domain;
        this.myVersion = version;
    }

    public String toString() {
        return this.myName;
    }

    public String getDomain() {
        return this.myDomain;
    }

    public String getApiUrl() {
        return this.myApiUrl;
    }

    public CFVersion getVersion() {
        return this.myVersion;
    }
}

