/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import java.awt.geom.Point2D;
import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.concurrent.ConcurrentHashMap;
import sun.font.Font2D;
import sun.font.FontManagerNativeLibrary;
import sun.font.FontStrike;
import sun.font.FontStrikeDesc;
import sun.font.GlyphLayout;
import sun.font.TextRecord;
import sun.security.action.GetPropertyAction;

public final class SunLayoutEngine
implements GlyphLayout.LayoutEngine,
GlyphLayout.LayoutEngineFactory {
    private static final boolean useICU;
    private GlyphLayout.LayoutEngineKey key;
    private static GlyphLayout.LayoutEngineFactory instance;
    private SoftReference cacheref = new SoftReference<Object>(null);

    private static native void initGVIDs();

    public static GlyphLayout.LayoutEngineFactory instance() {
        if (instance == null) {
            instance = new SunLayoutEngine();
        }
        return instance;
    }

    private SunLayoutEngine() {
    }

    @Override
    public GlyphLayout.LayoutEngine getEngine(Font2D font2D, int n, int n2) {
        return this.getEngine(new GlyphLayout.LayoutEngineKey(font2D, n, n2));
    }

    @Override
    public GlyphLayout.LayoutEngine getEngine(GlyphLayout.LayoutEngineKey layoutEngineKey) {
        GlyphLayout.LayoutEngine layoutEngine;
        ConcurrentHashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine> concurrentHashMap = (ConcurrentHashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine>)this.cacheref.get();
        if (concurrentHashMap == null) {
            concurrentHashMap = new ConcurrentHashMap<GlyphLayout.LayoutEngineKey, GlyphLayout.LayoutEngine>();
            this.cacheref = new SoftReference(concurrentHashMap);
        }
        if ((layoutEngine = (GlyphLayout.LayoutEngine)concurrentHashMap.get(layoutEngineKey)) == null) {
            GlyphLayout.LayoutEngineKey layoutEngineKey2 = layoutEngineKey.copy();
            layoutEngine = new SunLayoutEngine(layoutEngineKey2);
            concurrentHashMap.put(layoutEngineKey2, layoutEngine);
        }
        return layoutEngine;
    }

    private SunLayoutEngine(GlyphLayout.LayoutEngineKey layoutEngineKey) {
        this.key = layoutEngineKey;
    }

    @Override
    public void layout(FontStrikeDesc fontStrikeDesc, float[] fArray, float f, int n, int n2, TextRecord textRecord, int n3, Point2D.Float float_, GlyphLayout.GVData gVData) {
        Font2D font2D = this.key.font();
        FontStrike fontStrike = font2D.getStrike(fontStrikeDesc);
        long l = font2D.getLayoutTableCache();
        if (useICU) {
            SunLayoutEngine.nativeLayout(font2D, fontStrike, fArray, n, n2, textRecord.text, textRecord.start, textRecord.limit, textRecord.min, textRecord.max, this.key.script(), this.key.lang(), n3, float_, gVData, font2D.getUnitsPerEm(), l);
        } else {
            SunLayoutEngine.shape(font2D, fontStrike, f, fArray, font2D.getHarfbuzzFacePtr(), font2D.getPlatformNativeFontPtr(), font2D.isAAT(), textRecord.text, gVData, this.key.script(), textRecord.start, textRecord.limit, n2, float_, n3, n);
        }
    }

    private static native void nativeLayout(Font2D var0, FontStrike var1, float[] var2, int var3, int var4, char[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, Point2D.Float var13, GlyphLayout.GVData var14, long var15, long var17);

    private static native boolean shape(Font2D var0, FontStrike var1, float var2, float[] var3, long var4, long var6, boolean var8, char[] var9, GlyphLayout.GVData var10, int var11, int var12, int var13, int var14, Point2D.Float var15, int var16, int var17);

    static {
        FontManagerNativeLibrary.load();
        SunLayoutEngine.initGVIDs();
        String string = AccessController.doPrivileged(new GetPropertyAction("sun.font.layoutengine", ""));
        useICU = string.equals("icu");
        String string2 = AccessController.doPrivileged(new GetPropertyAction("sun.font.layoutengine.verbose", ""));
        if ("true".equalsIgnoreCase(string2)) {
            System.out.println("Using " + (useICU ? "icu." : "harfbuzz."));
        }
    }
}

