/*
 * Decompiled with CFR 0.152.
 */
package sun.font;

import sun.font.ScriptRunData;

public final class ScriptRun {
    private char[] text;
    private int textStart;
    private int textLimit;
    private int scriptStart;
    private int scriptLimit;
    private int scriptCode;
    private int[] stack;
    private int parenSP;
    private boolean handlePairedChars;
    static final int SURROGATE_START = 65536;
    static final int LEAD_START = 55296;
    static final int LEAD_LIMIT = 56320;
    static final int TAIL_START = 56320;
    static final int TAIL_LIMIT = 57344;
    static final int LEAD_SURROGATE_SHIFT = 10;
    static final int SURROGATE_OFFSET = -56613888;
    static final int DONE = -1;
    private static int[] pairedChars = new int[]{40, 41, 60, 62, 91, 93, 123, 125, 171, 187, 8216, 8217, 8220, 8221, 8249, 8250, 12296, 12297, 12298, 12299, 12300, 12301, 12302, 12303, 12304, 12305, 12308, 12309, 12310, 12311, 12312, 12313, 12314, 12315};
    private static final int pairedCharPower = 1 << ScriptRun.highBit(pairedChars.length);
    private static final int pairedCharExtra = pairedChars.length - pairedCharPower;

    public ScriptRun() {
    }

    public ScriptRun(char[] cArray, int n, int n2) {
        this.init(cArray, n, n2);
    }

    public void init(char[] cArray, int n, int n2) {
        this.init(cArray, n, n2, true);
    }

    public void init(char[] cArray, int n, int n2, boolean bl) {
        if (cArray == null || n < 0 || n2 < 0 || n2 > cArray.length - n) {
            throw new IllegalArgumentException();
        }
        this.text = cArray;
        this.textStart = n;
        this.textLimit = n + n2;
        this.scriptStart = this.textStart;
        this.scriptLimit = this.textStart;
        this.scriptCode = -1;
        this.parenSP = 0;
        this.handlePairedChars = bl;
    }

    public final int getScriptStart() {
        return this.scriptStart;
    }

    public final int getScriptLimit() {
        return this.scriptLimit;
    }

    public final int getScriptCode() {
        return this.scriptCode;
    }

    public final boolean next() {
        int n;
        int n2 = this.parenSP;
        if (this.scriptLimit >= this.textLimit) {
            return false;
        }
        this.scriptCode = 0;
        this.scriptStart = this.scriptLimit;
        while ((n = this.nextCodePoint()) != -1) {
            int n3;
            int n4 = ScriptRunData.getScript(n);
            int n5 = n3 = this.handlePairedChars && n4 == 0 ? ScriptRun.getPairIndex(n) : -1;
            if (n3 >= 0) {
                if ((n3 & 1) == 0) {
                    if (this.stack == null) {
                        this.stack = new int[32];
                    } else if (this.parenSP == this.stack.length) {
                        int[] nArray = new int[this.stack.length + 32];
                        System.arraycopy(this.stack, 0, nArray, 0, this.stack.length);
                        this.stack = nArray;
                    }
                    this.stack[this.parenSP++] = n3;
                    this.stack[this.parenSP++] = this.scriptCode;
                } else if (this.parenSP > 0) {
                    int n6 = n3 & 0xFFFFFFFE;
                    while ((this.parenSP -= 2) >= 0 && this.stack[this.parenSP] != n6) {
                    }
                    if (this.parenSP >= 0) {
                        n4 = this.stack[this.parenSP + 1];
                    } else {
                        this.parenSP = 0;
                    }
                    if (this.parenSP < n2) {
                        n2 = this.parenSP;
                    }
                }
            }
            if (ScriptRun.sameScript(this.scriptCode, n4)) {
                if (this.scriptCode <= 1 && n4 > 1) {
                    this.scriptCode = n4;
                    while (n2 < this.parenSP) {
                        this.stack[n2 + 1] = this.scriptCode;
                        n2 += 2;
                    }
                }
                if (n3 <= 0 || (n3 & 1) == 0 || this.parenSP <= 0) continue;
                this.parenSP -= 2;
                continue;
            }
            this.pushback(n);
            break;
        }
        return true;
    }

    private final int nextCodePoint() {
        char c;
        int n;
        if (this.scriptLimit >= this.textLimit) {
            return -1;
        }
        if ((n = this.text[this.scriptLimit++]) >= 55296 && n < 56320 && this.scriptLimit < this.textLimit && (c = this.text[this.scriptLimit]) >= '\udc00' && c < '\ue000') {
            ++this.scriptLimit;
            n = (n << 10) + c + -56613888;
        }
        return n;
    }

    private final void pushback(int n) {
        if (n >= 0) {
            this.scriptLimit = n >= 65536 ? (this.scriptLimit -= 2) : --this.scriptLimit;
        }
    }

    private static boolean sameScript(int n, int n2) {
        return n == n2 || n <= 1 || n2 <= 1;
    }

    private static final byte highBit(int n) {
        if (n <= 0) {
            return -32;
        }
        byte by = 0;
        if (n >= 65536) {
            n >>= 16;
            by = (byte)(by + 16);
        }
        if (n >= 256) {
            n >>= 8;
            by = (byte)(by + 8);
        }
        if (n >= 16) {
            n >>= 4;
            by = (byte)(by + 4);
        }
        if (n >= 4) {
            n >>= 2;
            by = (byte)(by + 2);
        }
        if (n >= 2) {
            n >>= 1;
            by = (byte)(by + 1);
        }
        return by;
    }

    private static int getPairIndex(int n) {
        int n2 = pairedCharPower;
        int n3 = 0;
        if (n >= pairedChars[pairedCharExtra]) {
            n3 = pairedCharExtra;
        }
        while (n2 > 1) {
            if (n < pairedChars[n3 + (n2 >>= 1)]) continue;
            n3 += n2;
        }
        if (pairedChars[n3] != n) {
            n3 = -1;
        }
        return n3;
    }
}

